/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.task.model.Status;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResourceData {
    private static final Logger logger = LoggerFactory.getLogger(QueryResourceData.class);
    static final String[] generalQueryParams = new String[]{"processinstanceid", "processid", "workitemid", "deploymentid"};
    static final String[] generalQueryParamsShort = new String[]{"piid", "pid", "wid", "did"};
    static final String[] taskQueryParams = new String[]{"taskid", "initiator", "stakeholder", "potentialowner", "taskowner", "businessadmin", "taskstatus"};
    static final String[] taskQueryParamsShort = new String[]{"tid", "init", "stho", "po", "to", "ba", "tst"};
    static final String[] procInstQueryParams = new String[]{"processinstancestatus", "processversion", "startdate", "enddate"};
    static final String[] procInstQueryParamsShort = new String[]{"pist", "pv", "stdt", "edt"};
    static final String[] varInstQueryParams = new String[]{"varid", "varvalue", "var", "varregex", "all"};
    static final String[] varInstQueryParamsShort = new String[]{"vid", "vv", null, "vr", null};
    public static final String[] metaRuntimeParams = new String[]{"memory", "history"};
    public static final String[] metaRuntimeParamsShort = new String[]{"mem", "hist"};
    public static final Map<Integer, String> actionParamNameMap = new ConcurrentHashMap<Integer, String>();
    public static final Map<String, Integer> paramNameActionMap = new ConcurrentHashMap<String, Integer>();
    protected static final int GENERAL_END = 4;
    protected static final int TASK_END = 11;
    protected static final int PROCESS_END = 15;
    protected static final int VARIABLE_END = 20;
    protected static final int META_END = 22;
    public static final SimpleDateFormat QUERY_PARAM_DATE_FORMAT;

    private static int addParamsToActionMap(int idGen, String[] params, String[] paramsShort) {
        if (params.length != paramsShort.length) {
            throw new IllegalStateException(params.length + " params but " + paramsShort.length + " abbreviated params!");
        }
        for (int i = 0; i < params.length; ++i) {
            int id = idGen++;
            paramNameActionMap.put(params[i], id);
            actionParamNameMap.put(id, params[i]);
            if (paramsShort[i] == null) continue;
            paramNameActionMap.put(paramsShort[i], id);
        }
        return idGen;
    }

    public static long[] getLongs(int action, String[] data) {
        int i;
        String name = actionParamNameMap.get(action);
        long[] result = new long[data.length];
        try {
            for (i = 0; i < data.length; ++i) {
                result[i] = Long.valueOf(data[i]);
            }
        }
        catch (NumberFormatException nfe) {
            throw KieRemoteRestOperationException.badRequest("Values for query parameter '" + name + "' must be long (" + data[i] + ")");
        }
        return result;
    }

    public static int[] getInts(int action, String[] data) {
        int i;
        String name = actionParamNameMap.get(action);
        int[] result = new int[data.length];
        try {
            for (i = 0; i < data.length; ++i) {
                result[i] = Integer.valueOf(data[i]);
            }
        }
        catch (NumberFormatException nfe) {
            throw KieRemoteRestOperationException.badRequest("Values for query parameter '" + name + "' must be integers (" + data[i] + ")");
        }
        return result;
    }

    public static Date[] getDates(int action, String[] data) {
        Date[] result = new Date[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = QueryResourceData.parseDate(data[i]);
        }
        return result;
    }

    private static Date parseDate(String dateStr) {
        String[] parts = dateStr.split("_");
        String[] dateParts = null;
        String[] timeParts = null;
        String parseDateStr = null;
        if (parts.length == 2) {
            dateParts = parts[0].split("-");
            if (dateParts.length != 3) {
                QueryResourceData.badDateString(dateStr);
            }
            if ((timeParts = parts[1].split(":")).length != 3) {
                QueryResourceData.badDateString(dateStr);
            }
            parseDateStr = dateStr;
        } else if (parts.length == 1) {
            dateParts = parts[0].split("-");
            timeParts = parts[0].split(":");
            if (timeParts.length == 3 && dateParts.length == 1) {
                dateParts = QUERY_PARAM_DATE_FORMAT.format(new Date()).split("_")[0].split("-");
            } else if (dateParts.length == 3 && timeParts.length == 1) {
                String[] newTimeParts = new String[]{"0", "0", "0"};
                timeParts = newTimeParts;
            } else {
                QueryResourceData.badDateString(dateStr);
            }
        } else {
            QueryResourceData.badDateString(dateStr);
        }
        if (parseDateStr == null) {
            int i;
            StringBuilder tmpStr = new StringBuilder(dateParts[0]);
            for (i = 1; i < 3; ++i) {
                tmpStr.append("-").append(dateParts[i]);
            }
            tmpStr.append("_");
            tmpStr.append(timeParts[0]);
            for (i = 1; i < 3; ++i) {
                tmpStr.append(":").append(timeParts[i]);
            }
            parseDateStr = tmpStr.toString();
        }
        try {
            return QUERY_PARAM_DATE_FORMAT.parse(parseDateStr);
        }
        catch (ParseException pe) {
            QueryResourceData.badDateString(parseDateStr);
            throw new RuntimeException("This should never be thrown", pe);
        }
    }

    private static void badDateString(String dateStr) {
        throw KieRemoteRestOperationException.badRequest("'" + dateStr + "' is not a valid format for a date value query parameter.");
    }

    public static Status[] getTaskStatuses(String[] data) {
        Status[] result = new Status[data.length];
        for (int i = 0; i < data.length; ++i) {
            if (data[i].toLowerCase().equals(Status.InProgress.toString().toLowerCase())) {
                result[i] = Status.InProgress;
                continue;
            }
            String value = data[i].substring(0, 1).toUpperCase() + data[i].substring(1);
            try {
                result[i] = Status.valueOf((String)value);
                continue;
            }
            catch (Exception e) {
                throw KieRemoteRestOperationException.badRequest("Task status '" + data[i] + "' is not valid.");
            }
        }
        return result;
    }

    static {
        int idGen = 0;
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, generalQueryParams, generalQueryParamsShort)) != 4) {
            throw new IllegalStateException("General query parameters [" + idGen + "]");
        }
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, taskQueryParams, taskQueryParamsShort)) != 11) {
            throw new IllegalStateException("Task query parameters [" + idGen + "]");
        }
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, procInstQueryParams, procInstQueryParamsShort)) != 15) {
            throw new IllegalStateException("Process instance query parameters [" + idGen + "]");
        }
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, varInstQueryParams, varInstQueryParamsShort)) != 20) {
            throw new IllegalStateException("Variable instance query parameters [" + idGen + "]");
        }
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, metaRuntimeParams, metaRuntimeParamsShort)) != 22) {
            throw new IllegalStateException("Meta parameters [" + idGen + "]");
        }
        QUERY_PARAM_DATE_FORMAT = new SimpleDateFormat("yy-MM-dd_HH:mm:ss");
    }
}

