/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.remote.services.rest.DeployResourceBase;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.api.DeploymentResource;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentDescriptor;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinitionList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class DeploymentResourceImpl
extends ResourceBase
implements DeploymentResource {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentResourceImpl.class);
    @Context
    private HttpHeaders headers;
    @PathParam(value="deploymentId")
    private String deploymentId;
    @Inject
    private DeployResourceBase deployBase;

    public Response getConfig() {
        JaxbDeploymentUnit jaxbDepUnit = this.deployBase.determineStatus(this.deploymentId, true);
        logger.debug("Returning deployment unit information for " + this.deploymentId);
        return DeploymentResourceImpl.createCorrectVariant(jaxbDepUnit, this.headers);
    }

    public Response deploy(JaxbDeploymentDescriptor deployDescriptor) {
        Map<String, String[]> params = this.getRequestParams();
        String oper = this.getRelativePath();
        String strategy = DeploymentResourceImpl.getStringParam("strategy", false, params, oper);
        String mergeMode = DeploymentResourceImpl.getStringParam("mergemode", false, params, oper);
        JaxbDeploymentJobResult jobResult = this.deployBase.submitDeployJob(this.deploymentId, strategy, mergeMode, deployDescriptor);
        return DeploymentResourceImpl.createCorrectVariant(jobResult, this.headers, Response.Status.ACCEPTED);
    }

    public Response undeploy() {
        JaxbDeploymentJobResult jobResult = this.deployBase.submitUndeployJob(this.deploymentId);
        return DeploymentResourceImpl.createCorrectVariant(jobResult, this.headers, Response.Status.ACCEPTED);
    }

    public Response listProcessDefinitions() {
        String oper = this.getRelativePath();
        Map<String, String[]> params = this.getRequestParams();
        int[] pageInfo = DeploymentResourceImpl.getPageNumAndPageSize(params, oper);
        int maxNumResults = DeploymentResourceImpl.getMaxNumResultsNeeded(pageInfo);
        JaxbProcessDefinitionList jaxbProcDefList = new JaxbProcessDefinitionList();
        this.deployBase.fillProcessDefinitionList(this.deploymentId, pageInfo, maxNumResults, jaxbProcDefList.getProcessDefinitionList());
        JaxbProcessDefinitionList resultList = DeploymentResourceImpl.paginateAndCreateResult(pageInfo, jaxbProcDefList.getProcessDefinitionList(), new JaxbProcessDefinitionList());
        return DeploymentResourceImpl.createCorrectVariant(resultList, this.headers);
    }
}

