/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.util.StringUtils;
import org.jbpm.process.audit.AuditLogService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.task.model.Status;
import org.kie.internal.query.data.QueryData;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.AbstractInternalQueryHelper;
import org.kie.remote.services.rest.query.QueryResourceData;
import org.kie.remote.services.rest.query.RemoteServicesQueryCommandBuilder;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstance;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryProcessInstanceInfo;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryProcessInstanceResult;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbVariableInfo;

public class InternalProcInstQueryHelper
extends AbstractInternalQueryHelper<JaxbQueryProcessInstanceResult> {
    public InternalProcInstQueryHelper(ResourceBase resourceBase) {
        super(resourceBase);
    }

    @Override
    protected void createAndSetQueryBuilders(String identity) {
        RemoteServicesQueryCommandBuilder procInstLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        this.setQueryBuilders(procInstLogQueryBuilder, varInstLogQueryBuilder);
    }

    @Override
    public JaxbQueryProcessInstanceResult doQueryAndCreateResultObjects(boolean onlyRetrieveLastVarLogs, boolean workFlowInstanceVariables) {
        RemoteServicesQueryCommandBuilder procInstLogQueryBuilder = this.getQueryBuilders()[0];
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = this.getQueryBuilders()[1];
        AuditLogService auditLogService = this.resourceBase.getAuditLogService();
        if (onlyRetrieveLastVarLogs) {
            if (this.variableCriteriaInQuery(procInstLogQueryBuilder.getQueryData())) {
                procInstLogQueryBuilder.last();
            }
            varInstLogQueryBuilder.last();
        }
        List procLogs = auditLogService.queryProcessInstanceLogs(procInstLogQueryBuilder.getQueryData());
        List varLogs = auditLogService.queryVariableInstanceLogs(varInstLogQueryBuilder.getQueryData());
        List<JaxbVariableInfo> procVars = null;
        if (workFlowInstanceVariables) {
            for (VariableInstanceLog varLog : varLogs) {
            }
        }
        JaxbQueryProcessInstanceResult result = this.createProcessInstanceResult(procLogs, varLogs, procVars);
        return result;
    }

    private JaxbQueryProcessInstanceResult createProcessInstanceResult(List<ProcessInstanceLog> procLogs, List<VariableInstanceLog> varLogs, List<JaxbVariableInfo> processVariables) {
        JaxbQueryProcessInstanceInfo procInfo;
        long procInstId;
        JaxbQueryProcessInstanceResult result = new JaxbQueryProcessInstanceResult();
        HashMap<Long, JaxbQueryProcessInstanceInfo> procInstIdProcInstInfoMap = new HashMap<Long, JaxbQueryProcessInstanceInfo>();
        for (ProcessInstanceLog procLog : procLogs) {
            procInstId = procLog.getProcessInstanceId();
            procInfo = InternalProcInstQueryHelper.getQueryProcessInstanceInfo(procInstId, procInstIdProcInstInfoMap);
            procInfo.setProcessInstance(new JaxbProcessInstance(procLog));
        }
        for (VariableInstanceLog varLog : varLogs) {
            procInstId = varLog.getProcessInstanceId();
            procInfo = (JaxbQueryProcessInstanceInfo)procInstIdProcInstInfoMap.get(procInstId);
            if (procInfo == null) {
                this.throwDebugExceptionWithQueryInformation();
            }
            procInfo.getVariables().add(new JaxbVariableInfo(varLog));
        }
        result.getProcessInstanceInfoList().addAll(procInstIdProcInstInfoMap.values());
        return result;
    }

    private void throwDebugExceptionWithQueryInformation() {
        StringBuilder message = new StringBuilder("Please contact the developers: the following query retrieved variable instance logs without retrieving the associated process instance logs:\n");
        QueryData queryData = this.getQueryBuilders()[0].getQueryData();
        for (Map.Entry entry : queryData.getIntersectParameters().entrySet()) {
            message.append("[" + (String)entry.getKey() + ":" + StringUtils.collectionToDelimitedString((Collection)((Collection)entry.getValue()), (String)",") + "], ");
        }
        for (Map.Entry entry : queryData.getIntersectRangeParameters().entrySet()) {
            message.append("[ (m/m) " + (String)entry.getKey() + ":" + StringUtils.collectionToDelimitedString((Collection)((Collection)entry.getValue()), (String)",") + "], ");
        }
        for (Map.Entry entry : queryData.getIntersectRegexParameters().entrySet()) {
            message.append("[ (re) " + (String)entry.getKey() + ":" + StringUtils.collectionToDelimitedString((Collection)((Collection)entry.getValue()), (String)",") + "], ");
        }
        throw KieRemoteRestOperationException.internalServerError(message.toString());
    }

    private static JaxbQueryProcessInstanceInfo getQueryProcessInstanceInfo(long procInstId, Map<Long, JaxbQueryProcessInstanceInfo> procInstIdProcInstInfoMap) {
        JaxbQueryProcessInstanceInfo procInstInfo = procInstIdProcInstInfoMap.get(procInstId);
        if (procInstInfo == null) {
            procInstInfo = new JaxbQueryProcessInstanceInfo();
            procInstIdProcInstInfoMap.put(procInstId, procInstInfo);
        }
        return procInstInfo;
    }

    @Override
    public void taskId(long[] longData) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[0]);
    }

    @Override
    public void initiator(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[1]);
    }

    @Override
    public void stakeHolder(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[2]);
    }

    @Override
    public void potentialOwner(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[3]);
    }

    @Override
    public void taskOwner(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[4]);
    }

    @Override
    public void businessAdmin(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[5]);
    }

    @Override
    public void taskStatus(Status[] statuses) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[6]);
    }

    public static void badParameter(String paramName) {
        throw KieRemoteRestOperationException.badRequest("'" + paramName + "' is not an accepted parameter for the rich process instance query operation");
    }
}

