/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.kie.api.command.Command;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.remote.common.rest.RestEasy960Util;
import org.kie.remote.services.AcceptedServerCommands;
import org.kie.remote.services.cdi.ProcessRequestBean;
import org.kie.remote.services.jaxb.JaxbCommandsRequest;
import org.kie.remote.services.jaxb.JaxbCommandsResponse;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.services.client.serialization.jaxb.impl.JaxbPaginatedList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBase {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceBase.class);
    @Inject
    protected ProcessRequestBean processRequestBean;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletRequest httpRequest;
    static String PAGE_LONG_PARAM = "page";
    static String PAGE_SHORT_PARAM = "p";
    static String SIZE_LONG_PARAM = "pagesize";
    static String SIZE_SHORT_PARAM = "s";
    public static Set<String> paginationParams = new HashSet<String>();
    public static final String PROC_INST_ID_PARAM_NAME = "runtimeProcInstId";
    private static final String[] EMPTY_STRING_ARR;
    static int PAGE_NUM;
    static int PAGE_SIZE;

    public void setProcessRequestBean(ProcessRequestBean processRequestBean) {
        this.processRequestBean = processRequestBean;
    }

    void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    void setHttpServletRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public AuditLogService getAuditLogService() {
        return this.processRequestBean.getAuditLogService();
    }

    protected JaxbCommandsResponse restProcessJaxbCommandsRequest(JaxbCommandsRequest request) {
        JaxbCommandsResponse jaxbResponse = new JaxbCommandsResponse(request);
        List<Command> commands = request.getCommands();
        if (commands != null) {
            Command cmd;
            int i;
            int cmdListSize = commands.size();
            for (i = 0; i < cmdListSize; ++i) {
                cmd = commands.get(i);
                if (AcceptedServerCommands.isAcceptedCommandClass(cmd.getClass())) continue;
                throw KieRemoteRestOperationException.forbidden("The execute REST operation does not accept " + cmd.getClass().getName() + " instances.");
            }
            for (i = 0; i < cmdListSize; ++i) {
                cmd = commands.get(i);
                this.processRequestBean.processCommand(cmd, request, i, jaxbResponse);
            }
        }
        if (commands == null || commands.isEmpty()) {
            logger.info("Commands request object with no commands sent!");
        }
        return jaxbResponse;
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers) {
        return ResourceBase.createCorrectVariant(responseObj, headers, null);
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Response.Status status) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v == null) {
            v = RestEasy960Util.defaultVariant;
        }
        responseBuilder = status != null ? Response.status((Response.Status)status).entity(responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        return responseBuilder.build();
    }

    protected Map<String, String[]> getRequestParams() {
        return this.httpRequest.getParameterMap();
    }

    protected static String getStringParam(String paramName, boolean required, Map<String, String[]> params, String operation) {
        String[] paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        if (!required && paramValues.length == 0) {
            return null;
        }
        if (paramValues.length != 1) {
            throw KieRemoteRestOperationException.badRequest("One and only one '" + paramName + "' query parameter required for '" + operation + "' operation (" + paramValues.length + " passed).");
        }
        return paramValues[0];
    }

    protected static List<String> getStringListParamAsList(String paramName, boolean required, Map<String, String[]> params, String operation) {
        String[] strList = ResourceBase.getStringListParam(paramName, required, params, operation);
        if (strList.length == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(strList);
    }

    protected static String[] getStringListParam(String paramName, boolean required, Map<String, String[]> params, String operation) {
        String[] paramValues = null;
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(paramName)) continue;
            paramValues = entry.getValue();
            break;
        }
        if (paramValues == null) {
            if (required) {
                throw KieRemoteRestOperationException.badRequest("Query parameter '" + paramName + "' required for '" + operation + "' operation.");
            }
            return EMPTY_STRING_ARR;
        }
        return paramValues;
    }

    protected static Object getObjectParam(String paramName, boolean required, Map<String, String[]> params, String operation) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getObjectFromString(paramName, paramVal);
    }

    protected static List<Long> getLongListParam(String paramName, boolean required, Map<String, String[]> params, String operation, boolean mustBeLong) {
        String[] paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (String strVal : paramValues) {
            longValues.add((Long)ResourceBase.getNumberFromString(paramName, strVal, mustBeLong));
        }
        return longValues;
    }

    protected static Number getNumberParam(String paramName, boolean required, Map<String, String[]> params, String operation, boolean mustBeLong) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getNumberFromString(paramName, paramVal, mustBeLong);
    }

    private static Object getObjectFromString(String key, String mapVal) {
        if (mapVal.matches("^\".*\"$")) {
            return mapVal.substring(1, mapVal.length() - 1);
        }
        if (!mapVal.matches("^\\d+[li]?$")) {
            return mapVal;
        }
        return ResourceBase.getNumberFromString(key, mapVal, false);
    }

    private static Number getNumberFromString(String paramName, String paramVal, boolean mustBeLong) {
        if (paramVal.matches("^\\d+[li]?$")) {
            if (paramVal.matches(".*i$")) {
                if (mustBeLong) {
                    throw KieRemoteRestOperationException.badRequest(paramName + " parameter is numerical but contains the \"Integer\" suffix 'i' and must have no suffix or \"Long\" suffix 'l' (" + paramVal + ")");
                }
                if ((paramVal = paramVal.substring(0, paramVal.length() - 1)).length() > 9) {
                    throw KieRemoteRestOperationException.badRequest(paramName + " parameter is numerical but too large to be an integer (" + paramVal + "i)");
                }
                return Integer.parseInt(paramVal);
            }
            if (paramVal.length() > 18) {
                throw KieRemoteRestOperationException.badRequest(paramName + " parameter is numerical but too large to be a long (" + paramVal + ")");
            }
            if (paramVal.matches(".*l$")) {
                paramVal = paramVal.substring(0, paramVal.length() - 1);
            }
            return Long.parseLong(paramVal);
        }
        throw KieRemoteRestOperationException.badRequest(paramName + " parameter does not have a numerical format (" + paramVal + ")");
    }

    protected static Map<String, Object> extractMapFromParams(Map<String, String[]> params, String operation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            if (!entry.getKey().startsWith("map_")) continue;
            String key = entry.getKey();
            String[] paramValues = entry.getValue();
            if (paramValues.length != 1) {
                throw KieRemoteRestOperationException.badRequest("Only one map_* (" + key + ") query parameter allowed for '" + operation + "' operation (" + paramValues.length + " passed).");
            }
            String mapKey = key.substring("map_".length());
            String mapVal = paramValues[0].trim();
            map.put(mapKey, ResourceBase.getObjectFromString(key, mapVal));
        }
        return map;
    }

    protected static List<OrganizationalEntity> getOrganizationalEntityListFromParams(Map<String, String[]> params, boolean required, String operation) {
        User newuser;
        ArrayList<OrganizationalEntity> orgEntList = new ArrayList<OrganizationalEntity>();
        String[] users = ResourceBase.getStringListParam("user", false, params, operation);
        String[] groups = ResourceBase.getStringListParam("group", false, params, operation);
        if (required && users.length == 0 && groups.length == 0) {
            throw KieRemoteRestOperationException.badRequest("At least 1 query parameter (either 'user' or 'group') is required for the '" + operation + "' operation.");
        }
        for (String user : users) {
            newuser = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)newuser).setId(user);
            orgEntList.add((OrganizationalEntity)newuser);
        }
        for (String group : groups) {
            newuser = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)newuser).setId(group);
            orgEntList.add((OrganizationalEntity)newuser);
        }
        return orgEntList;
    }

    protected static TaskSummaryImpl convertTaskToTaskSummary(InternalTask task) {
        TaskSummaryImpl taskSummary = new TaskSummaryImpl(task.getId().longValue(), ((I18NText)task.getNames().get(0)).getText(), ((I18NText)task.getSubjects().get(0)).getText(), ((I18NText)task.getDescriptions().get(0)).getText(), task.getTaskData().getStatus(), task.getPriority(), task.getTaskData().isSkipable(), task.getTaskData().getActualOwner(), task.getTaskData().getCreatedBy(), task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getTaskData().getProcessInstanceId(), task.getTaskData().getDeploymentId(), task.getSubTaskStrategy(), task.getTaskData().getParentId());
        return taskSummary;
    }

    protected static List<Status> convertStringListToStatusList(List<String> statusStrList) {
        ArrayList<Status> statuses = null;
        if (statusStrList != null && !statusStrList.isEmpty()) {
            statuses = new ArrayList<Status>();
            for (String statusStr : statusStrList) {
                try {
                    statuses.add(ResourceBase.getEnum(statusStr));
                }
                catch (IllegalArgumentException iae) {
                    throw KieRemoteRestOperationException.badRequest(statusStr + " is not a valid status type for a task.");
                }
            }
        }
        return statuses;
    }

    protected static int[] getPageNumAndPageSize(Map<String, String[]> params, String oper) {
        int[] pageInfo = new int[2];
        int p = 0;
        Number page = ResourceBase.getNumberParam(PAGE_LONG_PARAM, false, params, oper, false);
        if (page != null) {
            p = page.intValue();
        } else {
            Number pageShort = ResourceBase.getNumberParam(PAGE_SHORT_PARAM, false, params, oper, false);
            if (pageShort != null) {
                p = pageShort.intValue();
            }
        }
        if (p < 0) {
            p = 0;
        }
        int s = 0;
        Number pageSize = ResourceBase.getNumberParam(SIZE_LONG_PARAM, false, params, oper, false);
        if (pageSize != null) {
            s = pageSize.intValue();
        } else {
            Number pageSizeShort = ResourceBase.getNumberParam(SIZE_SHORT_PARAM, false, params, oper, false);
            if (pageSizeShort != null) {
                s = pageSizeShort.intValue();
            }
        }
        if (s < 0) {
            s = 0;
        }
        pageInfo[ResourceBase.PAGE_NUM] = p;
        pageInfo[ResourceBase.PAGE_SIZE] = s;
        return pageInfo;
    }

    protected static <T> List<T> paginate(int[] pageInfo, List<T> results) {
        ArrayList<T> pagedResults = new ArrayList<T>();
        assert (pageInfo[0] >= 0);
        if (pageInfo[1] > 0 && pageInfo[0] == 0) {
            pageInfo[0] = 1;
        }
        if (pageInfo[0] == 0 && pageInfo[1] == 0) {
            return results;
        }
        if (pageInfo[0] > 0) {
            for (int i = (pageInfo[0] - 1) * pageInfo[1]; i < pageInfo[0] * pageInfo[1] && i < results.size(); ++i) {
                pagedResults.add(results.get(i));
            }
        }
        return pagedResults;
    }

    protected static int getMaxNumResultsNeeded(int[] pageInfo) {
        int numResults = pageInfo[PAGE_NUM] * pageInfo[PAGE_SIZE];
        if (numResults == 0) {
            numResults = 1000;
        }
        return numResults;
    }

    protected static <T, R extends JaxbPaginatedList<T>> R paginateAndCreateResult(Map<String, String[]> params, String oper, List<T> results, R resultList) {
        int[] pageInfo = ResourceBase.getPageNumAndPageSize(params, oper);
        return ResourceBase.paginateAndCreateResult(pageInfo, results, resultList);
    }

    protected static <T, R extends JaxbPaginatedList<T>> R paginateAndCreateResult(int[] pageInfo, List<T> results, R resultList) {
        if (pageInfo[0] == 0 && pageInfo[1] == 0) {
            resultList.addContents(results);
            return resultList;
        }
        results = ResourceBase.paginate(pageInfo, results);
        resultList.addContents(results);
        resultList.setPageNumber(Integer.valueOf(pageInfo[PAGE_NUM]));
        resultList.setPageSize(Integer.valueOf(pageInfo[PAGE_SIZE]));
        return resultList;
    }

    protected String getBaseUri() {
        return this.uriInfo.getBaseUri().toString();
    }

    protected String getRequestUri() {
        return this.httpRequest.getRequestURI();
    }

    protected String getRelativePath() {
        String url = this.httpRequest.getRequestURI();
        url.replaceAll(".*/rest", "");
        return url;
    }

    protected static Status getEnum(String value) {
        value = value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
        try {
            return Status.valueOf((String)value);
        }
        catch (IllegalArgumentException iae) {
            if (value.equalsIgnoreCase("inprogress")) {
                return Status.InProgress;
            }
            throw iae;
        }
    }

    protected JaxbProcessDefinition convertProcAssetDescToJaxbProcDef(ProcessDefinition procAssetDesc) {
        JaxbProcessDefinition jaxbProcDef = new JaxbProcessDefinition();
        jaxbProcDef.setDeploymentId(((ProcessAssetDesc)procAssetDesc).getDeploymentId());
        jaxbProcDef.setForms(((ProcessAssetDesc)procAssetDesc).getForms());
        jaxbProcDef.setId(procAssetDesc.getId());
        jaxbProcDef.setName(procAssetDesc.getName());
        jaxbProcDef.setPackageName(procAssetDesc.getPackageName());
        jaxbProcDef.setVersion(procAssetDesc.getVersion());
        return jaxbProcDef;
    }

    public <T> T doRestTaskOperation(TaskCommand<T> cmd) {
        return this.processRequestBean.doRestTaskOperation(null, null, null, null, cmd);
    }

    protected <T> T doRestTaskOperationWithTaskId(Long taskId, TaskCommand<T> cmd) {
        return this.processRequestBean.doRestTaskOperation(taskId, null, null, null, cmd);
    }

    protected <T> T doRestTaskOperationWithDeploymentId(String deploymentId, TaskCommand<T> cmd) {
        return this.processRequestBean.doRestTaskOperation(null, deploymentId, null, null, cmd);
    }

    static {
        paginationParams.add(PAGE_LONG_PARAM);
        paginationParams.add(PAGE_SHORT_PARAM);
        paginationParams.add(SIZE_LONG_PARAM);
        paginationParams.add(SIZE_SHORT_PARAM);
        EMPTY_STRING_ARR = new String[0];
        PAGE_NUM = 0;
        PAGE_SIZE = 1;
    }
}

