/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.services.task.commands.TaskQueryDataCommand;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.data.QueryData;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.AbstractInternalQueryHelper;
import org.kie.remote.services.rest.query.RemoteServicesQueryCommandBuilder;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryTaskInfo;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryTaskResult;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbVariableInfo;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskSummary;

public class InternalTaskQueryHelper
extends AbstractInternalQueryHelper<JaxbQueryTaskResult> {
    public InternalTaskQueryHelper(ResourceBase resourceBase) {
        super(resourceBase);
    }

    @Override
    protected void createAndSetQueryBuilders(String identity) {
        if (identity == null || identity.trim().isEmpty()) {
            throw KieRemoteRestOperationException.forbidden("Unknown and unauthorized user [" + identity + "] when querying tasks");
        }
        RemoteServicesQueryCommandBuilder taskQueryBuilder = new RemoteServicesQueryCommandBuilder(identity);
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        this.setQueryBuilders(taskQueryBuilder, varInstLogQueryBuilder);
    }

    @Override
    public JaxbQueryTaskResult doQueryAndCreateResultObjects(boolean onlyRetrieveLastVarLogs, boolean workFlowInstanceVariables) {
        RemoteServicesQueryCommandBuilder[] queryBuilders = this.getQueryBuilders();
        RemoteServicesQueryCommandBuilder taskQueryBuilder = queryBuilders[0];
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = queryBuilders[1];
        if (this.variableCriteriaInQuery(varInstLogQueryBuilder.getQueryData()) && onlyRetrieveLastVarLogs) {
            taskQueryBuilder.last();
            varInstLogQueryBuilder.last();
        }
        QueryData varLogQueryData = new QueryData(varInstLogQueryBuilder.getQueryData());
        TaskQueryDataCommand taskCmd = taskQueryBuilder.createTaskQueryDataCommand();
        List taskSummaries = (List)this.resourceBase.doRestTaskOperation(taskCmd);
        List varLogs = this.resourceBase.getAuditLogService().queryVariableInstanceLogs(varLogQueryData);
        List<JaxbVariableInfo> procVars = null;
        if (workFlowInstanceVariables) {
            for (VariableInstanceLog varLog : varLogs) {
            }
        }
        JaxbQueryTaskResult result = InternalTaskQueryHelper.createQueryTaskResult(taskSummaries, varLogs, procVars);
        return result;
    }

    private static JaxbQueryTaskResult createQueryTaskResult(List<TaskSummary> taskSummaries, List<VariableInstanceLog> varLogs, List<JaxbVariableInfo> processVariables) {
        JaxbQueryTaskInfo taskInfo;
        long procInstId;
        JaxbQueryTaskResult result = new JaxbQueryTaskResult();
        HashMap<Long, JaxbQueryTaskInfo> procInstIdTaskInfoMap = new HashMap<Long, JaxbQueryTaskInfo>();
        for (TaskSummary taskSum : taskSummaries) {
            procInstId = taskSum.getProcessInstanceId();
            taskInfo = InternalTaskQueryHelper.createJaxbQueryTaskInfo(procInstId, procInstIdTaskInfoMap);
            taskInfo.getTaskSummaries().add(new JaxbTaskSummary(taskSum));
        }
        for (VariableInstanceLog varLog : varLogs) {
            procInstId = varLog.getProcessInstanceId();
            taskInfo = InternalTaskQueryHelper.createJaxbQueryTaskInfo(procInstId, procInstIdTaskInfoMap);
            taskInfo.getVariables().add(new JaxbVariableInfo(varLog));
        }
        result.getTaskInfoList().addAll(procInstIdTaskInfoMap.values());
        return result;
    }

    private static JaxbQueryTaskInfo createJaxbQueryTaskInfo(long procInstId, Map<Long, JaxbQueryTaskInfo> procInstIdTaskInfoMap) {
        JaxbQueryTaskInfo taskInfo = procInstIdTaskInfoMap.get(procInstId);
        if (taskInfo == null) {
            taskInfo = new JaxbQueryTaskInfo(procInstId);
            procInstIdTaskInfoMap.put(procInstId, taskInfo);
        }
        return taskInfo;
    }
}

