/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.cdi;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartCorrelatedProcessCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.command.runtime.rule.UpdateCommand;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.command.AuditCommand;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.ProcessService;
import org.jbpm.services.api.TaskNotFoundException;
import org.jbpm.services.api.UserTaskService;
import org.jbpm.services.task.commands.AddTaskCommand;
import org.jbpm.services.task.commands.CompleteTaskCommand;
import org.jbpm.services.task.commands.FailTaskCommand;
import org.jbpm.services.task.commands.GetContentCommand;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.jbpm.services.task.commands.GetTaskContentCommand;
import org.jbpm.services.task.commands.SkipTaskCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.kie.api.command.Command;
import org.kie.api.task.model.Task;
import org.kie.remote.services.AcceptedServerCommands;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.remote.services.exception.KieRemoteServicesDeploymentException;
import org.kie.remote.services.jaxb.JaxbCommandsRequest;
import org.kie.remote.services.jaxb.JaxbCommandsResponse;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.util.ExecuteAndSerializeCommand;
import org.kie.services.client.serialization.jaxb.impl.JaxbRequestStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

@ApplicationScoped
public class ProcessRequestBean {
    private static final Logger logger = LoggerFactory.getLogger(ProcessRequestBean.class);
    @Inject
    private ProcessService processService;
    @Inject
    private UserTaskService userTaskService;
    private static final String PERSISTENCE_UNIT_NAME = "org.jbpm.domain";
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;
    private AuditLogService auditLogService;
    private static Set<Class<? extends TaskCommand>> taskDeploymentIdCommands = new HashSet<Class<? extends TaskCommand>>();

    public void setProcessService(ProcessService processService) {
        this.processService = processService;
    }

    public void setUserTaskService(UserTaskService userTaskService) {
        this.userTaskService = userTaskService;
    }

    public void setAuditLogService(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    @PostConstruct
    public void initAuditLogService() {
        this.auditLogService = new JPAAuditLogService(this.emf);
        if (this.emf == null) {
            ((JPAAuditLogService)this.auditLogService).setPersistenceUnitName(PERSISTENCE_UNIT_NAME);
        }
    }

    public AuditLogService getAuditLogService() {
        return this.auditLogService;
    }

    public void processCommand(Command cmd, JaxbCommandsRequest request, int i, JaxbCommandsResponse jaxbResponse) {
        String version = request.getVersion();
        if (version == null) {
            version = "pre-6.0.3";
        }
        if (!version.equals("6.3.0.1")) {
            logger.warn("Request received from client version [{}] while server is version [{}]! THIS MAY CAUSE PROBLEMS!", (Object)version, (Object)"6.3.0.1");
        }
        jaxbResponse.setVersion("6.3.0.1");
        String cmdName = cmd.getClass().getSimpleName();
        logger.debug("Processing command " + cmdName);
        String errMsg = "Unable to execute " + cmdName + "/" + i;
        Object cmdResult = null;
        try {
            this.preprocessCommand(cmd);
            if (cmd instanceof TaskCommand) {
                TaskCommand taskCmd = (TaskCommand)cmd;
                cmdResult = this.doTaskOperation(taskCmd.getTaskId(), request.getDeploymentId(), request.getProcessInstanceId(), null, taskCmd);
            } else if (cmd instanceof AuditCommand) {
                AuditCommand auditCmd = (AuditCommand)cmd;
                auditCmd.setAuditLogService(this.getAuditLogService());
                cmdResult = auditCmd.execute(null);
            } else {
                cmdResult = this.doKieSessionOperation(cmd, request.getDeploymentId(), request.getProcessInstanceId());
            }
        }
        catch (PermissionDeniedException pde) {
            logger.warn(errMsg, (Throwable)pde);
            jaxbResponse.addException((Exception)((Object)pde), i, cmd, JaxbRequestStatus.PERMISSIONS_CONFLICT);
        }
        catch (Exception e) {
            logger.warn(errMsg, (Throwable)e);
            jaxbResponse.addException(e, i, cmd, JaxbRequestStatus.FAILURE);
        }
        if (cmdResult != null) {
            try {
                jaxbResponse.addResult(cmdResult, i, cmd);
            }
            catch (Exception e) {
                errMsg = "Unable to add result from " + cmdName + "/" + i;
                logger.error(errMsg, (Throwable)e);
                jaxbResponse.addException(e, i, cmd, JaxbRequestStatus.FAILURE);
            }
        }
    }

    void preprocessCommand(Command cmd) {
        if (AcceptedServerCommands.SEND_OBJECT_PARAMETER_COMMANDS.contains(cmd.getClass())) {
            if (cmd instanceof CompleteWorkItemCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((CompleteWorkItemCommand)cmd).getResults());
            } else if (cmd instanceof SignalEventCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((SignalEventCommand)cmd).getEvent());
            } else if (cmd instanceof StartCorrelatedProcessCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((StartCorrelatedProcessCommand)cmd).getData());
                this.checkThatUserDefinedClassesWereUnmarshalled(((StartCorrelatedProcessCommand)cmd).getParameters());
            } else if (cmd instanceof StartProcessCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((StartProcessCommand)cmd).getData());
                this.checkThatUserDefinedClassesWereUnmarshalled(((StartProcessCommand)cmd).getParameters());
            } else if (cmd instanceof SetGlobalCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((SetGlobalCommand)cmd).getObject());
            } else if (cmd instanceof InsertObjectCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((InsertObjectCommand)cmd).getObject());
            } else if (cmd instanceof UpdateCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((UpdateCommand)cmd).getObject());
            } else if (cmd instanceof AddTaskCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((AddTaskCommand)cmd).getParams());
            } else if (cmd instanceof CompleteTaskCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((CompleteTaskCommand)cmd).getData());
            } else if (cmd instanceof FailTaskCommand) {
                this.checkThatUserDefinedClassesWereUnmarshalled(((FailTaskCommand)cmd).getData());
            }
        }
    }

    void checkThatUserDefinedClassesWereUnmarshalled(Object obj) {
        if (obj != null) {
            if (obj instanceof List) {
                for (Object listElem : (List)obj) {
                    this.verifyObjectHasBeenUnmarshalled(listElem);
                }
            } else if (obj instanceof Map) {
                for (Object mapVal : ((Map)obj).values()) {
                    this.verifyObjectHasBeenUnmarshalled(mapVal);
                }
            } else {
                this.verifyObjectHasBeenUnmarshalled(obj);
            }
        }
    }

    private void verifyObjectHasBeenUnmarshalled(Object obj) {
        if (Element.class.isAssignableFrom(obj.getClass())) {
            String typeName = ((Element)obj).getAttribute("xsi:type");
            throw new KieRemoteServicesDeploymentException("Could not unmarshall user-defined class instance parameter of type '" + typeName + "'");
        }
    }

    public <T> T doKieSessionOperation(Command<T> cmd, String deploymentId, Long processInstanceId) {
        if (DeploymentInfoBean.emptyDeploymentId(deploymentId)) {
            throw new org.kie.remote.services.exception.DeploymentNotFoundException("No deployment id supplied! Could not retrieve runtime to execute " + cmd.getClass().getSimpleName());
        }
        try {
            Object result = this.processService.execute(deploymentId, cmd);
            return (T)result;
        }
        catch (ProcessInstanceNotFoundException e) {
            throw KieRemoteRestOperationException.notFound("Process instance " + processInstanceId + " could not be found!");
        }
        catch (DeploymentNotFoundException e) {
            throw KieRemoteRestOperationException.notFound(e.getMessage());
        }
        catch (RuntimeException re) {
            throw KieRemoteRestOperationException.internalServerError(re.getMessage(), re);
        }
    }

    public Object getVariableObjectInstanceFromRuntime(String deploymentId, long processInstanceId, String varName) {
        try {
            Object procVar = this.processService.getProcessInstanceVariable(Long.valueOf(processInstanceId), varName);
            return procVar;
        }
        catch (ProcessInstanceNotFoundException e) {
            throw KieRemoteRestOperationException.notFound("Process instance " + processInstanceId + " could not be found!");
        }
        catch (DeploymentNotFoundException e) {
            throw KieRemoteRestOperationException.notFound(e.getMessage());
        }
        catch (RuntimeException re) {
            throw KieRemoteRestOperationException.internalServerError(re.getMessage(), re);
        }
    }

    private <T> T doTaskOperation(Long taskId, String deploymentId, Long processInstanceId, Task task, TaskCommand<T> cmd) {
        if (cmd instanceof GetTaskCommand || cmd instanceof GetContentCommand || cmd instanceof GetTaskContentCommand) {
            cmd = new ExecuteAndSerializeCommand<T>(cmd);
        }
        if (DeploymentInfoBean.emptyDeploymentId(deploymentId) && taskDeploymentIdCommands.contains(cmd.getClass())) {
            deploymentId = this.getDeploymentId(task, taskId, cmd);
        }
        try {
            return (T)this.userTaskService.execute(deploymentId, cmd);
        }
        catch (TaskNotFoundException e) {
            throw KieRemoteRestOperationException.notFound("Task " + taskId + " could not be found!");
        }
        catch (ProcessInstanceNotFoundException e) {
            throw KieRemoteRestOperationException.notFound("Process instance " + processInstanceId + " could not be found!");
        }
        catch (DeploymentNotFoundException e) {
            throw KieRemoteRestOperationException.notFound(e.getMessage());
        }
        catch (RuntimeException re) {
            throw KieRemoteRestOperationException.internalServerError(re.getMessage(), re);
        }
    }

    public <T> T doRestTaskOperation(Long taskId, String deploymentId, Long processInstanceId, Task task, TaskCommand<T> cmd) {
        try {
            return this.doTaskOperation(taskId, deploymentId, processInstanceId, task, cmd);
        }
        catch (PermissionDeniedException pde) {
            throw KieRemoteRestOperationException.conflict(pde.getMessage(), (Exception)((Object)pde));
        }
    }

    private String getDeploymentId(Task task, Long taskId, TaskCommand cmd) {
        if (task == null) {
            if (taskId == null) {
                taskId = cmd.getTaskId();
            }
            task = this.userTaskService.getTask(taskId);
        }
        String deploymentId = null;
        if (task != null && task.getTaskData() != null) {
            deploymentId = task.getTaskData().getDeploymentId();
        }
        return deploymentId;
    }

    static {
        taskDeploymentIdCommands.add(CompleteTaskCommand.class);
        taskDeploymentIdCommands.add(FailTaskCommand.class);
        taskDeploymentIdCommands.add(SkipTaskCommand.class);
    }
}

