/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jbpm.kie.services.impl.KModuleDeploymentService;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.runtime.manager.impl.deploy.DeploymentDescriptorImpl;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.DeployedUnit;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.cdi.Kjar;
import org.kie.internal.executor.api.CommandContext;
import org.kie.internal.executor.api.ExecutorService;
import org.kie.internal.query.QueryContext;
import org.kie.internal.runtime.conf.DeploymentDescriptor;
import org.kie.internal.runtime.conf.MergeMode;
import org.kie.internal.runtime.conf.RuntimeStrategy;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.remote.services.exception.KieRemoteServicesDeploymentException;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.async.JobResultManager;
import org.kie.remote.services.rest.async.cmd.DeploymentCmd;
import org.kie.remote.services.rest.async.cmd.JobType;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentDescriptor;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnitList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinitionList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DeployResourceBase
extends ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(DeployResourceBase.class);
    @Inject
    @Kjar
    private KModuleDeploymentService deploymentService;
    @Inject
    private DeploymentInfoBean deploymentInfoBean;
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    private DefinitionService bpmn2DataService;
    @Inject
    private ExecutorService jobExecutor;
    private final AtomicLong jobIdGen = new AtomicLong(0L);
    @Inject
    private JobResultManager jobResultMgr;

    static JaxbDeploymentUnit convertKModuleDepUnitToJaxbDepUnit(KModuleDeploymentUnit kDepUnit) {
        JaxbDeploymentUnit jDepUnit = new JaxbDeploymentUnit(kDepUnit.getGroupId(), kDepUnit.getArtifactId(), kDepUnit.getVersion(), kDepUnit.getKbaseName(), kDepUnit.getKsessionName());
        jDepUnit.setStrategy(kDepUnit.getStrategy());
        return jDepUnit;
    }

    static KModuleDeploymentUnit createDeploymentUnit(String deploymentId, JaxbDeploymentDescriptor descriptor) {
        String[] gavKK = deploymentId.split(":");
        KModuleDeploymentUnit deployUnit = new KModuleDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
        if (gavKK.length > 3) {
            deployUnit.setKbaseName(gavKK[3]);
        }
        if (gavKK.length > 4) {
            deployUnit.setKsessionName(gavKK[4]);
        }
        if (descriptor != null) {
            DeploymentDescriptor realDepDesc = DeployResourceBase.convertToDeploymentDescriptor(descriptor);
            deployUnit.setDeploymentDescriptor(realDepDesc);
        }
        return deployUnit;
    }

    private static DeploymentDescriptor convertToDeploymentDescriptor(JaxbDeploymentDescriptor jaxbDepDesc) {
        DeploymentDescriptorImpl depDescImpl = new DeploymentDescriptorImpl(jaxbDepDesc.getPersistenceUnit());
        depDescImpl.setAuditPersistenceUnit(jaxbDepDesc.getAuditPersistenceUnit());
        depDescImpl.setAuditMode(jaxbDepDesc.getAuditMode());
        depDescImpl.setPersistenceMode(jaxbDepDesc.getPersistenceMode());
        depDescImpl.setRuntimeStrategy(jaxbDepDesc.getRuntimeStrategy());
        depDescImpl.setMarshallingStrategies(jaxbDepDesc.getMarshallingStrategies());
        depDescImpl.setEventListeners(jaxbDepDesc.getEventListeners());
        depDescImpl.setTaskEventListeners(jaxbDepDesc.getTaskEventListeners());
        depDescImpl.setGlobals(jaxbDepDesc.getGlobals());
        depDescImpl.setWorkItemHandlers(jaxbDepDesc.getWorkItemHandlers());
        depDescImpl.setEnvironmentEntries(jaxbDepDesc.getEnvironmentEntries());
        depDescImpl.setConfiguration(jaxbDepDesc.getConfiguration());
        depDescImpl.setRequiredRoles(jaxbDepDesc.getRequiredRoles());
        depDescImpl.setClasses(jaxbDepDesc.getClasses());
        return depDescImpl;
    }

    public JaxbDeploymentUnit determineStatus(String deploymentId, boolean checkDeploymentService) {
        JaxbDeploymentUnit jaxbDepUnit;
        DeployedUnit deployedUnit;
        if (checkDeploymentService && (deployedUnit = this.deploymentService.getDeployedUnit(deploymentId)) != null) {
            KModuleDeploymentUnit depUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
            JaxbDeploymentUnit jaxbDepUnit2 = DeployResourceBase.convertKModuleDepUnitToJaxbDepUnit(depUnit);
            jaxbDepUnit2.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED);
            return jaxbDepUnit2;
        }
        JaxbDeploymentJobResult jobResult = this.jobResultMgr.getMostRecentJob(deploymentId);
        if (jobResult != null) {
            JaxbDeploymentUnit jaxbDepUnit3 = jobResult.getDeploymentUnit();
            return jaxbDepUnit3;
        }
        String[] gavKK = deploymentId.split(":");
        switch (gavKK.length) {
            case 3: {
                jaxbDepUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2]);
                break;
            }
            case 4: {
                jaxbDepUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2], gavKK[3], null);
                break;
            }
            case 5: {
                jaxbDepUnit = new JaxbDeploymentUnit(gavKK[0], gavKK[1], gavKK[2], gavKK[3], gavKK[4]);
                break;
            }
            default: {
                throw KieRemoteRestOperationException.notFound("Invalid deployment id: " + deploymentId);
            }
        }
        jaxbDepUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.NONEXISTENT);
        return jaxbDepUnit;
    }

    public JaxbDeploymentJobResult submitDeployJob(String deploymentId, String strategy, String mergeMode, JaxbDeploymentDescriptor deployDescriptor) {
        JaxbDeploymentJobResult jobResult;
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit != null) {
            KModuleDeploymentUnit kDepUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
            JaxbDeploymentUnit jaxbDepUnit = DeployResourceBase.convertKModuleDepUnitToJaxbDepUnit(kDepUnit);
            jobResult = new JaxbDeploymentJobResult(null, "The deployment already exists and must be first undeployed!", jaxbDepUnit, JobType.DEPLOY.toString());
            jobResult.setSuccess(Boolean.valueOf(false));
        } else {
            KModuleDeploymentUnit deploymentUnit = DeployResourceBase.createDeploymentUnit(deploymentId, deployDescriptor);
            if (strategy != null) {
                RuntimeStrategy runtimeStrategy;
                strategy = strategy.toUpperCase();
                try {
                    runtimeStrategy = RuntimeStrategy.valueOf((String)strategy);
                }
                catch (IllegalArgumentException iae) {
                    throw KieRemoteRestOperationException.badRequest("Runtime strategy '" + strategy + "' does not exist.");
                }
                deploymentUnit.setStrategy(runtimeStrategy);
            }
            if (mergeMode != null) {
                MergeMode mode;
                mergeMode = mergeMode.toUpperCase();
                try {
                    mode = MergeMode.valueOf((String)mergeMode);
                }
                catch (IllegalArgumentException iae) {
                    throw KieRemoteRestOperationException.badRequest("Merge mode '" + mergeMode + "' does not exist.");
                }
                deploymentUnit.setMergeMode(mode);
            }
            jobResult = this.scheduleDeploymentJobRequest(deploymentId, JobType.DEPLOY, deploymentUnit);
        }
        return jobResult;
    }

    private JaxbDeploymentJobResult scheduleDeploymentJobRequest(String deploymentId, JobType jobType, KModuleDeploymentUnit deploymentUnit) {
        CommandContext ctx = new CommandContext();
        ctx.setData("DeploymentUnit", (Object)deploymentUnit);
        ctx.setData("JobType", (Object)jobType);
        ctx.setData("businessKey", (Object)deploymentId);
        ctx.setData("retries", (Object)0);
        ctx.setData("owner", (Object)ExecutorService.EXECUTOR_ID);
        String jobTypeLower = jobType.toString().toLowerCase();
        String jobId = "" + System.currentTimeMillis() + "-" + this.jobIdGen.incrementAndGet();
        ctx.setData("JobId", (Object)jobId);
        JaxbDeploymentJobResult jobResult = new JaxbDeploymentJobResult(jobId, jobTypeLower + " job accepted.", DeployResourceBase.convertKModuleDepUnitToJaxbDepUnit(deploymentUnit), jobType.toString());
        jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.ACCEPTED);
        logger.debug("{} job [{}] for deployment '{}' created.", new Object[]{jobType.toString(), jobId, deploymentUnit.getIdentifier()});
        this.jobResultMgr.putJob(jobResult.getJobId(), jobResult, jobType);
        try {
            Long executorJobId = this.jobExecutor.scheduleRequest(DeploymentCmd.class.getName(), ctx);
            jobResult.setIdentifier(executorJobId);
            jobResult.setSuccess(Boolean.valueOf(true));
        }
        catch (Exception e) {
            String msg = "Unable to " + jobType.toString().toLowerCase() + " deployment '" + deploymentId + "': " + e.getClass().getSimpleName() + " thrown [" + e.getMessage() + "]";
            logger.error(msg, (Throwable)e);
            jobResult.setExplanation(msg);
            jobResult.setSuccess(Boolean.valueOf(false));
        }
        return jobResult;
    }

    public JaxbDeploymentJobResult submitUndeployJob(String deploymentId) {
        JaxbDeploymentJobResult jobResult;
        DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
        if (deployedUnit != null) {
            KModuleDeploymentUnit deploymentUnit = (KModuleDeploymentUnit)deployedUnit.getDeploymentUnit();
            jobResult = this.scheduleDeploymentJobRequest(deploymentId, JobType.UNDEPLOY, deploymentUnit);
        } else {
            String explanation;
            JaxbDeploymentUnit depUnit = this.determineStatus(deploymentId, false);
            switch (depUnit.getStatus()) {
                case ACCEPTED: 
                case DEPLOYED: 
                case DEPLOYING: {
                    explanation = "The deployment can not be undeployed because the initial deployment has not yet fully completed.";
                    break;
                }
                case DEPLOY_FAILED: {
                    explanation = "The deployment can not be undeployed because the initial deployment failed.";
                    break;
                }
                case NONEXISTENT: 
                case UNDEPLOYED: 
                case UNDEPLOYING: {
                    explanation = "The deployment can not be undeployed because it has already been undeployed (or is currently being undeployed)";
                    break;
                }
                case UNDEPLOY_FAILED: {
                    explanation = "The last undeployment failed, but the deployment unit is no longer present (and can not be undeployed, thus). There is probably a very high load on this server. Turning on debugging may provide insight.";
                    logger.debug("Stack trace:", new Throwable());
                    break;
                }
                default: {
                    throw new KieRemoteServicesDeploymentException("Unknown deployment unit status: " + depUnit.getStatus());
                }
            }
            jobResult = new JaxbDeploymentJobResult(null, explanation, depUnit, JobType.UNDEPLOY.toString());
            jobResult.setSuccess(Boolean.valueOf(false));
        }
        return jobResult;
    }

    public JaxbDeploymentUnitList getDeploymentList(int[] pageInfo, int maxNumResults) {
        ArrayList<String> deploymentIds = new ArrayList<String>(this.deploymentInfoBean.getDeploymentIds());
        Collections.sort(deploymentIds);
        JaxbDeploymentUnitList jaxbDepUnitList = new JaxbDeploymentUnitList();
        List depUnitList = jaxbDepUnitList.getDeploymentUnitList();
        for (String deploymentId : deploymentIds) {
            DeployedUnit deployedUnit = this.deploymentService.getDeployedUnit(deploymentId);
            if (deployedUnit == null) continue;
            JaxbDeploymentUnit jaxbDepUnit = DeployResourceBase.convertKModuleDepUnitToJaxbDepUnit((KModuleDeploymentUnit)deployedUnit.getDeploymentUnit());
            jaxbDepUnit.setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED);
            depUnitList.add(jaxbDepUnit);
            if (depUnitList.size() < maxNumResults) continue;
            break;
        }
        JaxbDeploymentUnitList resultList = DeployResourceBase.paginateAndCreateResult(pageInfo, depUnitList, new JaxbDeploymentUnitList());
        return resultList;
    }

    public JaxbProcessDefinitionList getProcessDefinitionList(int[] pageInfo, int maxNumResults) {
        ArrayList<String> deploymentIds = new ArrayList<String>(this.deploymentInfoBean.getDeploymentIds());
        Collections.sort(deploymentIds);
        JaxbProcessDefinitionList jaxbProcDefList = new JaxbProcessDefinitionList();
        List procDefList = jaxbProcDefList.getProcessDefinitionList();
        for (String deploymentId : deploymentIds) {
            this.fillProcessDefinitionList(deploymentId, pageInfo, maxNumResults, procDefList);
            if (procDefList.size() != maxNumResults) continue;
            break;
        }
        JaxbProcessDefinitionList resultList = DeployResourceBase.paginateAndCreateResult(pageInfo, procDefList, new JaxbProcessDefinitionList());
        return resultList;
    }

    public void fillProcessDefinitionList(String deploymentId, int[] pageInfo, int maxNumResults, List<JaxbProcessDefinition> procDefList) {
        ArrayList processIdList = Collections.EMPTY_LIST;
        try {
            int offset = (pageInfo[PAGE_NUM] > 0 ? pageInfo[PAGE_NUM] - 1 : 0) * pageInfo[PAGE_SIZE];
            int count = pageInfo[PAGE_SIZE] > 0 ? pageInfo[PAGE_SIZE] : 10;
            QueryContext queryContext = new QueryContext(Integer.valueOf(offset), Integer.valueOf(count));
            processIdList = new ArrayList(this.runtimeDataService.getProcessIds(deploymentId, queryContext));
            Collections.sort(processIdList);
        }
        catch (Exception e) {
            logger.debug("Unable to retrieve process ids for deployment '{}': {}", new Object[]{deploymentId, e.getMessage(), e});
        }
        for (String processId : processIdList) {
            Map variables;
            ProcessDefinition processAssetDesc;
            block8: {
                try {
                    processAssetDesc = this.runtimeDataService.getProcessesByDeploymentIdProcessId(deploymentId, processId);
                    if (processAssetDesc == null) {
                        logger.error("No process definition information available for process definition '{}' in deployment '{}'!", (Object)processId, (Object)deploymentId);
                    }
                    break block8;
                }
                catch (Exception e) {
                    logger.debug("Unable to retrieve process definition for process '{}' in deployment '{}': {}", new Object[]{processId, deploymentId, e.getMessage(), e});
                }
                continue;
            }
            JaxbProcessDefinition jaxbProcDef = this.convertProcAssetDescToJaxbProcDef(processAssetDesc);
            try {
                variables = this.bpmn2DataService.getProcessVariables(deploymentId, processId);
            }
            catch (Exception e) {
                logger.debug("Unable to retrieve process definition data for process '{}' in deployment '{}': {}", new Object[]{processId, deploymentId, e.getMessage(), e});
                continue;
            }
            jaxbProcDef.setVariables(variables);
            procDefList.add(jaxbProcDef);
            if (procDefList.size() != maxNumResults) continue;
            break;
        }
    }

    public void activate(String deploymentId) {
        this.deploymentService.activate(deploymentId);
    }

    public void deactivate(String deploymentId) {
        this.deploymentService.deactivate(deploymentId);
    }
}

