/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.jaxb;

import com.sun.xml.bind.v2.runtime.IllegalAnnotationException;
import com.sun.xml.bind.v2.runtime.IllegalAnnotationsException;
import com.sun.xml.bind.v2.runtime.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import org.jbpm.services.cdi.Deploy;
import org.jbpm.services.cdi.Undeploy;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.remote.services.cdi.DeploymentProcessedEvent;
import org.kie.remote.services.exception.KieRemoteServicesDeploymentException;
import org.kie.remote.services.exception.KieRemoteServicesInternalError;
import org.kie.remote.services.jaxb.ServerJaxbSerializationProvider;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DynamicJaxbContext
extends JAXBContext {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJaxbContext.class);
    private static ConcurrentHashMap<String, JAXBContext> contextsCache = new ConcurrentHashMap();
    private static ThreadLocal<JAXBContext> requestJaxbContextLocal;
    @Inject
    DeploymentInfoBean deploymentInfoBean;
    private static AtomicInteger instanceCreated;
    private static final String SMART_JAXB_CONTEXT_INIT_PROPERTY_NAME = "org.kie.remote.jaxb.smart.init";
    private static final boolean smartJaxbContextInitialization;
    private static final String EXPECTED_JAXB_CONTEXT_IMPL_CLASS = "com.sun.xml.bind.v2.runtime.JAXBContextImpl";

    public DynamicJaxbContext() {
        if (!instanceCreated.compareAndSet(0, 1)) {
            logger.debug("Instance {} of the {} created!", (Object)instanceCreated.incrementAndGet(), (Object)DynamicJaxbContext.class.getSimpleName());
        }
    }

    public static void setDeploymentJaxbContext(String deploymentId) {
        JAXBContext jaxbContext = contextsCache.get(deploymentId);
        if (jaxbContext == null) {
            logger.debug("No JAXBContext available for deployment '" + deploymentId + "', using default JAXBContext instance.");
            jaxbContext = contextsCache.get("**DEFAULT");
        }
        requestJaxbContextLocal.set(jaxbContext);
    }

    public static void clearDeploymentJaxbContext() {
        requestJaxbContextLocal.set(null);
    }

    private JAXBContext getRequestContext() {
        JAXBContext requestJaxbContext = requestJaxbContextLocal.get();
        if (requestJaxbContext == null) {
            logger.error("No JAXB context could be found for request, using default!");
            requestJaxbContext = contextsCache.get("**DEFAULT");
        }
        return requestJaxbContext;
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = this.getRequestContext();
        if (context != null) {
            return context.createUnmarshaller();
        }
        throw new KieRemoteServicesInternalError("No Unmarshaller available: JAXBContext instance could be found for this request!");
    }

    public Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = this.getRequestContext();
        if (context != null) {
            return JaxbSerializationProvider.configureMarshaller((JAXBContext)context, (boolean)false);
        }
        throw new KieRemoteServicesInternalError("No Marshaller available: JAXBContext instance could be found for this request!");
    }

    public Validator createValidator() throws JAXBException {
        JAXBContext context = this.getRequestContext();
        if (context != null) {
            return context.createValidator();
        }
        throw new KieRemoteServicesInternalError("No Validator available: JAXBContext instance could be found for this request!");
    }

    public void setupDeploymentJaxbContext(@Observes @Deploy DeploymentProcessedEvent event) {
        String deploymentId = event.getDeploymentId();
        this.setupDeploymentJaxbContext(deploymentId);
    }

    public void cleanUpOnUndeploy(@Observes @Undeploy DeploymentProcessedEvent event) {
        String deploymentId = event.getDeploymentId();
        JAXBContext deploymentJaxbContext = contextsCache.remove(deploymentId);
        if (deploymentJaxbContext == null) {
            logger.error("JAXB context instance could not be found when undeploying deployment '" + deploymentId + "'!");
        }
    }

    private static void setupDefaultJaxbContext() {
        try {
            Class[] types = ServerJaxbSerializationProvider.getAllBaseJaxbClasses();
            JAXBContext defaultJaxbContext = JAXBContext.newInstance((Class[])types);
            contextsCache.put("**DEFAULT", defaultJaxbContext);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to create new " + JAXBContext.class.getSimpleName() + " instance.", e);
        }
    }

    public JAXBContext getDeploymentJaxbContext(String deploymentId) {
        JAXBContext jaxbContext = contextsCache.get(deploymentId);
        if (jaxbContext == null) {
            logger.debug("No JAXBContext available for deployment '" + deploymentId + "', using default JAXBContext instance.");
            jaxbContext = contextsCache.get("**DEFAULT");
        }
        return jaxbContext;
    }

    private void setupDeploymentJaxbContext(String deploymentId) {
        Collection<Class<?>> depClasses;
        if (contextsCache.contains(deploymentId)) {
            logger.error("JAXB context instance already found when deploying deployment '" + deploymentId + "'!");
            contextsCache.remove(deploymentId);
        }
        if ((depClasses = this.deploymentInfoBean.getDeploymentClasses(deploymentId)).size() == 0) {
            JAXBContext defaultJaxbContext = contextsCache.get("**DEFAULT");
            contextsCache.put(deploymentId, defaultJaxbContext);
            return;
        }
        List<Class<?>> allClassList = Arrays.asList(ServerJaxbSerializationProvider.getAllBaseJaxbClasses());
        HashSet allClasses = new HashSet(allClassList);
        allClasses.addAll(depClasses);
        Class[] allClassesArr = allClasses.toArray(new Class[allClasses.size()]);
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = smartJaxbContextInitialization ? this.smartJaxbContextInitialization(allClassesArr, deploymentId) : JAXBContext.newInstance((Class[])allClassesArr);
            contextsCache.put(deploymentId, jaxbContext);
        }
        catch (JAXBException jaxbe) {
            String errMsg = "Unable to instantiate JAXBContext for deployment '" + deploymentId + "'.";
            throw new KieRemoteServicesDeploymentException(errMsg, jaxbe);
        }
    }

    private JAXBContext smartJaxbContextInitialization(Class[] jaxbContextClasses, String deploymentId) throws JAXBException {
        ArrayList<Class> classList = new ArrayList<Class>(Arrays.asList(jaxbContextClasses));
        JAXBContext jaxbContext = null;
        boolean retryJaxbContextCreation = true;
        while (retryJaxbContextCreation) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])classList.toArray(new Class[classList.size()]));
                retryJaxbContextCreation = false;
            }
            catch (IllegalAnnotationsException iae) {
                this.removeClassFromJaxbContextClassList(classList, iae, deploymentId);
            }
        }
        return jaxbContext;
    }

    private void removeClassFromJaxbContextClassList(List<Class> classList, IllegalAnnotationsException iae, String deploymentId) throws IllegalAnnotationException {
        HashSet removedClasses = new HashSet();
        for (IllegalAnnotationException error : iae.getErrors()) {
            List classLocs = (List)error.getSourcePos().get(0);
            if (classLocs != null && !classLocs.isEmpty()) {
                String className = ((Location)classLocs.listIterator(classLocs.size()).previous()).toString();
                Class<?> removeClass = null;
                try {
                    removeClass = Class.forName(className);
                    if (!removedClasses.add(removeClass)) {
                        continue;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new KieRemoteServicesInternalError("Class [" + className + "] could not be found when creating JAXB context: " + cnfe.getMessage(), cnfe);
                }
                if (classList.remove(removeClass)) {
                    logger.warn("Removing class '{}' from serialization context for deployment '{}'", (Object)className, (Object)deploymentId);
                    continue;
                }
            }
            throw error;
        }
    }

    static {
        DynamicJaxbContext.setupDefaultJaxbContext();
        requestJaxbContextLocal = new ThreadLocal();
        instanceCreated = new AtomicInteger(0);
        boolean smartJaxbContextInitProperty = Boolean.parseBoolean(System.getProperty(SMART_JAXB_CONTEXT_INIT_PROPERTY_NAME, "true"));
        if (smartJaxbContextInitProperty) {
            try {
                smartJaxbContextInitProperty = false;
                smartJaxbContextInitProperty = EXPECTED_JAXB_CONTEXT_IMPL_CLASS.equals(JAXBContext.newInstance((Class[])new Class[0]).getClass().getName());
            }
            catch (JAXBException jaxbe) {
                logger.error("Unable to initialize empty JAXB Context: something is VERY wrong!", (Throwable)jaxbe);
            }
        }
        smartJaxbContextInitialization = smartJaxbContextInitProperty;
    }
}

