/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.util.Date;
import org.jbpm.process.audit.command.AuditVariableInstanceLogQueryCommand;
import org.jbpm.query.jpa.builder.impl.AbstractQueryBuilderImpl;
import org.jbpm.services.task.commands.TaskQueryDataCommand;
import org.kie.api.task.model.Status;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;
import org.kie.internal.task.query.TaskQueryBuilder;

class RemoteServicesQueryCommandBuilder
extends AbstractQueryBuilderImpl<RemoteServicesQueryCommandBuilder> {
    private final String taskUserId;

    public RemoteServicesQueryCommandBuilder() {
        this.taskUserId = null;
        this.intersect();
    }

    public RemoteServicesQueryCommandBuilder(String userId) {
        this.taskUserId = userId;
        this.intersect();
    }

    public RemoteServicesQueryCommandBuilder deploymentId(String ... deploymentId) {
        this.addObjectParameter(QueryParameterIdentifiers.EXTERNAL_ID_LIST, "deployment id", deploymentId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder processId(String ... processId) {
        this.addObjectParameter(QueryParameterIdentifiers.PROCESS_ID_LIST, "process id", processId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder processVersion(String ... processVersion) {
        this.addObjectParameter(QueryParameterIdentifiers.PROCESS_VERSION_LIST, "process version", processVersion);
        return this;
    }

    public RemoteServicesQueryCommandBuilder processInstanceId(long ... processInstanceId) {
        this.addLongParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id", processInstanceId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder processInstanceIdMin(long processInstanceId) {
        this.addRangeParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id range, start", processInstanceId, true);
        return this;
    }

    public RemoteServicesQueryCommandBuilder processInstanceIdMax(long processInstanceId) {
        this.addRangeParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id range, end", processInstanceId, false);
        return this;
    }

    public RemoteServicesQueryCommandBuilder processInstanceStatus(int ... status) {
        this.addIntParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_STATUS_LIST, "process instance status", status);
        return this;
    }

    public RemoteServicesQueryCommandBuilder startDate(Date ... date) {
        this.addObjectParameter(QueryParameterIdentifiers.START_DATE_LIST, "start date", date);
        return this;
    }

    public RemoteServicesQueryCommandBuilder startDateMin(Date rangeStart) {
        this.addRangeParameter(QueryParameterIdentifiers.START_DATE_LIST, "start date range, start", rangeStart, true);
        return this;
    }

    public RemoteServicesQueryCommandBuilder startDateMax(Date rangeEnd) {
        this.addRangeParameter(QueryParameterIdentifiers.START_DATE_LIST, "start date range, end", rangeEnd, false);
        return this;
    }

    public RemoteServicesQueryCommandBuilder endDate(Date ... date) {
        this.addObjectParameter(QueryParameterIdentifiers.END_DATE_LIST, "end date", date);
        return this;
    }

    public RemoteServicesQueryCommandBuilder endDateMin(Date rangeStart) {
        this.addRangeParameter(QueryParameterIdentifiers.END_DATE_LIST, "end date range, start", rangeStart, true);
        return this;
    }

    public RemoteServicesQueryCommandBuilder endDateMax(Date rangeEnd) {
        this.addRangeParameter(QueryParameterIdentifiers.END_DATE_LIST, "end date range, end", rangeEnd, false);
        return this;
    }

    public RemoteServicesQueryCommandBuilder workItemId(long ... workItemId) {
        this.addLongParameter(QueryParameterIdentifiers.WORK_ITEM_ID_LIST, "work item id", workItemId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder taskId(long ... taskId) {
        this.addLongParameter(QueryParameterIdentifiers.TASK_ID_LIST, "task id", taskId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder taskIdMin(long taskId) {
        this.addRangeParameter(QueryParameterIdentifiers.TASK_ID_LIST, "task instance id range, start", taskId, true);
        return this;
    }

    public RemoteServicesQueryCommandBuilder taskIdMax(long taskId) {
        this.addRangeParameter(QueryParameterIdentifiers.TASK_ID_LIST, "task instance id range, start", taskId, false);
        return this;
    }

    public RemoteServicesQueryCommandBuilder taskStatus(Status ... status) {
        this.addObjectParameter(QueryParameterIdentifiers.TASK_STATUS_LIST, "task status", status);
        return this;
    }

    public RemoteServicesQueryCommandBuilder initiator(String ... createdById) {
        this.addObjectParameter(QueryParameterIdentifiers.CREATED_BY_LIST, "initiator", createdById);
        return this;
    }

    public RemoteServicesQueryCommandBuilder stakeHolder(String ... stakeHolderId) {
        this.addObjectParameter(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST, "stakeholder", stakeHolderId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder potentialOwner(String ... potentialOwnerId) {
        this.addObjectParameter(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST, "potential owner", potentialOwnerId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder taskOwner(String ... taskOwnerId) {
        this.addObjectParameter(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST, "task owner", taskOwnerId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder businessAdmin(String ... businessAdminId) {
        this.addObjectParameter(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST, "business admin", businessAdminId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder variableId(String ... variableId) {
        this.addObjectParameter(QueryParameterIdentifiers.VARIABLE_ID_LIST, "variable id", variableId);
        return this;
    }

    public RemoteServicesQueryCommandBuilder value(String ... value) {
        this.addObjectParameter(QueryParameterIdentifiers.VALUE_LIST, "variable value", value);
        return this;
    }

    public RemoteServicesQueryCommandBuilder oldValue(String ... oldVvalue) {
        this.addObjectParameter(QueryParameterIdentifiers.OLD_VALUE_LIST, "old variable value", oldVvalue);
        return this;
    }

    public RemoteServicesQueryCommandBuilder variableValue(String variableId, String value) {
        String varValStr = variableId.length() + ":" + variableId + ":" + value;
        this.addObjectParameter(QueryParameterIdentifiers.VAR_VALUE_ID_LIST, "value for variable", new String[]{varValStr});
        return this;
    }

    public RemoteServicesQueryCommandBuilder last() {
        this.addObjectParameter(QueryParameterIdentifiers.LAST_VARIABLE_LIST, "last variable value", new Boolean[]{(boolean)Boolean.TRUE});
        return this;
    }

    public RemoteServicesQueryCommandBuilder orderBy(Object orderByField) {
        String orderByString;
        block12: {
            block13: {
                block11: {
                    if (orderByField == null) {
                        throw new IllegalArgumentException("A null order by criteria is invalid.");
                    }
                    orderByString = null;
                    if (!(orderByField instanceof TaskQueryBuilder.OrderBy)) break block11;
                    switch ((TaskQueryBuilder.OrderBy)orderByField) {
                        case processInstanceId: {
                            orderByString = "t.taskData.processInstanceId";
                            break block12;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported order by arqument: " + orderByField.toString());
                        }
                    }
                }
                if (!(orderByField instanceof VariableInstanceLogQueryBuilder.OrderBy)) break block13;
                switch ((VariableInstanceLogQueryBuilder.OrderBy)orderByField) {
                    case processInstanceId: {
                        orderByString = "processInstanceId";
                        break block12;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported order by arqument: " + orderByField.toString());
                    }
                }
            }
            if (orderByField instanceof ProcessInstanceLogQueryBuilder.OrderBy) {
                switch ((ProcessInstanceLogQueryBuilder.OrderBy)orderByField) {
                    case processInstanceId: {
                        orderByString = "processInstanceId";
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported order by arqument: " + orderByField.toString());
                    }
                }
            }
        }
        this.queryData.getQueryContext().setOrderBy(orderByString);
        return this;
    }

    public TaskQueryDataCommand createTaskQueryDataCommand() {
        if (this.taskUserId == null) {
            throw new IllegalStateException("A user id is required to create a " + TaskQueryDataCommand.class.getSimpleName());
        }
        TaskQueryDataCommand cmd = new TaskQueryDataCommand(this.getQueryData());
        cmd.setUserId(this.taskUserId);
        return cmd;
    }

    public AuditVariableInstanceLogQueryCommand createVariableInstanceLogQueryCommand() {
        return new AuditVariableInstanceLogQueryCommand(this.getQueryData());
    }

    public RemoteServicesQueryCommandBuilder clear() {
        super.clear();
        this.intersect();
        return this;
    }
}

