/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.query.jpa.impl.QueryAndParameterAppender;
import org.jbpm.query.jpa.service.QueryModificationService;
import org.jbpm.services.task.impl.TaskQueryServiceImpl;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.query.data.QueryData;

public class RemoteServicesQueryModificationService
implements QueryModificationService {
    private static Map<String, Class<?>> taskCriteriaFieldClasses = TaskQueryServiceImpl.criteriaFieldClasses;
    private static Map<String, String> taskCriteriaFields = TaskQueryServiceImpl.criteriaFields;
    private static Map<String, String> taskCriteriaFieldJoinClauses = TaskQueryServiceImpl.criteriaFieldJoinClauses;
    private static Map<String, Class<?>> auditCriteriaFieldClasses = JPAAuditLogService.criteriaFieldClasses;
    private static Map<String, String> auditCriteriaFields = JPAAuditLogService.criteriaFields;
    private static final String processInstanceLogTable = "ProcessInstanceLog p";
    private static final String variableInstanceLogTable = "VariableInstanceLog v";
    private static final String taskTable = "TaskImpl t";
    private static final String stakeHoldersTable = "OrganizationalEntityImpl stakeHolders";
    private static final String potentialOwnersTable = "OrganizationalEntityImpl potentialOwners";
    private static final String businessAdministratorsTable = "OrganizationalEntityImpl businessAdministrators";
    private static Set<String> procInstLogNeededCriterias = new CopyOnWriteArraySet<String>();
    private static Set<String> varInstLogNeededCriterias = new CopyOnWriteArraySet<String>();
    private static Set<String> procInstLogNeededWithVarInstLogCriterias = new CopyOnWriteArraySet<String>();
    private static Set<String> taskNeededCriterias = new CopyOnWriteArraySet<String>();
    private static Set<String> organizationalEntityNeededCriterias = new CopyOnWriteArraySet<String>();
    private static final int TASK_SUMMARY_QUERY_TYPE;
    private static final int VARIABLE_INSTANCE_LOG_QUERY_TYPE;
    private static final int PROCESS_INSTANCE_LOG_QUERY_TYPE;
    private static final int OTHER_QUERY_TYPE;

    private int determineQueryType(String query) {
        int procLogLength;
        String taskSumQueryBegin = TaskQueryServiceImpl.TASKSUMMARY_SELECT;
        String varInstLogQueryBegin = JPAAuditLogService.VARIABLE_INSTANCE_LOG_QUERY;
        String procInstLogQueryBegin = JPAAuditLogService.PROCESS_INSTANCE_LOG_QUERY;
        int queryLength = query.length();
        int taskQueryLength = taskSumQueryBegin.length() > queryLength ? queryLength : taskSumQueryBegin.length();
        int varLogLength = varInstLogQueryBegin.length() > queryLength ? queryLength : varInstLogQueryBegin.length();
        int n = procLogLength = procInstLogQueryBegin.length() > queryLength ? queryLength : procInstLogQueryBegin.length();
        if (query.substring(0, taskQueryLength).equals(taskSumQueryBegin.substring(0, taskQueryLength))) {
            return TASK_SUMMARY_QUERY_TYPE;
        }
        if (query.substring(0, varLogLength).equals(varInstLogQueryBegin.substring(0, varLogLength))) {
            return VARIABLE_INSTANCE_LOG_QUERY_TYPE;
        }
        if (query.substring(0, procLogLength).equals(procInstLogQueryBegin.substring(0, procLogLength))) {
            return PROCESS_INSTANCE_LOG_QUERY_TYPE;
        }
        return OTHER_QUERY_TYPE;
    }

    public void addTablesToQuery(StringBuilder queryBuilder, QueryData queryData) {
        int type = this.determineQueryType(queryBuilder.toString());
        HashSet<String> additionalTables = new HashSet<String>();
        HashSet parameterListIdsUsed = new HashSet();
        if (!queryData.intersectParametersAreEmpty()) {
            parameterListIdsUsed.addAll(queryData.getIntersectParameters().keySet());
        }
        if (!queryData.intersectRangeParametersAreEmpty()) {
            parameterListIdsUsed.addAll(queryData.getIntersectRangeParameters().keySet());
        }
        if (!queryData.intersectRegexParametersAreEmpty()) {
            parameterListIdsUsed.addAll(queryData.getIntersectRegexParameters().keySet());
        }
        for (String listId : parameterListIdsUsed) {
            if (type == TASK_SUMMARY_QUERY_TYPE) {
                if (procInstLogNeededCriterias.contains(listId)) {
                    additionalTables.add(processInstanceLogTable);
                    continue;
                }
                if (!varInstLogNeededCriterias.contains(listId)) continue;
                additionalTables.add(variableInstanceLogTable);
                continue;
            }
            if (type == VARIABLE_INSTANCE_LOG_QUERY_TYPE) {
                if (procInstLogNeededWithVarInstLogCriterias.contains(listId)) {
                    additionalTables.add(processInstanceLogTable);
                }
                if (taskNeededCriterias.contains(listId)) {
                    additionalTables.add(taskTable);
                }
                if (!organizationalEntityNeededCriterias.contains(listId)) continue;
                if (listId.equals(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST)) {
                    additionalTables.add(stakeHoldersTable);
                    continue;
                }
                if (listId.equals(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST)) {
                    additionalTables.add(potentialOwnersTable);
                    continue;
                }
                if (!listId.equals(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST)) continue;
                additionalTables.add(businessAdministratorsTable);
                continue;
            }
            if (type != PROCESS_INSTANCE_LOG_QUERY_TYPE) continue;
            if (varInstLogNeededCriterias.contains(listId)) {
                additionalTables.add(variableInstanceLogTable);
                continue;
            }
            if (!taskNeededCriterias.contains(listId)) continue;
            additionalTables.add(taskTable);
        }
        for (String table : additionalTables) {
            queryBuilder.append(", " + table + "\n");
        }
    }

    public void addCriteriaToQuery(QueryData queryData, QueryAndParameterAppender queryAppender) {
        int type = this.determineQueryType(queryAppender.getQueryBuilder().toString());
        boolean addLastVariableQueryClause = false;
        boolean addVariableValueQueryClause = false;
        String varInstLogTableId = "l";
        if (type != VARIABLE_INSTANCE_LOG_QUERY_TYPE) {
            HashSet queryDataParms = new HashSet();
            if (!queryData.intersectParametersAreEmpty()) {
                queryDataParms.addAll(queryData.getIntersectParameters().keySet());
            }
            if (!queryData.intersectRangeParametersAreEmpty()) {
                queryDataParms.addAll(queryData.getIntersectRangeParameters().keySet());
            }
            if (!queryData.intersectRegexParametersAreEmpty()) {
                queryDataParms.addAll(queryData.getIntersectRegexParameters().keySet());
            }
            for (String listId : varInstLogNeededCriterias) {
                if (!queryDataParms.contains(listId)) continue;
                addLastVariableQueryClause = true;
                break;
            }
            for (String listId : queryDataParms) {
                if (!QueryParameterIdentifiers.VAR_VALUE_ID_LIST.equals(listId)) continue;
                addVariableValueQueryClause = true;
                break;
            }
        }
        Map<String, String> emptyJoinClauses = Collections.emptyMap();
        if (type == TASK_SUMMARY_QUERY_TYPE) {
            varInstLogTableId = "v";
            RemoteServicesQueryModificationService.internalAddCriteriaToQuery(queryData, queryAppender, procInstLogNeededCriterias, "p", auditCriteriaFieldClasses, auditCriteriaFields, ".processInstanceId = t.taskData.processInstanceId", varInstLogNeededCriterias, varInstLogTableId, auditCriteriaFieldClasses, auditCriteriaFields, emptyJoinClauses, ".processInstanceId = t.taskData.processInstanceId");
        } else if (type == VARIABLE_INSTANCE_LOG_QUERY_TYPE) {
            RemoteServicesQueryModificationService.internalAddCriteriaToQuery(queryData, queryAppender, procInstLogNeededWithVarInstLogCriterias, "p", auditCriteriaFieldClasses, auditCriteriaFields, ".processInstanceId = l.processInstanceId", taskNeededCriterias, "t", taskCriteriaFieldClasses, taskCriteriaFields, taskCriteriaFieldJoinClauses, ".taskData.processInstanceId = l.processInstanceId");
        } else if (type == PROCESS_INSTANCE_LOG_QUERY_TYPE) {
            varInstLogTableId = "v";
            RemoteServicesQueryModificationService.internalAddCriteriaToQuery(queryData, queryAppender, varInstLogNeededCriterias, varInstLogTableId, auditCriteriaFieldClasses, auditCriteriaFields, ".processInstanceId = l.processInstanceId", taskNeededCriterias, "t", taskCriteriaFieldClasses, taskCriteriaFields, taskCriteriaFieldJoinClauses, ".taskData.processInstanceId = l.processInstanceId");
        }
        if (type != VARIABLE_INSTANCE_LOG_QUERY_TYPE) {
            if (addLastVariableQueryClause) {
                queryData.getIntersectParameters().remove(QueryParameterIdentifiers.LAST_VARIABLE_LIST);
                StringBuilder queryPhraseBuilder = new StringBuilder(" (").append(varInstLogTableId).append(".id IN (SELECT MAX(ll.id) FROM VariableInstanceLog ll ").append("GROUP BY ll.variableId, ll.processInstanceId))");
                queryAppender.addToQueryBuilder(queryPhraseBuilder.toString(), false);
            }
            if (addVariableValueQueryClause) {
                List varValRegexParameters;
                ArrayList varValCriteria;
                List varValParameters;
                if (!queryData.intersectParametersAreEmpty() && (varValParameters = (List)queryData.getIntersectParameters().remove(QueryParameterIdentifiers.VAR_VALUE_ID_LIST)) != null && !varValParameters.isEmpty()) {
                    varValCriteria = new ArrayList();
                    JPAAuditLogService.checkVarValCriteria((List)varValParameters, (boolean)false, (boolean)false, varValCriteria);
                    JPAAuditLogService.addVarValCriteria((!queryAppender.hasBeenUsed() ? 1 : 0) != 0, (QueryAndParameterAppender)queryAppender, (String)varInstLogTableId, varValCriteria);
                    queryAppender.markAsUsed();
                    queryAppender.queryBuilderModificationCleanup();
                }
                if (!queryData.intersectRegexParametersAreEmpty() && (varValRegexParameters = (List)queryData.getIntersectRegexParameters().remove(QueryParameterIdentifiers.VAR_VALUE_ID_LIST)) != null && !varValRegexParameters.isEmpty()) {
                    varValCriteria = new ArrayList();
                    JPAAuditLogService.checkVarValCriteria((List)varValRegexParameters, (boolean)false, (boolean)true, varValCriteria);
                    JPAAuditLogService.addVarValCriteria((!queryAppender.hasBeenUsed() ? 1 : 0) != 0, (QueryAndParameterAppender)queryAppender, (String)varInstLogTableId, varValCriteria);
                    queryAppender.markAsUsed();
                    queryAppender.queryBuilderModificationCleanup();
                }
            }
        }
        int end = "SELECT".length();
        if (type == VARIABLE_INSTANCE_LOG_QUERY_TYPE || type == PROCESS_INSTANCE_LOG_QUERY_TYPE) {
            queryAppender.getQueryBuilder().replace(0, end, "SELECT DISTINCT");
        }
    }

    private static void internalAddCriteriaToQuery(QueryData queryData, QueryAndParameterAppender queryAppender, Set<String> firstNeededCriterias, String firstTableId, Map<String, Class<?>> firstCriteriaFieldClasses, Map<String, String> firstCriteriaFields, String firstTableIdJoinClause, Set<String> otherNeededCriterias, String otherTableId, Map<String, Class<?>> otherCriteriaFieldClasses, Map<String, String> otherCriteriaFields, Map<String, String> otherCriteriaFieldJoinClauses, String otherTableJoinClause) {
        String fieldName;
        String listId;
        boolean addFirstTableJoinClause = false;
        boolean addOtherTableJoinClause = false;
        HashSet<String> processedListIds = new HashSet<String>();
        if (!queryData.intersectParametersAreEmpty()) {
            for (Map.Entry entry : queryData.getIntersectParameters().entrySet()) {
                listId = (String)entry.getKey();
                if (QueryParameterIdentifiers.VAR_VALUE_ID_LIST.equals(listId)) {
                    if (firstNeededCriterias.contains(listId)) {
                        addFirstTableJoinClause = true;
                        continue;
                    }
                    if (!otherNeededCriterias.contains(listId)) continue;
                    addOtherTableJoinClause = true;
                    continue;
                }
                if (firstNeededCriterias.contains(listId)) {
                    addFirstTableJoinClause = true;
                    processedListIds.add(listId);
                    fieldName = RemoteServicesQueryModificationService.getNewFieldName(firstTableId, firstCriteriaFields, listId);
                    queryAppender.addQueryParameters((List)entry.getValue(), listId, firstCriteriaFieldClasses.get(listId), fieldName, false);
                    continue;
                }
                if (!otherNeededCriterias.contains(listId)) continue;
                addOtherTableJoinClause = true;
                processedListIds.add(listId);
                fieldName = RemoteServicesQueryModificationService.getNewFieldName(otherTableId, otherCriteriaFields, listId);
                queryAppender.addQueryParameters((List)entry.getValue(), listId, otherCriteriaFieldClasses.get(listId), fieldName, otherCriteriaFieldJoinClauses.get(listId), false);
            }
            for (String processedListId : processedListIds) {
                queryData.getIntersectParameters().remove(processedListId);
            }
            processedListIds.clear();
        }
        if (!queryData.intersectRangeParametersAreEmpty()) {
            for (Map.Entry entry : queryData.getIntersectRangeParameters().entrySet()) {
                listId = (String)entry.getKey();
                if (firstNeededCriterias.contains(listId)) {
                    addFirstTableJoinClause = true;
                    processedListIds.add(listId);
                    fieldName = RemoteServicesQueryModificationService.getNewFieldName(firstTableId, firstCriteriaFields, listId);
                    queryAppender.addRangeQueryParameters((List)entry.getValue(), listId, firstCriteriaFieldClasses.get(listId), fieldName, false);
                    continue;
                }
                if (!otherNeededCriterias.contains(listId)) continue;
                addOtherTableJoinClause = true;
                processedListIds.add(listId);
                fieldName = RemoteServicesQueryModificationService.getNewFieldName(otherTableId, otherCriteriaFields, listId);
                queryAppender.addRangeQueryParameters((List)entry.getValue(), listId, otherCriteriaFieldClasses.get(listId), fieldName, otherCriteriaFieldJoinClauses.get(listId), false);
            }
            for (String processedListId : processedListIds) {
                queryData.getIntersectRangeParameters().remove(processedListId);
            }
            processedListIds.clear();
        }
        if (!queryData.intersectRegexParametersAreEmpty()) {
            for (Map.Entry entry : queryData.getIntersectRegexParameters().entrySet()) {
                listId = (String)entry.getKey();
                if (QueryParameterIdentifiers.VAR_VALUE_ID_LIST.equals(listId)) {
                    if (firstNeededCriterias.contains(listId)) {
                        addFirstTableJoinClause = true;
                        continue;
                    }
                    if (!otherNeededCriterias.contains(listId)) continue;
                    addOtherTableJoinClause = true;
                    continue;
                }
                if (firstNeededCriterias.contains(listId)) {
                    addFirstTableJoinClause = true;
                    processedListIds.add(listId);
                    fieldName = RemoteServicesQueryModificationService.getNewFieldName(firstTableId, firstCriteriaFields, listId);
                    queryAppender.addRegexQueryParameters((List)entry.getValue(), listId, fieldName, false);
                    continue;
                }
                if (!otherNeededCriterias.contains(listId)) continue;
                addOtherTableJoinClause = true;
                processedListIds.add(listId);
                fieldName = RemoteServicesQueryModificationService.getNewFieldName(otherTableId, otherCriteriaFields, listId);
                queryAppender.addRegexQueryParameters((List)entry.getValue(), listId, fieldName, otherCriteriaFieldJoinClauses.get(listId), false);
            }
            for (String processedListId : processedListIds) {
                queryData.getIntersectRegexParameters().remove(processedListId);
            }
        }
        if (addFirstTableJoinClause) {
            queryAppender.addToQueryBuilder(" " + firstTableId + firstTableIdJoinClause, false);
        }
        if (addOtherTableJoinClause) {
            queryAppender.addToQueryBuilder(" " + otherTableId + otherTableJoinClause, false);
        }
    }

    private static String getNewFieldName(String tableId, Map<String, String> criteriaFields, String listId) {
        String criteriaField = criteriaFields.get(listId);
        boolean replaceTableId = !organizationalEntityNeededCriterias.contains(listId);
        String fieldName = replaceTableId ? tableId + criteriaField.substring(1) : criteriaField;
        return fieldName;
    }

    static {
        varInstLogNeededCriterias.add(QueryParameterIdentifiers.VARIABLE_ID_LIST);
        varInstLogNeededCriterias.add(QueryParameterIdentifiers.VALUE_LIST);
        varInstLogNeededCriterias.add(QueryParameterIdentifiers.OLD_VALUE_LIST);
        varInstLogNeededCriterias.add(QueryParameterIdentifiers.EXTERNAL_ID_LIST);
        varInstLogNeededCriterias.add(QueryParameterIdentifiers.VARIABLE_INSTANCE_ID_LIST);
        varInstLogNeededCriterias.add(QueryParameterIdentifiers.VAR_VALUE_ID_LIST);
        taskNeededCriterias.add(QueryParameterIdentifiers.TASK_ID_LIST);
        taskNeededCriterias.add(QueryParameterIdentifiers.TASK_STATUS_LIST);
        taskNeededCriterias.add(QueryParameterIdentifiers.CREATED_BY_LIST);
        taskNeededCriterias.add(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST);
        taskNeededCriterias.add(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST);
        taskNeededCriterias.add(QueryParameterIdentifiers.ACTUAL_OWNER_ID_LIST);
        taskNeededCriterias.add(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST);
        organizationalEntityNeededCriterias.add(QueryParameterIdentifiers.STAKEHOLDER_ID_LIST);
        organizationalEntityNeededCriterias.add(QueryParameterIdentifiers.POTENTIAL_OWNER_ID_LIST);
        organizationalEntityNeededCriterias.add(QueryParameterIdentifiers.BUSINESS_ADMIN_ID_LIST);
        procInstLogNeededCriterias.add(QueryParameterIdentifiers.START_DATE_LIST);
        procInstLogNeededCriterias.add(QueryParameterIdentifiers.END_DATE_LIST);
        procInstLogNeededCriterias.add(QueryParameterIdentifiers.PROCESS_INSTANCE_STATUS_LIST);
        procInstLogNeededWithVarInstLogCriterias.add(QueryParameterIdentifiers.START_DATE_LIST);
        procInstLogNeededWithVarInstLogCriterias.add(QueryParameterIdentifiers.END_DATE_LIST);
        procInstLogNeededWithVarInstLogCriterias.add(QueryParameterIdentifiers.PROCESS_INSTANCE_STATUS_LIST);
        procInstLogNeededWithVarInstLogCriterias.add(QueryParameterIdentifiers.PROCESS_VERSION_LIST);
        int idGen = 0;
        TASK_SUMMARY_QUERY_TYPE = idGen++;
        VARIABLE_INSTANCE_LOG_QUERY_TYPE = idGen++;
        PROCESS_INSTANCE_LOG_QUERY_TYPE = idGen++;
        OTHER_QUERY_TYPE = idGen++;
    }
}

