/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.async.cmd;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentService;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.cdi.Kjar;
import org.kie.api.executor.Command;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.remote.services.rest.async.JobResultManager;
import org.kie.remote.services.rest.async.cmd.JobType;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentCmd
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentCmd.class);
    public static final String DEPLOYMENT_UNIT = "DeploymentUnit";
    public static final String JOB_TYPE = "JobType";
    public static final String JOB_ID = "JobId";

    public ExecutionResults execute(CommandContext ctx) throws Exception {
        DeploymentService deploymentService = this.getDeploymentService(ctx);
        KModuleDeploymentUnit deploymentUnit = (KModuleDeploymentUnit)ctx.getData(DEPLOYMENT_UNIT);
        JobType jobType = (JobType)((Object)ctx.getData(JOB_TYPE));
        String deploymentId = deploymentUnit.getIdentifier();
        JobResultManager jobResultMgr = this.getJobManager(ctx);
        String jobId = (String)ctx.getData(JOB_ID);
        JaxbDeploymentJobResult jobResult = jobResultMgr.getJob(jobId);
        boolean success = false;
        switch (jobType) {
            case DEPLOY: {
                try {
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYING);
                    deploymentService.deploy((DeploymentUnit)deploymentUnit);
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOYED);
                    jobResult.setSuccess(Boolean.valueOf(true));
                    logger.debug("Deployment unit [{}] deployed", (Object)deploymentId);
                    success = true;
                }
                catch (Exception e) {
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.DEPLOY_FAILED);
                    jobResult.setSuccess(Boolean.valueOf(false));
                    logger.error("Unable to deploy [{}]", (Object)deploymentId, (Object)e);
                }
                break;
            }
            case UNDEPLOY: {
                try {
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYING);
                    deploymentService.undeploy((DeploymentUnit)deploymentUnit);
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOYED);
                    logger.debug("Deployment unit [{}] undeployed", (Object)deploymentId);
                    jobResult.setSuccess(Boolean.valueOf(false));
                    success = true;
                }
                catch (Exception e) {
                    jobResult.getDeploymentUnit().setStatus(JaxbDeploymentUnit.JaxbDeploymentStatus.UNDEPLOY_FAILED);
                    jobResult.setSuccess(Boolean.valueOf(false));
                    logger.error("Unable to undeploy [{}]", (Object)deploymentId, (Object)e);
                }
                break;
            }
            default: {
                logger.error("Unknown " + JobType.class.getSimpleName() + " type (" + jobType.toString() + "), not taking any action");
            }
        }
        ExecutionResults results = new ExecutionResults();
        results.setData("Result", (Object)success);
        return results;
    }

    private DeploymentService getDeploymentService(CommandContext ctx) throws Exception {
        BeanManager beanManager = this.getBeanManager();
        return DeploymentCmd.createBean(DeploymentService.class, beanManager, new Annotation[]{new AnnotationLiteral<Kjar>(){}});
    }

    private JobResultManager getJobManager(CommandContext ctx) throws Exception {
        BeanManager beanManager = this.getBeanManager();
        return DeploymentCmd.createBean(JobResultManager.class, beanManager, new Annotation[0]);
    }

    private BeanManager getBeanManager() {
        return BeanManagerProvider.getInstance().getBeanManager();
    }

    public static <T> T createBean(Class<T> beanType, BeanManager beanManager, Annotation ... bindings) throws Exception {
        Set beans = beanManager.getBeans(beanType, bindings);
        if (beans != null && !beans.isEmpty()) {
            Bean bean = (Bean)beans.iterator().next();
            return (T)beanManager.getReference(bean, beanType, beanManager.createCreationalContext((Contextual)bean));
        }
        return null;
    }
}

