/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query.helpers;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.kie.api.task.model.Status;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.RemoteServicesQueryCommandBuilder;
import org.kie.remote.services.rest.query.RemoteServicesQueryJPAService;
import org.kie.remote.services.rest.query.data.QueryResourceData;
import org.kie.remote.services.rest.query.helpers.AbstractInternalQueryHelper;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstance;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryProcessInstanceInfo;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryProcessInstanceResult;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbVariableInfo;

public class InternalProcInstQueryHelper
extends AbstractInternalQueryHelper<JaxbQueryProcessInstanceResult> {
    public InternalProcInstQueryHelper(ResourceBase resourceBase) {
        super(resourceBase);
    }

    @Override
    protected void createAndSetQueryBuilders(String identity) {
        RemoteServicesQueryCommandBuilder procInstLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        this.setQueryBuilders(procInstLogQueryBuilder, varInstLogQueryBuilder);
    }

    @Override
    public JaxbQueryProcessInstanceResult doQueryAndCreateResultObjects(boolean onlyRetrieveLastVarLogs, boolean workFlowInstanceVariables, int[] pageInfo) {
        RemoteServicesQueryCommandBuilder procInstLogQueryBuilder = this.getQueryBuilders()[0];
        InternalProcInstQueryHelper.setPaginationParameters(pageInfo, procInstLogQueryBuilder);
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = this.getQueryBuilders()[1];
        RemoteServicesQueryJPAService jpaService = this.resourceBase.getJPAService();
        if (onlyRetrieveLastVarLogs) {
            if (this.variableCriteriaInQuery(procInstLogQueryBuilder.getQueryWhere().getCriteria())) {
                procInstLogQueryBuilder.last();
            }
            varInstLogQueryBuilder.last();
        }
        procInstLogQueryBuilder.ascending(RemoteServicesQueryCommandBuilder.OrderBy.processInstanceId);
        List<ProcessInstanceLog> procLogs = jpaService.doQuery(procInstLogQueryBuilder.getQueryWhere(), ProcessInstanceLog.class);
        long[] procLogProcInstIds = new long[procLogs.size()];
        for (int i = 0; i < procLogProcInstIds.length; ++i) {
            procLogProcInstIds[i] = procLogs.get(i).getProcessInstanceId();
        }
        varInstLogQueryBuilder.processInstanceId(procLogProcInstIds);
        varInstLogQueryBuilder.ascending(RemoteServicesQueryCommandBuilder.OrderBy.processInstanceId);
        List<VariableInstanceLog> varLogs = jpaService.doQuery(varInstLogQueryBuilder.getQueryWhere(), VariableInstanceLog.class);
        List<JaxbVariableInfo> procVars = null;
        if (workFlowInstanceVariables) {
            for (VariableInstanceLog varLog : varLogs) {
            }
        }
        JaxbQueryProcessInstanceResult result = this.createProcessInstanceResult(procLogs, varLogs, procVars);
        return result;
    }

    protected static void setPaginationParameters(int[] pageInfo, RemoteServicesQueryCommandBuilder determiningQueryBuilder) {
        int offset = InternalProcInstQueryHelper.getOffset(pageInfo);
        if (offset > 0) {
            determiningQueryBuilder.offset(offset);
        }
        if (pageInfo[1] > 0) {
            determiningQueryBuilder.maxResults(pageInfo[1]);
        }
    }

    private JaxbQueryProcessInstanceResult createProcessInstanceResult(List<ProcessInstanceLog> procLogs, List<VariableInstanceLog> varLogs, List<JaxbVariableInfo> processVariables) {
        JaxbQueryProcessInstanceInfo procInfo;
        JaxbQueryProcessInstanceResult result = new JaxbQueryProcessInstanceResult();
        LinkedHashMap<Long, JaxbQueryProcessInstanceInfo> procInstIdProcInstInfoMap = new LinkedHashMap<Long, JaxbQueryProcessInstanceInfo>();
        for (ProcessInstanceLog procLog : procLogs) {
            procInfo = InternalProcInstQueryHelper.getQueryProcessInstanceInfo(procLog.getProcessInstanceId(), procInstIdProcInstInfoMap);
            procInfo.setProcessInstance(new JaxbProcessInstance((org.kie.api.runtime.manager.audit.ProcessInstanceLog)procLog));
        }
        for (VariableInstanceLog varLog : varLogs) {
            procInfo = (JaxbQueryProcessInstanceInfo)procInstIdProcInstInfoMap.get(varLog.getProcessInstanceId());
            if (procInfo == null) continue;
            procInfo.getVariables().add(new JaxbVariableInfo((org.kie.api.runtime.manager.audit.VariableInstanceLog)varLog));
        }
        result.getProcessInstanceInfoList().addAll(procInstIdProcInstInfoMap.values());
        return result;
    }

    private static JaxbQueryProcessInstanceInfo getQueryProcessInstanceInfo(long procInstId, Map<Long, JaxbQueryProcessInstanceInfo> procInstIdProcInstInfoMap) {
        JaxbQueryProcessInstanceInfo procInstInfo = procInstIdProcInstInfoMap.get(procInstId);
        if (procInstInfo == null) {
            procInstInfo = new JaxbQueryProcessInstanceInfo();
            procInstIdProcInstInfoMap.put(procInstId, procInstInfo);
        }
        return procInstInfo;
    }

    @Override
    public void taskId(long[] longData) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[0]);
    }

    @Override
    public void initiator(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[1]);
    }

    @Override
    public void stakeHolder(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[2]);
    }

    @Override
    public void potentialOwner(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[3]);
    }

    @Override
    public void taskOwner(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[4]);
    }

    @Override
    public void businessAdmin(String[] data) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[5]);
    }

    @Override
    public void taskStatus(Status[] statuses) {
        InternalProcInstQueryHelper.badParameter(QueryResourceData.taskQueryParams[6]);
    }

    public static void badParameter(String paramName) {
        throw KieRemoteRestOperationException.badRequest("'" + paramName + "' is not an accepted parameter for the rich process instance query operation");
    }
}

