/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.jaxb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.jbpm.services.task.impl.model.xml.JaxbComment;
import org.kie.api.command.Command;
import org.kie.api.task.model.Comment;
import org.kie.services.client.serialization.jaxb.impl.AbstractJaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbPaginatedList;

@XmlRootElement(name="task-comment-list-response")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JaxbTaskCommentListResponse
extends AbstractJaxbCommandResponse<List<Comment>>
implements JaxbPaginatedList<Comment> {
    @XmlElements(value={@XmlElement(name="task-comment", type=JaxbComment.class)})
    @JsonTypeInfo(defaultImpl=JaxbComment.class, use=JsonTypeInfo.Id.CLASS)
    private List<Comment> commentList;
    @XmlElement(name="page-number")
    @XmlSchemaType(name="int")
    private Integer pageNumber;
    @XmlElement(name="page-size")
    @XmlSchemaType(name="int")
    private Integer pageSize;

    public JaxbTaskCommentListResponse() {
        this.commentList = new ArrayList<Comment>();
    }

    public JaxbTaskCommentListResponse(Collection<Comment> commentCollection) {
        this.commentList = this.convertToJaxbComment(commentCollection);
    }

    public JaxbTaskCommentListResponse(List<Comment> commentCollection, int i, Command<?> cmd) {
        super(Integer.valueOf(i), cmd);
        this.commentList = this.convertToJaxbComment(commentCollection);
    }

    private List<Comment> convertToJaxbComment(Collection<Comment> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<Comment>();
        }
        ArrayList<Comment> newList = new ArrayList<Comment>(list.size());
        for (Comment comment : list) {
            if (comment instanceof JaxbComment) {
                newList.add(comment);
                continue;
            }
            newList.add((Comment)new JaxbComment(comment));
        }
        return newList;
    }

    public List<Comment> getResult() {
        return this.commentList;
    }

    public void setResult(List<Comment> result) {
        this.commentList = this.convertToJaxbComment(result);
    }

    public void addContents(List<Comment> contentList) {
        this.commentList = this.convertToJaxbComment(contentList);
    }

    @JsonTypeInfo(defaultImpl=JaxbComment.class, use=JsonTypeInfo.Id.CLASS)
    public List<Comment> getList() {
        return this.commentList;
    }

    @JsonTypeInfo(defaultImpl=JaxbComment.class, use=JsonTypeInfo.Id.CLASS)
    public void setList(List<Comment> result) {
        this.commentList = result;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer page) {
        this.pageNumber = page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

