/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.jaxb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.kie.api.command.Command;
import org.kie.api.task.model.TaskSummary;
import org.kie.services.client.serialization.jaxb.impl.AbstractJaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbPaginatedList;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskSummary;

@XmlRootElement(name="task-summary-list-response")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class JaxbTaskSummaryListResponse
extends AbstractJaxbCommandResponse<List<TaskSummary>>
implements JaxbPaginatedList<TaskSummary> {
    @XmlElements(value={@XmlElement(name="task-summary", type=JaxbTaskSummary.class)})
    @JsonTypeInfo(defaultImpl=JaxbTaskSummary.class, use=JsonTypeInfo.Id.CLASS)
    private List<TaskSummary> taskSummaryList;
    @XmlElement(name="page-number")
    @XmlSchemaType(name="int")
    private Integer pageNumber;
    @XmlElement(name="page-size")
    @XmlSchemaType(name="int")
    private Integer pageSize;

    public JaxbTaskSummaryListResponse() {
        this.taskSummaryList = new ArrayList<TaskSummary>();
    }

    public JaxbTaskSummaryListResponse(Collection<TaskSummary> taskSummaryCollection) {
        this.taskSummaryList = this.convertToJaxbTaskSummaryList(taskSummaryCollection);
    }

    public JaxbTaskSummaryListResponse(List<TaskSummary> taskSummaryCollection, int i, Command<?> cmd) {
        super(Integer.valueOf(i), cmd);
        this.taskSummaryList = this.convertToJaxbTaskSummaryList(taskSummaryCollection);
    }

    private List<TaskSummary> convertToJaxbTaskSummaryList(Collection<TaskSummary> list) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<TaskSummary>();
        }
        ArrayList<TaskSummary> newList = new ArrayList<TaskSummary>(list.size());
        for (TaskSummary taskSum : list) {
            if (taskSum instanceof JaxbTaskSummary) {
                newList.add(taskSum);
                continue;
            }
            newList.add((TaskSummary)new JaxbTaskSummary(taskSum));
        }
        return newList;
    }

    public List<TaskSummary> getResult() {
        return this.taskSummaryList;
    }

    public void setResult(List<TaskSummary> result) {
        this.taskSummaryList = this.convertToJaxbTaskSummaryList(result);
    }

    public void addContents(List<TaskSummary> contentList) {
        this.taskSummaryList = this.convertToJaxbTaskSummaryList(contentList);
    }

    @JsonTypeInfo(defaultImpl=JaxbTaskSummary.class, use=JsonTypeInfo.Id.CLASS)
    public List<TaskSummary> getList() {
        return this.taskSummaryList;
    }

    @JsonTypeInfo(defaultImpl=JaxbTaskSummary.class, use=JsonTypeInfo.Id.CLASS)
    public void setList(List<TaskSummary> result) {
        this.taskSummaryList = result;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer page) {
        this.pageNumber = page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

