/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.jms.security;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;

public class UserPassCallbackHandler
implements CallbackHandler {
    private final String[] credentials;

    public UserPassCallbackHandler(String[] credentials) {
        this.credentials = credentials;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback current : callbacks) {
            if (current instanceof NameCallback) {
                NameCallback ncb = (NameCallback)current;
                ncb.setName(this.credentials[0]);
                continue;
            }
            if (current instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)current;
                pcb.setPassword(this.credentials[1].toCharArray());
                continue;
            }
            if (current instanceof RealmCallback) {
                RealmCallback realmCallback = (RealmCallback)current;
                realmCallback.setText(realmCallback.getDefaultText());
                continue;
            }
            throw new UnsupportedCallbackException(current);
        }
    }
}

