/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query.helpers;

import java.util.ArrayDeque;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jbpm.query.jpa.data.QueryCriteria;
import org.kie.api.task.model.Status;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.RemoteServicesQueryCommandBuilder;
import org.kie.remote.services.rest.query.data.QueryAction;
import org.kie.remote.services.rest.query.data.QueryResourceData;
import org.kie.remote.services.rest.query.helpers.InternalQueryBuilderMethods;

abstract class AbstractInternalQueryHelper<R>
extends InternalQueryBuilderMethods {
    protected ResourceBase resourceBase;
    private static Set<String> VAR_QUERY_SPECIFIC_PARAMETER_LIST_IDS = new HashSet<String>();

    public AbstractInternalQueryHelper(ResourceBase resourceBase) {
        this.resourceBase = resourceBase;
    }

    public void dispose() {
        this.resourceBase = null;
    }

    protected abstract void createAndSetQueryBuilders(String var1);

    protected static int getOffset(int[] pageInfo) {
        int offset = 0;
        if (pageInfo[0] == 0 && pageInfo[1] > 0) {
            pageInfo[0] = 1;
        }
        if (pageInfo[0] > 1 && pageInfo[1] > 0) {
            offset = (pageInfo[0] - 1) * pageInfo[1];
        }
        return offset;
    }

    protected abstract R doQueryAndCreateResultObjects(boolean var1, boolean var2, int[] var3);

    public R queryTaskOrProcInstAndAssociatedVariables(String identity, Map<String, String[]> queryParams, int[] pageInfo) {
        boolean workFlowInstanceVariables = this.determineWorkFlowInstanceVariableUse(queryParams);
        if (workFlowInstanceVariables) {
            HashMap hashMap = new HashMap();
        }
        boolean onlyRetrieveLastVarLogs = true;
        String[] paramVals = queryParams.remove("all");
        if (paramVals != null) {
            onlyRetrieveLastVarLogs = false;
        }
        HashMap<String, String> varValueMap = new HashMap<String, String>();
        HashMap<String, String> varRegexMap = new HashMap<String, String>();
        Queue<QueryAction> queryActionQueue = this.fillQueryActionQueueFromQueryParams(queryParams, varValueMap, varRegexMap);
        this.createAndSetQueryBuilders(identity);
        this.processQueryActionQueue(queryActionQueue, varValueMap, varRegexMap, workFlowInstanceVariables);
        return this.doQueryAndCreateResultObjects(onlyRetrieveLastVarLogs, workFlowInstanceVariables, pageInfo);
    }

    public R queryTasksOrProcInstsAndVariables(Map<String, String[]> queryParams, int[] pageInfo) {
        return this.queryTaskOrProcInstAndAssociatedVariables(null, queryParams, pageInfo);
    }

    protected boolean determineWorkFlowInstanceVariableUse(Map<String, String[]> queryParams) {
        Boolean workFlowInstanceVariables = null;
        if (queryParams.containsKey(QueryResourceData.metaRuntimeParams[0]) || queryParams.containsKey(QueryResourceData.metaRuntimeParamsShort[0])) {
            workFlowInstanceVariables = true;
            queryParams.remove(QueryResourceData.metaRuntimeParams[0]);
            queryParams.remove(QueryResourceData.metaRuntimeParamsShort[0]);
        }
        if (queryParams.containsKey(QueryResourceData.metaRuntimeParams[1]) || queryParams.containsKey(QueryResourceData.metaRuntimeParamsShort[1])) {
            if (workFlowInstanceVariables != null) {
                throw KieRemoteRestOperationException.badRequest("Only one of the 'memory' and 'history' query parameters may be specified.");
            }
            workFlowInstanceVariables = false;
            queryParams.remove(QueryResourceData.metaRuntimeParams[1]);
            queryParams.remove(QueryResourceData.metaRuntimeParamsShort[1]);
        }
        if (workFlowInstanceVariables == null) {
            workFlowInstanceVariables = false;
        }
        return workFlowInstanceVariables;
    }

    protected Queue<QueryAction> fillQueryActionQueueFromQueryParams(Map<String, String[]> queryParams, Map<String, String> varValueMap, Map<String, String> varRegexMap) {
        ArrayDeque<QueryAction> queryActionQueue = new ArrayDeque<QueryAction>();
        for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
            Integer action;
            String orig_param = entry.getKey();
            if (ResourceBase.paginationParams.contains(orig_param)) continue;
            String[] paramParts = orig_param.split("_");
            String param = paramParts[0];
            if (paramParts.length >= 2) {
                if (QueryResourceData.varInstQueryParams[2].equals(paramParts[0]) || QueryResourceData.varInstQueryParams[3].equals(paramParts[0]) || QueryResourceData.varInstQueryParamsShort[3].equals(paramParts[0])) {
                    String[] values = queryParams.get(orig_param);
                    if (values.length > 1) {
                        throw KieRemoteRestOperationException.badRequest("Only one value per variable parameter: '" + orig_param + "'");
                    }
                    String value = values[0];
                    String varName = null;
                    StringBuilder nameBuilder = new StringBuilder(paramParts[1]);
                    for (int i = 2; i < paramParts.length; ++i) {
                        nameBuilder.append("_").append(paramParts[i]);
                    }
                    varName = nameBuilder.toString();
                    Integer queryActionInt = QueryResourceData.paramNameActionMap.get(paramParts[0]);
                    String[] data = new String[]{varName};
                    QueryAction queryAction = new QueryAction(orig_param, queryActionInt, data);
                    queryActionQueue.add(queryAction);
                    if (QueryResourceData.varInstQueryParams[2].equals(paramParts[0])) {
                        varValueMap.put(varName, value);
                        continue;
                    }
                    varRegexMap.put(varName, value);
                    queryAction.regex = true;
                    continue;
                }
                if (paramParts.length > 2) {
                    throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
                }
                action = QueryResourceData.paramNameActionMap.get(paramParts[0]);
                if (action == null) {
                    throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
                }
                QueryAction queryAction = new QueryAction(orig_param, action, entry.getValue());
                queryActionQueue.add(queryAction);
                if ("min".equals(paramParts[1])) {
                    queryAction.min = true;
                    continue;
                }
                if ("max".equals(paramParts[1])) {
                    queryAction.max = true;
                    continue;
                }
                if ("re".equals(paramParts[1])) {
                    queryAction.regex = true;
                    continue;
                }
                throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
            }
            action = QueryResourceData.paramNameActionMap.get(param);
            if (action != null) {
                queryActionQueue.add(new QueryAction(orig_param, action, entry.getValue()));
                continue;
            }
            throw KieRemoteRestOperationException.badRequest("Query parameter '" + orig_param + "' is not supported.");
        }
        return queryActionQueue;
    }

    private void setRegexOnOff(QueryAction queryAction, boolean on) {
        if (queryAction.regex) {
            if (on) {
                for (RemoteServicesQueryCommandBuilder queryCmdBuilder : this.getQueryBuilders()) {
                    queryCmdBuilder.like();
                }
            } else {
                for (RemoteServicesQueryCommandBuilder queryCmdBuilder : this.getQueryBuilders()) {
                    queryCmdBuilder.equals();
                }
                queryAction.regex = false;
            }
        }
    }

    protected boolean variableCriteriaInQuery(List<QueryCriteria> criteriaList) {
        for (QueryCriteria criteria : criteriaList) {
            if (criteria.isUnion()) {
                return false;
            }
            if (!(criteria.isGroupCriteria() ? this.variableCriteriaInQuery(criteria.getCriteria()) : VAR_QUERY_SPECIFIC_PARAMETER_LIST_IDS.contains(criteria.getListId()))) continue;
            return true;
        }
        return false;
    }

    protected void processQueryActionQueue(Queue<QueryAction> queryActionQueue, Map<String, String> varValueMap, Map<String, String> varRegexMap, boolean workFlowInstanceVariables) {
        while (!queryActionQueue.isEmpty()) {
            QueryAction queryAction = queryActionQueue.poll();
            String[] data = queryAction.paramData;
            int action = queryAction.action;
            switch (action) {
                case 0: {
                    assert ("processinstanceid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstanceid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    if (queryAction.min || queryAction.max) {
                        if (longData.length > 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + queryAction.paramName + "' parameter is accepted");
                        }
                        if (queryAction.min) {
                            this.processInstanceIdMin(longData);
                            queryAction.min = false;
                            break;
                        }
                        if (!queryAction.max) break;
                        this.processInstanceIdMax(longData);
                        queryAction.max = false;
                        break;
                    }
                    this.processInstanceId(longData);
                    break;
                }
                case 1: {
                    assert ("processid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processid";
                    this.setRegexOnOff(queryAction, true);
                    this.processId(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 2: {
                    assert ("deploymentid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : deploymentid";
                    this.setRegexOnOff(queryAction, true);
                    this.deploymentId(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 3: {
                    assert ("taskid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : taskid";
                    long[] longData = QueryResourceData.getLongs(action, data);
                    if (queryAction.min || queryAction.max) {
                        if (longData.length > 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + queryAction.paramName + "' parameter is accepted");
                        }
                        if (queryAction.min) {
                            this.taskIdMax(longData[0]);
                            queryAction.min = false;
                            break;
                        }
                        if (!queryAction.max) break;
                        this.taskIdMin(longData[0]);
                        queryAction.max = false;
                        break;
                    }
                    this.taskId(longData);
                    break;
                }
                case 4: {
                    assert ("initiator".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : initiator";
                    this.setRegexOnOff(queryAction, true);
                    this.initiator(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 5: {
                    assert ("stakeholder".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : stakeholder";
                    this.setRegexOnOff(queryAction, true);
                    this.stakeHolder(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 6: {
                    assert ("potentialowner".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : potentialowner";
                    this.setRegexOnOff(queryAction, true);
                    this.potentialOwner(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 7: {
                    assert ("taskowner".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : taskowner";
                    this.setRegexOnOff(queryAction, true);
                    this.taskOwner(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 8: {
                    assert ("businessadmin".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : businessadmin";
                    this.setRegexOnOff(queryAction, true);
                    this.businessAdmin(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 9: {
                    assert ("taskstatus".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : taskstatus";
                    Status[] statuses = QueryResourceData.getTaskStatuses(data);
                    this.taskStatus(statuses);
                    break;
                }
                case 10: {
                    assert ("processinstancestatus".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processinstancestatus";
                    int[] intData = QueryResourceData.getInts(action, data);
                    this.processInstanceStatus(intData);
                    break;
                }
                case 11: {
                    assert ("processversion".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : processversion";
                    this.setRegexOnOff(queryAction, true);
                    this.processVersion(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 12: {
                    assert ("startdate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : startdate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (queryAction.min || queryAction.max) {
                        if (dateData.length != 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + queryAction.paramName + "' parameter is accepted");
                        }
                        if (queryAction.min) {
                            this.startDateMin(dateData[0]);
                            queryAction.min = false;
                            break;
                        }
                        if (!queryAction.max) break;
                        this.startDateMax(dateData[0]);
                        queryAction.max = false;
                        break;
                    }
                    this.startDate(dateData);
                    break;
                }
                case 13: {
                    assert ("enddate".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : enddate";
                    Date[] dateData = QueryResourceData.getDates(action, data);
                    if (queryAction.min || queryAction.max) {
                        if (dateData.length > 1) {
                            throw KieRemoteRestOperationException.notFound("Only 1 '" + queryAction.paramName + "' parameter is accepted");
                        }
                        if (queryAction.min) {
                            this.endDateMin(dateData[0]);
                            queryAction.min = false;
                            break;
                        }
                        if (!queryAction.max) break;
                        this.endDateMax(dateData[0]);
                        queryAction.max = false;
                        break;
                    }
                    this.endDate(dateData);
                    break;
                }
                case 14: {
                    assert ("varid".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varid";
                    if (queryAction.regex && workFlowInstanceVariables) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter " + "when retrieving in-memory process variables");
                    }
                    this.setRegexOnOff(queryAction, true);
                    this.variableId(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 15: {
                    assert ("varvalue".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varvalue";
                    if (queryAction.regex && workFlowInstanceVariables) {
                        String param = QueryResourceData.actionParamNameMap.get(action);
                        throw KieRemoteRestOperationException.badRequest("Regular expresssions are not supported on the '" + param + "' parameter " + "when retrieving in-memory process variables");
                    }
                    this.setRegexOnOff(queryAction, true);
                    this.value(data);
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                case 16: {
                    assert ("var".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : var";
                    this.variableValue(data[0], varValueMap.get(data[0]));
                    break;
                }
                case 17: {
                    assert ("varregex".equals(QueryResourceData.actionParamNameMap.get(action))) : action + " : varregex";
                    this.setRegexOnOff(queryAction, true);
                    this.variableValue(data[0], varRegexMap.get(data[0]));
                    this.setRegexOnOff(queryAction, false);
                    break;
                }
                default: {
                    throw KieRemoteRestOperationException.internalServerError("Please contact the developers: state [" + action + "] should not be possible.");
                }
            }
            if (!queryAction.min && !queryAction.max && !queryAction.regex) continue;
            throw KieRemoteRestOperationException.notFound("Query parameter '" + queryAction.paramName + "' is not supported.");
        }
    }

    static {
        VAR_QUERY_SPECIFIC_PARAMETER_LIST_IDS.add(QueryParameterIdentifiers.VARIABLE_ID_LIST);
        VAR_QUERY_SPECIFIC_PARAMETER_LIST_IDS.add(QueryParameterIdentifiers.VARIABLE_INSTANCE_ID_LIST);
        VAR_QUERY_SPECIFIC_PARAMETER_LIST_IDS.add(QueryParameterIdentifiers.VALUE_LIST);
        VAR_QUERY_SPECIFIC_PARAMETER_LIST_IDS.add(QueryParameterIdentifiers.OLD_VALUE_LIST);
        VAR_QUERY_SPECIFIC_PARAMETER_LIST_IDS.add(QueryParameterIdentifiers.VAR_VALUE_ID_LIST);
    }
}

