/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query.helpers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.instance.command.GetProcessInstanceVariableCommand;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.kie.api.task.model.TaskSummary;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.RemoteServicesQueryCommandBuilder;
import org.kie.remote.services.rest.query.RemoteServicesQueryJPAService;
import org.kie.remote.services.rest.query.helpers.AbstractInternalQueryHelper;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryTaskInfo;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbQueryTaskResult;
import org.kie.services.client.serialization.jaxb.impl.query.JaxbVariableInfo;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskSummary;

public class InternalTaskQueryHelper
extends AbstractInternalQueryHelper<JaxbQueryTaskResult> {
    public InternalTaskQueryHelper(ResourceBase resourceBase) {
        super(resourceBase);
    }

    @Override
    protected void createAndSetQueryBuilders(String identity) {
        if (identity == null || identity.trim().isEmpty()) {
            throw KieRemoteRestOperationException.forbidden("Unknown and unauthorized user [" + identity + "] when querying tasks");
        }
        RemoteServicesQueryCommandBuilder taskQueryBuilder = new RemoteServicesQueryCommandBuilder(identity);
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = new RemoteServicesQueryCommandBuilder();
        this.setQueryBuilders(taskQueryBuilder, varInstLogQueryBuilder);
    }

    @Override
    public JaxbQueryTaskResult doQueryAndCreateResultObjects(boolean onlyRetrieveLastVarLogs, boolean workFlowInstanceVariables, int[] pageInfo) {
        RemoteServicesQueryCommandBuilder[] queryBuilders = this.getQueryBuilders();
        RemoteServicesQueryCommandBuilder taskQueryBuilder = queryBuilders[0];
        RemoteServicesQueryCommandBuilder varInstLogQueryBuilder = queryBuilders[1];
        if (this.variableCriteriaInQuery(varInstLogQueryBuilder.getQueryWhere().getCriteria()) && onlyRetrieveLastVarLogs) {
            taskQueryBuilder.last();
            varInstLogQueryBuilder.last();
        }
        taskQueryBuilder.ascending(RemoteServicesQueryCommandBuilder.OrderBy.processInstanceId);
        RemoteServicesQueryJPAService jpaService = this.resourceBase.getJPAService();
        List<TaskSummaryImpl> taskSummaryImpls = jpaService.doTaskSummaryQuery(taskQueryBuilder.getTaskUserId(), this.resourceBase.getUserGroupCallback(), taskQueryBuilder.getQueryWhere());
        ArrayList<TaskSummary> taskSummaries = new ArrayList<TaskSummary>(taskSummaryImpls.size());
        for (TaskSummaryImpl impl : taskSummaryImpls) {
            taskSummaries.add((TaskSummary)impl);
        }
        if (pageInfo[1] > 0) {
            long[] procInstIds = this.getIncludedProcessInstanceIdsAndRemoveUnneededTaskSummaries(taskSummaries, pageInfo);
            varInstLogQueryBuilder.processInstanceId(procInstIds);
        }
        varInstLogQueryBuilder.ascending(RemoteServicesQueryCommandBuilder.OrderBy.processInstanceId);
        List<VariableInstanceLog> varLogs = jpaService.doQuery(varInstLogQueryBuilder.getQueryWhere(), VariableInstanceLog.class);
        List<JaxbVariableInfo> procVars = null;
        if (workFlowInstanceVariables) {
            for (VariableInstanceLog varLog : varLogs) {
                String deploymentId = varLog.getExternalId();
                Long processInstId = varLog.getProcessInstanceId();
                GetProcessInstanceVariableCommand cmd = new GetProcessInstanceVariableCommand();
                cmd.setProcessInstanceId(processInstId);
                cmd.setVariableId(varLog.getVariableId());
            }
        }
        JaxbQueryTaskResult result = InternalTaskQueryHelper.createQueryTaskResult(taskSummaries, varLogs, procVars, pageInfo);
        return result;
    }

    private long[] getIncludedProcessInstanceIdsAndRemoveUnneededTaskSummaries(List<TaskSummary> taskSummaries, int[] pageInfo) {
        int offset = InternalTaskQueryHelper.getOffset(pageInfo);
        HashSet<Long> exclProcInstids = new HashSet<Long>();
        Iterator<TaskSummary> iter = taskSummaries.iterator();
        while (iter.hasNext() && exclProcInstids.size() < offset) {
            TaskSummary taskSum = iter.next();
            exclProcInstids.add(taskSum.getProcessInstanceId());
            iter.remove();
        }
        HashSet<Long> inclProcInstids = new HashSet<Long>();
        iter = taskSummaries.iterator();
        while (iter.hasNext()) {
            Long procInstId = iter.next().getProcessInstanceId();
            if (!exclProcInstids.contains(procInstId) && inclProcInstids.size() < pageInfo[1]) {
                inclProcInstids.add(procInstId);
                continue;
            }
            if (inclProcInstids.contains(procInstId)) continue;
            iter.remove();
        }
        long[] procInstIdArr = new long[inclProcInstids.size()];
        int i = 0;
        for (Long boxedId : inclProcInstids) {
            procInstIdArr[i++] = boxedId;
        }
        return procInstIdArr;
    }

    private static JaxbQueryTaskResult createQueryTaskResult(List<TaskSummary> taskSummaries, List<VariableInstanceLog> varLogs, List<JaxbVariableInfo> processVariables, int[] pageInfo) {
        JaxbQueryTaskResult result = new JaxbQueryTaskResult();
        LinkedHashMap<Long, JaxbQueryTaskInfo> procInstIdTaskInfoMap = new LinkedHashMap<Long, JaxbQueryTaskInfo>();
        int maxNumResultsNeeded = ResourceBase.getMaxNumResultsNeeded(pageInfo);
        int i = 0;
        HashSet<Long> uniqueTaskSummaryIds = new HashSet<Long>(0);
        while (procInstIdTaskInfoMap.size() < maxNumResultsNeeded && i < taskSummaries.size()) {
            TaskSummary taskSum = taskSummaries.get(i++);
            assert (uniqueTaskSummaryIds.add(taskSum.getId())) : "Duplicate task summary found with id " + taskSum.getId();
            long procInstId = taskSum.getProcessInstanceId();
            JaxbQueryTaskInfo taskInfo = InternalTaskQueryHelper.createJaxbQueryTaskInfo(procInstId, procInstIdTaskInfoMap);
            taskInfo.getTaskSummaries().add(new JaxbTaskSummary(taskSum));
        }
        HashSet<Long> uniqueVarLogIds = new HashSet<Long>(0);
        for (VariableInstanceLog varLog : varLogs) {
            assert (uniqueVarLogIds.add(varLog.getId())) : "Duplicate variable instance log found with id " + varLog.getId();
            long procInstId = varLog.getProcessInstanceId();
            JaxbQueryTaskInfo taskInfo = procInstIdTaskInfoMap.get(procInstId);
            if (taskInfo == null) continue;
            taskInfo.getVariables().add(new JaxbVariableInfo((org.kie.api.runtime.manager.audit.VariableInstanceLog)varLog));
        }
        result.getTaskInfoList().addAll(procInstIdTaskInfoMap.values());
        return result;
    }

    private static JaxbQueryTaskInfo createJaxbQueryTaskInfo(long procInstId, Map<Long, JaxbQueryTaskInfo> procInstIdTaskInfoMap) {
        JaxbQueryTaskInfo taskInfo = procInstIdTaskInfoMap.get(procInstId);
        if (taskInfo == null) {
            taskInfo = new JaxbQueryTaskInfo(procInstId);
            procInstIdTaskInfoMap.put(procInstId, taskInfo);
        }
        return taskInfo;
    }
}

