/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query.data;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.task.model.Status;
import org.kie.remote.services.exception.KieRemoteServicesInternalError;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;

public class QueryResourceData {
    static final String[] generalQueryParams;
    static final String[] generalQueryParamsShort;
    public static final String[] taskQueryParams;
    public static final String[] taskQueryParamsShort;
    public static final String[] procInstQueryParams;
    public static final String[] procInstQueryParamsShort;
    public static final String[] varInstQueryParams;
    public static final String[] varInstQueryParamsShort;
    static final String[] nameValueParams;
    static final String[] minMaxParams;
    static final String[] regexParams;
    public static final String[] metaRuntimeParams;
    public static final String[] metaRuntimeParamsShort;
    public static final Map<Integer, String> actionParamNameMap;
    public static final Map<String, Integer> paramNameActionMap;
    protected static final int GENERAL_END = 3;
    protected static final int TASK_END = 10;
    protected static final int PROCESS_END = 14;
    protected static final int VARIABLE_END = 19;
    protected static final int META_END = 21;
    private static final Set<String> allQueryParameters;
    private static final Set<String> procInstOnlyQueryParameters;
    public static final SimpleDateFormat QUERY_PARAM_DATE_FORMAT;

    private static int addParamsToActionMap(int idGen, String[] params, String[] paramsShort) {
        if (params.length != paramsShort.length) {
            throw new KieRemoteServicesInternalError(params.length + " params but " + paramsShort.length + " abbreviated params!");
        }
        for (int i = 0; i < params.length; ++i) {
            int id = idGen++;
            paramNameActionMap.put(params[i], id);
            actionParamNameMap.put(id, params[i]);
            if (paramsShort[i] == null) continue;
            paramNameActionMap.put(paramsShort[i], id);
        }
        return idGen;
    }

    public static Set<String> getQueryParameters(boolean getAllQueryParameters) {
        return getAllQueryParameters ? allQueryParameters : procInstOnlyQueryParameters;
    }

    public static long[] getLongs(int action, String[] data) {
        int i;
        String name = actionParamNameMap.get(action);
        long[] result = new long[data.length];
        try {
            for (i = 0; i < data.length; ++i) {
                result[i] = Long.valueOf(data[i]);
            }
        }
        catch (NumberFormatException nfe) {
            throw KieRemoteRestOperationException.badRequest("Values for query parameter '" + name + "' must be long (" + data[i] + ")");
        }
        return result;
    }

    public static int[] getInts(int action, String[] data) {
        int i;
        String name = actionParamNameMap.get(action);
        int[] result = new int[data.length];
        try {
            for (i = 0; i < data.length; ++i) {
                result[i] = Integer.valueOf(data[i]);
            }
        }
        catch (NumberFormatException nfe) {
            throw KieRemoteRestOperationException.badRequest("Values for query parameter '" + name + "' must be integers (" + data[i] + ")");
        }
        return result;
    }

    public static Timestamp[] getDates(int action, String[] data) {
        Timestamp[] result = new Timestamp[data.length];
        for (int i = 0; i < data.length; ++i) {
            result[i] = QueryResourceData.parseDate(data[i]);
        }
        return result;
    }

    private static Timestamp parseDate(String dateStr) {
        String[] parts = dateStr.split("_");
        String[] dateParts = null;
        String[] timeParts = null;
        String parseDateStr = null;
        if (parts.length == 2) {
            dateParts = parts[0].split("-");
            if (dateParts.length != 3) {
                QueryResourceData.badDateString(dateStr);
            }
            if ((timeParts = parts[1].split(":")).length != 3) {
                QueryResourceData.badDateString(dateStr);
            }
            parseDateStr = dateStr;
        } else if (parts.length == 1) {
            dateParts = parts[0].split("-");
            timeParts = parts[0].split(":");
            if (timeParts.length == 3 && dateParts.length == 1) {
                dateParts = QUERY_PARAM_DATE_FORMAT.format(new Date()).split("_")[0].split("-");
            } else if (dateParts.length == 3 && timeParts.length == 1) {
                String[] newTimeParts = new String[]{"0", "0", "0.000"};
                timeParts = newTimeParts;
            } else {
                QueryResourceData.badDateString(dateStr);
            }
        } else {
            QueryResourceData.badDateString(dateStr);
        }
        if (parseDateStr == null) {
            int i;
            StringBuilder tmpStr = new StringBuilder(dateParts[0]);
            for (i = 1; i < 3; ++i) {
                tmpStr.append("-").append(dateParts[i]);
            }
            tmpStr.append("_");
            tmpStr.append(timeParts[0]);
            if (!timeParts[2].contains(".")) {
                timeParts[2] = timeParts[2] + ".000";
            }
            for (i = 1; i < 3; ++i) {
                tmpStr.append(":").append(timeParts[i]);
            }
            parseDateStr = tmpStr.toString();
        } else if (!timeParts[2].contains(".")) {
            parseDateStr = parseDateStr + ".000";
        }
        try {
            Date date = QUERY_PARAM_DATE_FORMAT.parse(parseDateStr);
            return new Timestamp(date.getTime());
        }
        catch (ParseException pe) {
            QueryResourceData.badDateString(parseDateStr);
            throw new KieRemoteServicesInternalError("Unable to parse date string '" + parseDateStr + "'", pe);
        }
    }

    private static void badDateString(String dateStr) {
        throw KieRemoteRestOperationException.badRequest("'" + dateStr + "' is not a valid format for a date value query parameter.");
    }

    public static Status[] getTaskStatuses(String[] data) {
        Status[] result = new Status[data.length];
        for (int i = 0; i < data.length; ++i) {
            if (data[i].toLowerCase().equals(Status.InProgress.toString().toLowerCase())) {
                result[i] = Status.InProgress;
                continue;
            }
            String value = data[i].substring(0, 1).toUpperCase() + data[i].substring(1);
            try {
                result[i] = Status.valueOf((String)value);
                continue;
            }
            catch (Exception e) {
                throw KieRemoteRestOperationException.badRequest("Task status '" + data[i] + "' is not valid.");
            }
        }
        return result;
    }

    public static boolean isNameValueParam(String queryParam) {
        for (String allowedParam : nameValueParams) {
            if (!queryParam.toLowerCase().startsWith(allowedParam + "_")) continue;
            return true;
        }
        return false;
    }

    static {
        String[] paramArr;
        int i$;
        String[][] taskQueryParamArrs;
        generalQueryParams = new String[]{"processinstanceid", "processid", "deploymentid"};
        generalQueryParamsShort = new String[]{"piid", "pid", "did"};
        taskQueryParams = new String[]{"taskid", "initiator", "stakeholder", "potentialowner", "taskowner", "businessadmin", "taskstatus"};
        taskQueryParamsShort = new String[]{"tid", "init", "stho", "po", "to", "ba", "tst"};
        procInstQueryParams = new String[]{"processinstancestatus", "processversion", "startdate", "enddate"};
        procInstQueryParamsShort = new String[]{"pist", "pv", "stdt", "edt"};
        varInstQueryParams = new String[]{"varid", "varvalue", "var", "varregex", "all"};
        varInstQueryParamsShort = new String[]{"vid", "vv", null, "vr", null};
        nameValueParams = new String[]{varInstQueryParams[2], varInstQueryParams[3], varInstQueryParamsShort[3]};
        minMaxParams = new String[]{generalQueryParams[0], generalQueryParamsShort[0], taskQueryParams[0], taskQueryParamsShort[0], procInstQueryParams[2], procInstQueryParamsShort[2], procInstQueryParams[3], procInstQueryParamsShort[3]};
        regexParams = new String[]{generalQueryParams[1], generalQueryParamsShort[1], generalQueryParams[2], generalQueryParamsShort[2], taskQueryParams[1], taskQueryParamsShort[1], taskQueryParams[2], taskQueryParamsShort[2], taskQueryParams[3], taskQueryParamsShort[3], taskQueryParams[4], taskQueryParamsShort[4], taskQueryParams[5], taskQueryParamsShort[5], procInstQueryParams[1], procInstQueryParamsShort[1], varInstQueryParams[0], varInstQueryParamsShort[0], varInstQueryParams[1], varInstQueryParamsShort[1], varInstQueryParams[3], varInstQueryParamsShort[3]};
        metaRuntimeParams = new String[]{"memory", "history"};
        metaRuntimeParamsShort = new String[]{"mem", "hist"};
        actionParamNameMap = new ConcurrentHashMap<Integer, String>();
        paramNameActionMap = new ConcurrentHashMap<String, Integer>();
        int idGen = 0;
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, generalQueryParams, generalQueryParamsShort)) != 3) {
            throw new KieRemoteServicesInternalError("General query parameters [" + idGen + "]");
        }
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, taskQueryParams, taskQueryParamsShort)) != 10) {
            throw new KieRemoteServicesInternalError("Task query parameters [" + idGen + "]");
        }
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, procInstQueryParams, procInstQueryParamsShort)) != 14) {
            throw new KieRemoteServicesInternalError("Process instance query parameters [" + idGen + "]");
        }
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, varInstQueryParams, varInstQueryParamsShort)) != 19) {
            throw new KieRemoteServicesInternalError("Variable instance query parameters [" + idGen + "]");
        }
        if ((idGen = QueryResourceData.addParamsToActionMap(idGen, metaRuntimeParams, metaRuntimeParamsShort)) != 21) {
            throw new KieRemoteServicesInternalError("Meta parameters [" + idGen + "]");
        }
        allQueryParameters = Collections.newSetFromMap(new ConcurrentHashMap());
        procInstOnlyQueryParameters = Collections.newSetFromMap(new ConcurrentHashMap());
        HashSet<String> taskQueryParamSet = new HashSet<String>();
        String[][] arr$ = taskQueryParamArrs = new String[][]{taskQueryParams, taskQueryParamsShort};
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            for (String param : paramArr = arr$[i$]) {
                if (param == null) continue;
                allQueryParameters.add(param);
                taskQueryParamSet.add(param);
            }
        }
        String[][] procInstOnlyQueryParamArrs = new String[][]{generalQueryParams, generalQueryParamsShort, procInstQueryParams, procInstQueryParamsShort, varInstQueryParams, varInstQueryParamsShort};
        arr$ = procInstOnlyQueryParamArrs;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            for (String param : paramArr = arr$[i$]) {
                if (param == null) continue;
                procInstOnlyQueryParameters.add(param);
                allQueryParameters.add(param);
            }
        }
        for (String param : minMaxParams) {
            String min = param + "_min";
            String max = param + "_max";
            allQueryParameters.add(min);
            allQueryParameters.add(max);
            if (taskQueryParamSet.contains(param)) continue;
            procInstOnlyQueryParameters.add(min);
            procInstOnlyQueryParameters.add(max);
        }
        for (String param : regexParams) {
            param = param + "_re";
            allQueryParameters.add(param);
            if (taskQueryParamSet.contains(param)) continue;
            procInstOnlyQueryParameters.add(param);
        }
        QUERY_PARAM_DATE_FORMAT = new SimpleDateFormat("yy-MM-dd_HH:mm:ss.SSS");
    }
}

