/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.util;

import java.util.List;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.api.command.Command;
import org.kie.internal.identity.IdentityProvider;
import org.kie.remote.services.AcceptedServerCommands;
import org.kie.remote.services.cdi.ProcessRequestBean;
import org.kie.remote.services.jaxb.JaxbCommandsRequest;
import org.kie.remote.services.jaxb.JaxbCommandsResponse;
import org.kie.remote.services.rest.ExecuteResourceImpl;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteCommandUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ExecuteResourceImpl.class);
    private static Boolean allowAllUsersAccessToAllTasks = Boolean.getBoolean("org.kie.task.insecure");

    private ExecuteCommandUtil() {
    }

    public static JaxbCommandsResponse restProcessJaxbCommandsRequest(JaxbCommandsRequest request, IdentityProvider identityProvider, ProcessRequestBean processRequestBean) {
        JaxbCommandsResponse jaxbResponse = new JaxbCommandsResponse(request);
        List<Command> commands = request.getCommands();
        if (commands != null) {
            Command cmd;
            int i;
            int cmdListSize = commands.size();
            for (i = 0; i < cmdListSize; ++i) {
                cmd = commands.get(i);
                if (!AcceptedServerCommands.isAcceptedCommandClass(cmd.getClass())) {
                    throw KieRemoteRestOperationException.forbidden("The execute REST operation does not accept " + cmd.getClass().getName() + " instances.");
                }
                if (!(cmd instanceof TaskCommand)) continue;
                String cmdName = cmd.getClass().getSimpleName();
                if (allowAllUsersAccessToAllTasks.booleanValue() || !cmdName.startsWith("GetTask")) continue;
                String cmdUserId = ((TaskCommand)cmd).getUserId();
                if (cmdUserId == null) {
                    throw KieRemoteRestOperationException.badRequest("A null user id for a '" + cmdName + "' is not allowed!");
                }
                String authUserId = identityProvider.getName();
                if (cmdUserId.equals(authUserId)) continue;
                throw KieRemoteRestOperationException.conflict("The user id used when retrieving task information (" + cmdUserId + ")" + " must match the authenticating user (" + authUserId + ")!");
            }
            for (i = 0; i < cmdListSize; ++i) {
                cmd = commands.get(i);
                processRequestBean.processCommand(cmd, request, i, jaxbResponse);
            }
        }
        if (commands == null || commands.isEmpty()) {
            logger.info("Commands request object with no commands sent!");
        }
        return jaxbResponse;
    }
}

