/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.jms;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.ConcurrencyManagement;
import javax.ejb.ConcurrencyManagementType;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
@ConcurrencyManagement(value=ConcurrencyManagementType.CONTAINER)
public class RetryTrackerSingleton {
    private static final Logger logger = LoggerFactory.getLogger(RetryTrackerSingleton.class);
    private static final int MSG_RETRY_CACHE_LIMIT = 1000;
    private HashMap<String, Integer> msgIdRetryMap = new LinkedHashMap<String, Integer>(){
        private static final long serialVersionUID = 6031151588684920520L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
            return this.size() > 1000;
        }
    };
    private Integer RETRY_LIMIT = null;
    private int RETRY_LIMIT_DEFAULT = 2;
    private static final String RETRY_LIMIT_NAME_PROPERTY = "kie.services.jms.retries.limit";

    @PostConstruct
    public void init() {
        String retryLimitStr = System.getProperty(RETRY_LIMIT_NAME_PROPERTY, Integer.toString(this.RETRY_LIMIT_DEFAULT));
        try {
            this.RETRY_LIMIT = Integer.parseInt(retryLimitStr);
        }
        catch (Exception e) {
            logger.warn("Unable to parse '" + retryLimitStr + "' as number for " + RETRY_LIMIT_NAME_PROPERTY + " property.");
            this.RETRY_LIMIT = this.RETRY_LIMIT_DEFAULT;
        }
        logger.info("JMS message retry limit set to " + this.RETRY_LIMIT);
    }

    @Lock(value=LockType.READ)
    public int getMaximumLimitRetries() {
        return this.RETRY_LIMIT;
    }

    @Lock(value=LockType.READ)
    public boolean maxRetriesReached(String msgId) {
        Integer retries = this.msgIdRetryMap.get(msgId);
        if (retries == null) {
            return false;
        }
        return retries >= this.RETRY_LIMIT;
    }

    @Lock(value=LockType.WRITE)
    public int incrementRetries(String msgId) {
        Integer retries = this.msgIdRetryMap.get(msgId);
        if (retries == null) {
            retries = 0;
        }
        retries = retries + 1;
        this.msgIdRetryMap.put(msgId, retries);
        return retries;
    }

    @Lock(value=LockType.WRITE)
    public void clearRetries(String msgId) {
        this.msgIdRetryMap.remove(msgId);
    }
}

