/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.drools.core.util.StringUtils;
import org.jbpm.services.task.audit.commands.DeleteBAMTaskSummariesCommand;
import org.jbpm.services.task.commands.ActivateTaskCommand;
import org.jbpm.services.task.commands.ClaimNextAvailableTaskCommand;
import org.jbpm.services.task.commands.ClaimTaskCommand;
import org.jbpm.services.task.commands.CompleteTaskCommand;
import org.jbpm.services.task.commands.DelegateTaskCommand;
import org.jbpm.services.task.commands.ExitTaskCommand;
import org.jbpm.services.task.commands.FailTaskCommand;
import org.jbpm.services.task.commands.ForwardTaskCommand;
import org.jbpm.services.task.commands.GetContentByIdCommand;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.jbpm.services.task.commands.NominateTaskCommand;
import org.jbpm.services.task.commands.ReleaseTaskCommand;
import org.jbpm.services.task.commands.ResumeTaskCommand;
import org.jbpm.services.task.commands.SkipTaskCommand;
import org.jbpm.services.task.commands.StartTaskCommand;
import org.jbpm.services.task.commands.StopTaskCommand;
import org.jbpm.services.task.commands.SuspendTaskCommand;
import org.jbpm.services.task.impl.model.xml.JaxbContent;
import org.jbpm.services.task.impl.model.xml.JaxbTask;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Task;
import org.kie.internal.identity.IdentityProvider;
import org.kie.remote.services.rest.QueryResourceImpl;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.RuntimeResourceImpl;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.util.FormURLGenerator;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskFormResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/task")
@RequestScoped
public class TaskResourceImpl
extends ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeResourceImpl.class);
    @Context
    protected HttpHeaders headers;
    @Inject
    private FormURLGenerator formURLGenerator;
    @Inject
    protected IdentityProvider identityProvider;
    @Inject
    protected QueryResourceImpl queryResource;
    private static final String[] allowedOperations = new String[]{"activate", "claim", "claimnextavailable", "complete", "delegate", "exit", "fail", "forward", "release", "resume", "skip", "start", "stop", "suspend", "nominate", "content"};

    @GET
    @Path(value="/query")
    @RolesAllowed(value={"rest-all", "rest-query"})
    @Deprecated
    public Response query() {
        return this.queryResource.taskSummaryQuery();
    }

    @GET
    @Path(value="/{taskId: [0-9-]+}")
    @RolesAllowed(value={"rest-all", "rest-task-read-only", "rest-task"})
    public Response getTask(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        JaxbTask task = (JaxbTask)this.doRestTaskOperationWithTaskId(taskId, cmd);
        if (task == null) {
            throw KieRemoteRestOperationException.notFound("Task " + taskId + " could not be found.");
        }
        return TaskResourceImpl.createCorrectVariant(task, this.headers);
    }

    @POST
    @Path(value="/{taskId: [0-9-]+}/{oper: [a-zA-Z]+}")
    @RolesAllowed(value={"rest-all", "rest-task"})
    public Response doTaskOperation(@PathParam(value="taskId") long taskId, @PathParam(value="oper") String operation) {
        Map<String, String[]> params = this.getRequestParams();
        operation = TaskResourceImpl.checkThatOperationExists(operation, allowedOperations);
        String oper = this.getRelativePath();
        String userId = this.identityProvider.getName();
        logger.debug("Executing " + operation + " on task " + taskId + " by user " + userId);
        ActivateTaskCommand cmd = null;
        if ("activate".equalsIgnoreCase(operation)) {
            cmd = new ActivateTaskCommand(taskId, userId);
        } else if ("claim".equalsIgnoreCase(operation)) {
            cmd = new ClaimTaskCommand(taskId, userId);
        } else if ("claimnextavailable".equalsIgnoreCase(operation)) {
            cmd = new ClaimNextAvailableTaskCommand(userId);
        } else if ("complete".equalsIgnoreCase(operation)) {
            Map<String, Object> data = TaskResourceImpl.extractMapFromParams(params, operation);
            cmd = new CompleteTaskCommand(taskId, userId, data);
        } else if ("delegate".equalsIgnoreCase(operation)) {
            String targetEntityId = TaskResourceImpl.getStringParam("targetEntityId", true, params, oper);
            cmd = new DelegateTaskCommand(taskId, userId, targetEntityId);
        } else if ("exit".equalsIgnoreCase(operation)) {
            cmd = new ExitTaskCommand(taskId, userId);
        } else if ("fail".equalsIgnoreCase(operation)) {
            Map<String, Object> data = TaskResourceImpl.extractMapFromParams(params, oper);
            cmd = new FailTaskCommand(taskId, userId, data);
        } else if ("forward".equalsIgnoreCase(operation)) {
            String targetEntityId = TaskResourceImpl.getStringParam("targetEntityId", true, params, oper);
            cmd = new ForwardTaskCommand(taskId, userId, targetEntityId);
        } else if ("release".equalsIgnoreCase(operation)) {
            cmd = new ReleaseTaskCommand(taskId, userId);
        } else if ("resume".equalsIgnoreCase(operation)) {
            cmd = new ResumeTaskCommand(taskId, userId);
        } else if ("skip".equalsIgnoreCase(operation)) {
            cmd = new SkipTaskCommand(taskId, userId);
        } else if ("start".equalsIgnoreCase(operation)) {
            cmd = new StartTaskCommand(taskId, userId);
        } else if ("stop".equalsIgnoreCase(operation)) {
            cmd = new StopTaskCommand(taskId, userId);
        } else if ("suspend".equalsIgnoreCase(operation)) {
            cmd = new SuspendTaskCommand(taskId, userId);
        } else if ("nominate".equalsIgnoreCase(operation)) {
            List<OrganizationalEntity> potentialOwners = TaskResourceImpl.getOrganizationalEntityListFromParams(params, true, oper);
            cmd = new NominateTaskCommand(taskId, userId, potentialOwners);
        } else {
            throw KieRemoteRestOperationException.badRequest("Unsupported operation: " + oper);
        }
        this.doRestTaskOperationWithTaskId(taskId, cmd);
        return TaskResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    private static String checkThatOperationExists(String operation, String[] possibleOperations) {
        for (String oper : possibleOperations) {
            if (!oper.equals(operation.trim().toLowerCase())) continue;
            return oper;
        }
        throw KieRemoteRestOperationException.badRequest("Operation '" + operation + "' is not supported on tasks.");
    }

    @GET
    @Path(value="/{taskId: [0-9-]+}/content")
    @RolesAllowed(value={"rest-all", "rest-task-read-only", "rest-task"})
    public Response getTaskContentByTaskId(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        Object result = this.doRestTaskOperationWithTaskId(taskId, cmd);
        if (result == null) {
            throw KieRemoteRestOperationException.notFound("Task " + taskId + " could not be found.");
        }
        Task task = (Task)result;
        long contentId = task.getTaskData().getDocumentContentId();
        JaxbContent jaxbContent = null;
        if (contentId <= -1L) {
            throw KieRemoteRestOperationException.notFound("Content for task " + taskId + " could not be found.");
        }
        cmd = new GetContentByIdCommand(Long.valueOf(contentId));
        result = this.processRequestBean.doRestTaskOperation(taskId, task.getTaskData().getDeploymentId(), task.getTaskData().getProcessInstanceId(), task, cmd);
        jaxbContent = (JaxbContent)result;
        return TaskResourceImpl.createCorrectVariant(jaxbContent, this.headers);
    }

    @GET
    @Path(value="/{taskId: [0-9-]+}/showTaskForm")
    @RolesAllowed(value={"rest-all", "rest-task-read-only", "rest-task"})
    public Response getTaskFormByTaskId(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        Object result = this.doRestTaskOperationWithTaskId(taskId, cmd);
        if (result != null) {
            String formUrl;
            String opener = "";
            List openers = this.headers.getRequestHeader("host");
            if (openers.size() == 1) {
                opener = (String)openers.get(0);
            }
            if (!StringUtils.isEmpty((CharSequence)(formUrl = this.formURLGenerator.generateFormTaskURL(this.getBaseUri(), taskId, opener)))) {
                JaxbTaskFormResponse response = new JaxbTaskFormResponse(formUrl, this.getRequestUri());
                return TaskResourceImpl.createCorrectVariant(response, this.headers);
            }
        }
        throw KieRemoteRestOperationException.notFound("Task " + taskId + " could not be found.");
    }

    @GET
    @Path(value="/content/{contentId: [0-9-]+}")
    @RolesAllowed(value={"rest-all", "rest-task-read-only", "rest-task"})
    public Response getTaskContentByContentId(@PathParam(value="contentId") long contentId) {
        GetContentByIdCommand cmd = new GetContentByIdCommand(Long.valueOf(contentId));
        cmd.setUserId(this.identityProvider.getName());
        JaxbContent jaxbContent = (JaxbContent)this.doRestTaskOperation(cmd);
        if (jaxbContent == null) {
            throw KieRemoteRestOperationException.notFound("Content " + contentId + " could not be found.");
        }
        return TaskResourceImpl.createCorrectVariant(jaxbContent, this.headers);
    }

    @POST
    @Path(value="/history/bam/clear")
    @RolesAllowed(value={"rest-all", "rest-task"})
    public Response clearTaskBamHistory() {
        this.doRestTaskOperation(new DeleteBAMTaskSummariesCommand());
        return TaskResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRelativePath()), this.headers);
    }
}

