/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.jaxb;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import org.apache.deltaspike.core.api.provider.BeanManagerProvider;
import org.kie.remote.services.rest.jaxb.DynamicJaxbContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class JaxbContextResolver
implements ContextResolver<JAXBContext> {
    private static final Logger logger = LoggerFactory.getLogger(JaxbContextResolver.class);
    @Inject
    DynamicJaxbContextManager dynamicContextManager;

    @PostConstruct
    public void configure() {
        if (this.dynamicContextManager == null) {
            logger.info("JaxbContextResolver does not support CDI injection, looking up DynamicJaxbContext programmatically");
            BeanManager beanManager = BeanManagerProvider.getInstance().getBeanManager();
            try {
                Set beans = beanManager.getBeans(DynamicJaxbContextManager.class, new Annotation[0]);
                if (beans != null && !beans.isEmpty()) {
                    Bean bean = (Bean)beans.iterator().next();
                    this.dynamicContextManager = (DynamicJaxbContextManager)beanManager.getReference(bean, DynamicJaxbContextManager.class, beanManager.createCreationalContext((Contextual)bean));
                }
            }
            catch (Exception e) {
                logger.warn("Unable to retrieve DynamicJaxbContext programmatically from cdi container due to {}", (Object)e.getMessage());
            }
        }
    }

    public JAXBContext getContext(Class<?> type) {
        return this.dynamicContextManager.getJaxbContext();
    }
}

