/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.SingularAttribute;
import org.jbpm.process.audit.AuditQueryCriteriaUtil;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog_;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog_;
import org.jbpm.query.jpa.data.QueryCriteria;
import org.jbpm.query.jpa.data.QueryParameterIdentifiersUtil;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.query.jpa.impl.QueryCriteriaUtil;
import org.jbpm.services.task.impl.model.PeopleAssignmentsImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl;
import org.jbpm.services.task.impl.model.TaskDataImpl_;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.TaskImpl_;
import org.jbpm.services.task.persistence.TaskSummaryQueryCriteriaUtil;
import org.kie.remote.services.rest.query.RemoteServicesQueryData;
import org.kie.remote.services.rest.query.RemoteServicesQueryJPAService;

public class RemoteServicesCriteriaUtil {
    public static <Q> Class getJoinRootClassAndAddNeededJoin(CriteriaQuery<Q> query, CriteriaBuilder builder, Class queryType, QueryCriteria criteria, QueryWhere queryWhere) {
        String listId = criteria.getListId();
        Class<VariableInstanceLog> newJoinRootClass = null;
        if (ProcessInstanceLog.class.equals((Object)queryType)) {
            Root procInstLogRoot = QueryCriteriaUtil.getRoot(query, (Class)queryType);
            if (RemoteServicesQueryData.varInstLogNeededCriterias.contains(listId) || RemoteServicesQueryData.varInstLogSpecificCriterias.contains(listId)) {
                newJoinRootClass = VariableInstanceLog.class;
                RemoteServicesCriteriaUtil.addAuditRootAndJoinClauseIfNeeded(query, builder, queryWhere, criteria, newJoinRootClass, procInstLogRoot.get(ProcessInstanceLog_.processInstanceId), VariableInstanceLog_.processInstanceId);
            } else if (RemoteServicesQueryData.taskNeededCriterias.contains(listId) || RemoteServicesQueryData.taskSpecificCriterias.contains(listId)) {
                newJoinRootClass = TaskImpl.class;
                RemoteServicesCriteriaUtil.addTaskRootAndJoinClauseIfNeeded(query, builder, queryWhere, criteria, procInstLogRoot.get(ProcessInstanceLog_.processInstanceId));
            }
        } else if (VariableInstanceLog.class.equals((Object)queryType)) {
            if (RemoteServicesQueryData.varInstLogSpecificCriterias.contains(listId)) {
                return VariableInstanceLog.class;
            }
            Root varInstLogRoot = QueryCriteriaUtil.getRoot(query, (Class)queryType);
            if (RemoteServicesQueryData.taskNeededCriterias.contains(listId) || RemoteServicesQueryData.taskSpecificCriterias.contains(listId)) {
                newJoinRootClass = TaskImpl.class;
                RemoteServicesCriteriaUtil.addTaskRootAndJoinClauseIfNeeded(query, builder, queryWhere, criteria, varInstLogRoot.get(VariableInstanceLog_.processInstanceId));
            } else if (RemoteServicesQueryData.procInstLogNeededCriterias.contains(listId)) {
                newJoinRootClass = ProcessInstanceLog.class;
                RemoteServicesCriteriaUtil.addAuditRootAndJoinClauseIfNeeded(query, builder, queryWhere, criteria, newJoinRootClass, varInstLogRoot.get(VariableInstanceLog_.processInstanceId), ProcessInstanceLog_.processInstanceId);
            }
        } else if (TaskImpl.class.equals((Object)queryType)) {
            if (RemoteServicesQueryData.taskSpecificCriterias.contains(listId)) {
                return TaskImpl.class;
            }
            Root taskRoot = QueryCriteriaUtil.getRoot(query, (Class)queryType);
            if (RemoteServicesQueryData.varInstLogNeededCriterias.contains(listId) || RemoteServicesQueryData.varInstLogSpecificCriterias.contains(listId)) {
                newJoinRootClass = VariableInstanceLog.class;
                RemoteServicesCriteriaUtil.addAuditRootAndJoinClauseIfNeeded(query, builder, queryWhere, criteria, newJoinRootClass, taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.processInstanceId), VariableInstanceLog_.processInstanceId);
            } else if (RemoteServicesQueryData.procInstLogNeededCriterias.contains(listId)) {
                newJoinRootClass = ProcessInstanceLog.class;
                RemoteServicesCriteriaUtil.addAuditRootAndJoinClauseIfNeeded(query, builder, queryWhere, criteria, newJoinRootClass, taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.processInstanceId), ProcessInstanceLog_.processInstanceId);
            }
        } else {
            throw new IllegalStateException("Unexpected query type " + queryType.getSimpleName() + " when processing criteria " + (String)QueryParameterIdentifiersUtil.getQueryParameterIdNameMap().get(Integer.parseInt(listId)) + " (" + criteria.toString() + ")");
        }
        if (newJoinRootClass == null) {
            throw new IllegalStateException("Unexpected criteria [" + (String)QueryParameterIdentifiersUtil.getQueryParameterIdNameMap().get(Integer.parseInt(listId)) + "] when joining to " + queryType.getSimpleName() + " query!");
        }
        return newJoinRootClass;
    }

    private static <Q, J> void addAuditRootAndJoinClauseIfNeeded(CriteriaQuery<Q> query, CriteriaBuilder builder, QueryWhere queryWhere, QueryCriteria criteria, Class<J> newJoinRootClass, Path origRootJoinFieldPath, SingularAttribute ... newJoinAttr) {
        Root newJoinRoot = null;
        for (Root root : query.getRoots()) {
            Class rootType = root.getJavaType();
            if (!rootType.equals(newJoinRootClass)) continue;
            newJoinRoot = root;
            break;
        }
        if (newJoinRoot == null) {
            newJoinRoot = query.from(newJoinRootClass);
            Path newJoinRootJoinFieldPath = newJoinRoot.get(newJoinAttr[0]);
            for (int i = 1; i < newJoinAttr.length; ++i) {
                newJoinRootJoinFieldPath = newJoinRootJoinFieldPath.get(newJoinAttr[i]);
            }
            Predicate joinPredicate = builder.equal((Expression)newJoinRootJoinFieldPath, (Expression)origRootJoinFieldPath);
            joinPredicate = queryWhere.getJoinPredicates().put(newJoinRootClass.getSimpleName(), joinPredicate);
            assert (joinPredicate == null) : "There is already an existing join to " + newJoinRootClass.getSimpleName();
        }
    }

    private static <Q, A> void addTaskRootAndJoinClauseIfNeeded(CriteriaQuery<Q> query, CriteriaBuilder builder, QueryWhere queryWhere, QueryCriteria criteria, Path origRootJoinFieldPath) {
        Root taskRoot = null;
        for (Root root : query.getRoots()) {
            Class rootType = root.getJavaType();
            if (!rootType.equals(TaskImpl.class)) continue;
            taskRoot = root;
            break;
        }
        if (taskRoot == null) {
            taskRoot = query.from(TaskImpl.class);
            Path newJoinRootJoinFieldPath = taskRoot.get(TaskImpl_.taskData).get(TaskDataImpl_.processInstanceId);
            Predicate joinPredicate = builder.equal((Expression)newJoinRootJoinFieldPath, (Expression)origRootJoinFieldPath);
            queryWhere.getJoinPredicates().put(TaskImpl.class.getSimpleName(), joinPredicate);
            assert (joinPredicate != null) : "There is already an existing join to " + TaskImpl.class.getSimpleName();
        }
    }

    public static <Q> Predicate createJoinedAuditPredicateFromSingleCriteria(CriteriaQuery<Q> query, CriteriaBuilder builder, Attribute attr, QueryCriteria criteria, QueryWhere queryWhere) {
        String listId = criteria.getListId();
        if (RemoteServicesQueryData.varInstLogSpecificCriterias.contains(listId)) {
            Root table = QueryCriteriaUtil.getRoot(query, VariableInstanceLog.class);
            return AuditQueryCriteriaUtil.variableInstanceLogSpecificCreatePredicateFromSingleCriteria(query, (CriteriaBuilder)builder, (QueryCriteria)criteria, (Root)table);
        }
        Expression entityField = QueryCriteriaUtil.defaultGetEntityField(query, (String)listId, (Attribute)attr);
        return QueryCriteriaUtil.basicCreatePredicateFromSingleCriteria((CriteriaBuilder)builder, (Expression)entityField, (QueryCriteria)criteria);
    }

    public static <Q> Predicate createJoinedTaskPredicateFromSingleCriteria(CriteriaQuery<Q> query, CriteriaBuilder builder, Attribute attr, QueryCriteria criteria, QueryWhere queryWhere) {
        String listId = criteria.getListId();
        if (RemoteServicesQueryData.taskSpecificCriterias.contains(listId)) {
            return TaskSummaryQueryCriteriaUtil.taskSpecificCreatePredicateFromSingleCriteria(query, (CriteriaBuilder)builder, (QueryCriteria)criteria, (QueryWhere)queryWhere);
        }
        Root taskRoot = null;
        Join taskDataJoin = null;
        Join peopleAssignJoin = null;
        for (Root root : query.getRoots()) {
            if (!TaskImpl.class.equals((Object)root.getJavaType())) continue;
            taskRoot = root;
            for (Join join : taskRoot.getJoins()) {
                if (TaskDataImpl.class.equals((Object)join.getJavaType())) {
                    taskDataJoin = join;
                    continue;
                }
                if (!PeopleAssignmentsImpl.class.equals((Object)join.getJavaType())) continue;
                peopleAssignJoin = join;
            }
        }
        Expression entityField = TaskSummaryQueryCriteriaUtil.taskImplSpecificGetEntityField(query, taskRoot, taskDataJoin, peopleAssignJoin, (String)listId, (Attribute)attr);
        return QueryCriteriaUtil.basicCreatePredicateFromSingleCriteria((CriteriaBuilder)builder, (Expression)entityField, (QueryCriteria)criteria);
    }

    protected static <T> List<T> sharedCreateQueryAndCallApplyMetaCriteriaAndGetResult(QueryWhere queryWhere, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder, RemoteServicesQueryJPAService jpaService) {
        if (!queryWhere.getJoinPredicates().isEmpty()) {
            Predicate originalPredicate = criteriaQuery.getRestriction();
            ArrayList allPredicates = new ArrayList(queryWhere.getJoinPredicates().values());
            allPredicates.add(originalPredicate);
            Predicate newQueryPredicate = builder.and(allPredicates.toArray(new Predicate[allPredicates.size()]));
            criteriaQuery.where((Expression)newQueryPredicate);
        }
        criteriaQuery.distinct(true);
        EntityManager em = jpaService.getEntityManager();
        Object newTx = jpaService.joinTransaction(em);
        TypedQuery query = em.createQuery(criteriaQuery);
        QueryCriteriaUtil.applyMetaCriteriaToQuery((Query)query, (QueryWhere)queryWhere);
        List result = query.getResultList();
        jpaService.closeEntityManager(em, newTx);
        return result;
    }

    public class TASK_SPECIFIC_CRITERIA {
    }
}

