/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.cdi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.cdi.Deploy;
import org.jbpm.services.cdi.Undeploy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DeploymentInfoBean {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentInfoBean.class);
    private Set<String> deploymentIds = new CopyOnWriteArraySet<String>();

    public void addOnDeploy(@Observes @Deploy DeploymentEvent event) {
        this.deploymentIds.add(event.getDeploymentId());
    }

    public void removeOnUnDeploy(@Observes @Undeploy DeploymentEvent event) {
        this.deploymentIds.remove(event.getDeploymentId());
    }

    public Collection<String> getDeploymentIds() {
        return new ArrayList<String>(this.deploymentIds);
    }

    public static boolean emptyDeploymentId(String deploymentId) {
        return deploymentId == null || deploymentId.trim().isEmpty();
    }
}

