/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.jaxb;

import com.sun.xml.bind.v2.runtime.IllegalAnnotationException;
import com.sun.xml.bind.v2.runtime.IllegalAnnotationsException;
import com.sun.xml.bind.v2.runtime.Location;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.jbpm.services.api.DeploymentEvent;
import org.jbpm.services.api.model.DeploymentUnit;
import org.jbpm.services.cdi.Deploy;
import org.jbpm.services.cdi.Undeploy;
import org.kie.remote.services.exception.KieRemoteServicesDeploymentException;
import org.kie.remote.services.exception.KieRemoteServicesInternalError;
import org.kie.remote.services.jaxb.ServerJaxbSerializationProvider;
import org.kie.remote.services.rest.jaxb.DynamicJaxbContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DynamicJaxbContextManager {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJaxbContextManager.class);
    private static final boolean onWebsphere;
    private static final String WEBSPHERE_JAXB_CACHING_CLASS_NAME = "org.apache.wink.common.internal.providers.entity.xml.AbstractJAXBProvider";
    private static AtomicInteger instanceCreated;
    static Map<String, Collection<Class<?>>> deploymentClassesMap;
    private final DynamicJaxbContext _jaxbContextInstance = new DynamicJaxbContext();
    private static final String SMART_JAXB_CONTEXT_INIT_PROPERTY_NAME = "org.kie.remote.jaxb.smart.init";
    private static final boolean smartJaxbContextInitialization;
    private static final String EXPECTED_JAXB_CONTEXT_IMPL_CLASS = "com.sun.xml.bind.v2.runtime.JAXBContextImpl";

    public DynamicJaxbContextManager() {
        if (!instanceCreated.compareAndSet(0, 1)) {
            logger.error("Instance {} of the {} created!", (Object)instanceCreated.incrementAndGet(), (Object)DynamicJaxbContext.class.getSimpleName());
        }
    }

    public void addOnDeploy(@Observes @Deploy DeploymentEvent event) {
        String deploymentId = event.getDeploymentId();
        deploymentClassesMap.put(deploymentId, event.getDeployedUnit().getDeployedClasses());
        DeploymentUnit deploymentUnit = event.getDeployedUnit().getDeploymentUnit();
        ClassLoader projectClassLoader = ((KModuleDeploymentUnit)deploymentUnit).getKieContainer().getClassLoader();
        this.setupDeploymentJaxbContext(deploymentId, projectClassLoader);
    }

    public void removeOnUnDeploy(@Observes @Undeploy DeploymentEvent event) {
        String deploymentId = event.getDeploymentId();
        deploymentClassesMap.remove(deploymentId);
        JAXBContext deploymentJaxbContext = DynamicJaxbContext.contextsCache.remove(deploymentId);
        if (deploymentJaxbContext == null) {
            logger.error("JAXB context instance could not be found when undeploying deployment '" + deploymentId + "'!");
        }
    }

    void setupDeploymentJaxbContext(String deploymentId, ClassLoader projectClassLoader) {
        Collection<Class<?>> depClasses;
        if (DynamicJaxbContext.contextsCache.containsKey(deploymentId)) {
            logger.error("JAXB context instance already found when deploying deployment '" + deploymentId + "'!");
            DynamicJaxbContext.contextsCache.remove(deploymentId);
        }
        if ((depClasses = deploymentClassesMap.get(deploymentId)) == null || depClasses.size() == 0) {
            JAXBContext defaultJaxbContext = DynamicJaxbContext.contextsCache.get("**DEFAULT");
            DynamicJaxbContext.contextsCache.put(deploymentId, defaultJaxbContext);
            return;
        }
        List<Class<?>> allClassList = Arrays.asList(ServerJaxbSerializationProvider.getAllBaseJaxbClasses());
        HashSet allClasses = new HashSet(allClassList);
        allClasses.addAll(depClasses);
        Class[] allClassesArr = allClasses.toArray(new Class[allClasses.size()]);
        JAXBContext jaxbContext = null;
        try {
            jaxbContext = smartJaxbContextInitialization ? this.smartJaxbContextInitialization(allClassesArr, deploymentId, projectClassLoader) : JAXBContext.newInstance((Class[])allClassesArr);
            DynamicJaxbContext.contextsCache.put(deploymentId, jaxbContext);
        }
        catch (JAXBException jaxbe) {
            String errMsg = "Unable to instantiate JAXBContext for deployment '" + deploymentId + "'.";
            throw new KieRemoteServicesDeploymentException(errMsg, jaxbe);
        }
    }

    private JAXBContext smartJaxbContextInitialization(Class[] jaxbContextClasses, String deploymentId, ClassLoader projectClassLoader) throws JAXBException {
        ArrayList<Class> classList = new ArrayList<Class>(Arrays.asList(jaxbContextClasses));
        JAXBContext jaxbContext = null;
        boolean retryJaxbContextCreation = true;
        while (retryJaxbContextCreation) {
            try {
                jaxbContext = JAXBContext.newInstance((Class[])classList.toArray(new Class[classList.size()]));
                retryJaxbContextCreation = false;
            }
            catch (IllegalAnnotationsException iae) {
                this.removeClassFromJaxbContextClassList(classList, iae, deploymentId, projectClassLoader);
            }
        }
        return jaxbContext;
    }

    private void removeClassFromJaxbContextClassList(List<Class> classList, IllegalAnnotationsException iae, String deploymentId, ClassLoader projectClassLoader) throws IllegalAnnotationException {
        HashSet removedClasses = new HashSet();
        for (IllegalAnnotationException error : iae.getErrors()) {
            List classLocs = (List)error.getSourcePos().get(0);
            if (classLocs != null && !classLocs.isEmpty()) {
                String className = ((Location)classLocs.listIterator(classLocs.size()).previous()).toString();
                Class<?> removeClass = null;
                try {
                    removeClass = Class.forName(className, true, projectClassLoader);
                    if (!removedClasses.add(removeClass)) {
                        continue;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    throw new KieRemoteServicesInternalError("Class [" + className + "] could not be found when creating JAXB context: " + cnfe.getMessage(), cnfe);
                }
                if (classList.remove(removeClass)) {
                    logger.warn("Removing class '{}' from serialization context for deployment '{}'", (Object)className, (Object)deploymentId);
                    continue;
                }
            }
            throw error;
        }
    }

    public JAXBContext getJaxbContext() {
        if (onWebsphere) {
            return this._jaxbContextInstance.getRequestContext();
        }
        return this._jaxbContextInstance;
    }

    static {
        boolean classFound = false;
        try {
            Class.forName(WEBSPHERE_JAXB_CACHING_CLASS_NAME);
            classFound = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        onWebsphere = classFound;
        instanceCreated = new AtomicInteger(0);
        deploymentClassesMap = new ConcurrentHashMap();
        boolean smartJaxbContextInitProperty = Boolean.parseBoolean(System.getProperty(SMART_JAXB_CONTEXT_INIT_PROPERTY_NAME, "true"));
        if (smartJaxbContextInitProperty) {
            try {
                smartJaxbContextInitProperty = false;
                smartJaxbContextInitProperty = EXPECTED_JAXB_CONTEXT_IMPL_CLASS.equals(JAXBContext.newInstance((Class[])new Class[0]).getClass().getName());
            }
            catch (JAXBException jaxbe) {
                logger.error("Unable to initialize empty JAXB Context: something is VERY wrong!", (Throwable)jaxbe);
            }
        }
        smartJaxbContextInitialization = smartJaxbContextInitProperty;
    }
}

