/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import org.jbpm.kie.services.impl.model.ProcessAssetDesc;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.User;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.InternalOrganizationalEntity;
import org.kie.internal.task.api.model.InternalTask;
import org.kie.remote.common.rest.RestEasy960Util;
import org.kie.remote.services.cdi.ProcessRequestBean;
import org.kie.remote.services.exception.KieRemoteServicesInternalError;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.rest.query.RemoteServicesQueryJPAService;
import org.kie.services.client.serialization.jaxb.impl.JaxbPaginatedList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbArray;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbBoolean;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbByte;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbCharacter;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbDouble;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbFloat;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbInteger;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbList;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbLong;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbMap;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbSet;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbShort;
import org.kie.services.client.serialization.jaxb.impl.type.JaxbString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBase {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceBase.class);
    @Inject
    protected ProcessRequestBean processRequestBean;
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpServletRequest httpRequest;
    @Inject
    protected Instance<UserGroupCallback> userGroupCallbackInstance;
    private UserGroupCallback userGroupCallback;
    static String PAGE_LONG_PARAM = "page";
    static String PAGE_SHORT_PARAM = "p";
    static String SIZE_LONG_PARAM = "pagesize";
    static String SIZE_SHORT_PARAM = "s";
    public static Set<String> paginationParams = new HashSet<String>();
    protected static Map<Class, Class> wrapperPrimitives;
    public static final String PROC_INST_ID_PARAM_NAME = "runtimeProcInstId";
    private static final String[] EMPTY_STRING_ARR;
    private static final int MAX_LENGTH_INT = 9;
    private static final int MAX_LENGTH_LONG = 18;
    private static final int MAX_LENGTH_FLOAT = 10;
    public static String BOOLEAN_REGEX;
    public static String LONG_INTEGER_REGEX;
    public static String FLOAT_REGEX;
    public static final String CORR_KEY_SHORT_QUERY_PARAM_PREFIX = "corrProp";
    public static final String MAP_QUERY_PARAM_PREFIX = "map_";
    static int PAGE_NUM;
    static int PAGE_SIZE;

    public void setProcessRequestBean(ProcessRequestBean processRequestBean) {
        this.processRequestBean = processRequestBean;
    }

    void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public void setHttpServletRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setUserGroupCallback(UserGroupCallback userGroupCallback) {
        this.userGroupCallback = userGroupCallback;
    }

    public AuditLogService getAuditLogService() {
        return this.processRequestBean.getAuditLogService();
    }

    public RemoteServicesQueryJPAService getJPAService() {
        return this.processRequestBean.getJPAService();
    }

    public UserGroupCallback getUserGroupCallback() {
        if (this.userGroupCallback == null) {
            this.userGroupCallback = this.safeGet(this.userGroupCallbackInstance);
        }
        return this.userGroupCallback;
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers) {
        return ResourceBase.createCorrectVariant(responseObj, headers, null);
    }

    protected static Response createCorrectVariant(Object responseObj, HttpHeaders headers, Response.Status status) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v == null) {
            v = RestEasy960Util.defaultVariant;
        }
        responseBuilder = status != null ? Response.status((Response.Status)status).entity(responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        return responseBuilder.build();
    }

    protected Map<String, String[]> getRequestParams() {
        HashMap<String, Object> params = this.httpRequest.getParameterMap();
        params = params == null ? new HashMap<String, String[]>(0) : new HashMap(params);
        return params;
    }

    protected static String getStringParam(String paramName, boolean required, Map<String, String[]> params, String operation) {
        String[] paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        if (!required && paramValues.length == 0) {
            return null;
        }
        if (paramValues.length != 1) {
            throw KieRemoteRestOperationException.badRequest("One and only one '" + paramName + "' query parameter required for '" + operation + "' operation (" + paramValues.length + " passed).");
        }
        return paramValues[0];
    }

    protected static List<String> getStringListParamAsList(String paramName, boolean required, Map<String, String[]> params, String operation) {
        String[] strList = ResourceBase.getStringListParam(paramName, required, params, operation);
        if (strList.length == 0) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(strList);
    }

    protected static String[] getStringListParam(String paramName, boolean required, Map<String, String[]> params, String operation) {
        String[] paramValues = null;
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(paramName)) continue;
            paramValues = entry.getValue();
            break;
        }
        if (paramValues == null) {
            if (required) {
                throw KieRemoteRestOperationException.badRequest("Query parameter '" + paramName + "' required for '" + operation + "' operation.");
            }
            return EMPTY_STRING_ARR;
        }
        return paramValues;
    }

    protected static Object getObjectParam(String paramName, boolean required, Map<String, String[]> params, String operation) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getObjectFromString(paramName, paramVal);
    }

    protected static List<Long> getLongListParam(String paramName, boolean required, Map<String, String[]> params, String operation, boolean mustBeLong) {
        String[] paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (String strVal : paramValues) {
            longValues.add((Long)ResourceBase.getNumberFromString(paramName, strVal, mustBeLong));
        }
        return longValues;
    }

    protected static Number getNumberParam(String paramName, boolean required, Map<String, String[]> params, String operation, boolean mustBeLong) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getNumberFromString(paramName, paramVal, mustBeLong);
    }

    private static Object getObjectFromString(String key, String mapVal) {
        if (mapVal.matches("^\".*\"$")) {
            return mapVal.substring(1, mapVal.length() - 1);
        }
        if (mapVal.matches(LONG_INTEGER_REGEX) || mapVal.matches(FLOAT_REGEX)) {
            return ResourceBase.getNumberFromString(key, mapVal, false);
        }
        if (mapVal.matches(BOOLEAN_REGEX)) {
            return Boolean.parseBoolean(mapVal);
        }
        return mapVal;
    }

    private static Number getNumberFromString(String paramName, String paramVal, boolean mustBeLong) {
        if (paramVal.matches(LONG_INTEGER_REGEX)) {
            if (paramVal.matches(".*i$")) {
                if (mustBeLong) {
                    throw KieRemoteRestOperationException.badRequest(paramName + " parameter is numerical but contains the \"Integer\" suffix 'i' and must have no suffix or \"Long\" suffix 'l' (" + paramVal + ")");
                }
                if ((paramVal = paramVal.substring(0, paramVal.length() - 1)).length() > 9) {
                    throw KieRemoteRestOperationException.badRequest(paramName + " parameter is numerical but too large to be an integer (" + paramVal + "i)");
                }
                return Integer.parseInt(paramVal);
            }
            if (paramVal.length() > 18) {
                throw KieRemoteRestOperationException.badRequest(paramName + " parameter is numerical but too large to be a long (" + paramVal + ")");
            }
            if (paramVal.matches(".*l$")) {
                paramVal = paramVal.substring(0, paramVal.length() - 1);
            }
            return Long.parseLong(paramVal);
        }
        if (paramVal.matches(FLOAT_REGEX)) {
            if (mustBeLong) {
                throw KieRemoteRestOperationException.badRequest(paramName + " parameter is numerical but contains the \"Float\" suffix 'f' (or a '.') and must have no suffix or \"Long\" suffix 'l' (" + paramVal + ")");
            }
            int length = paramVal.replace("f", "").length();
            if (length > 10) {
                throw KieRemoteRestOperationException.badRequest(paramName + " parameter is a float but longer than " + 10 + "(" + paramVal + ")");
            }
            if (paramVal.matches(".*f$")) {
                paramVal = paramVal.substring(0, paramVal.length() - 1);
            }
            return Float.valueOf(Float.parseFloat(paramVal));
        }
        throw KieRemoteRestOperationException.badRequest(paramName + " parameter does not have a numerical format (" + paramVal + ")");
    }

    protected static List<String> getCorrelationKeyProperties(Map<String, String[]> params) {
        ArrayList<String> correlationKeyProperties = null;
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String key = entry.getKey();
            String[] paramValues = entry.getValue();
            if (!key.equals(CORR_KEY_SHORT_QUERY_PARAM_PREFIX)) continue;
            if (correlationKeyProperties == null) {
                correlationKeyProperties = new ArrayList<String>(Arrays.asList(paramValues));
                continue;
            }
            correlationKeyProperties.addAll(Arrays.asList(paramValues));
        }
        return correlationKeyProperties;
    }

    protected static Map<String, Object> extractMapFromParams(Map<String, String[]> params, String operation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            if (!entry.getKey().startsWith(MAP_QUERY_PARAM_PREFIX)) continue;
            String key = entry.getKey();
            String[] paramValues = entry.getValue();
            if (paramValues.length != 1) {
                throw KieRemoteRestOperationException.badRequest("Only one map_* (" + key + ") query parameter allowed for '" + operation + "' operation (" + paramValues.length + " passed).");
            }
            String mapKey = key.substring(MAP_QUERY_PARAM_PREFIX.length());
            String mapVal = paramValues[0].trim();
            map.put(mapKey, ResourceBase.getObjectFromString(key, mapVal));
        }
        return map;
    }

    protected static List<OrganizationalEntity> getOrganizationalEntityListFromParams(Map<String, String[]> params, boolean required, String operation) {
        User newuser;
        ArrayList<OrganizationalEntity> orgEntList = new ArrayList<OrganizationalEntity>();
        String[] users = ResourceBase.getStringListParam("user", false, params, operation);
        String[] groups = ResourceBase.getStringListParam("group", false, params, operation);
        if (required && users.length == 0 && groups.length == 0) {
            throw KieRemoteRestOperationException.badRequest("At least 1 query parameter (either 'user' or 'group') is required for the '" + operation + "' operation.");
        }
        for (String user : users) {
            newuser = TaskModelProvider.getFactory().newUser();
            ((InternalOrganizationalEntity)newuser).setId(user);
            orgEntList.add((OrganizationalEntity)newuser);
        }
        for (String group : groups) {
            newuser = TaskModelProvider.getFactory().newGroup();
            ((InternalOrganizationalEntity)newuser).setId(group);
            orgEntList.add((OrganizationalEntity)newuser);
        }
        return orgEntList;
    }

    protected static TaskSummaryImpl convertTaskToTaskSummary(InternalTask task) {
        TaskSummaryImpl taskSummary = new TaskSummaryImpl(task.getId().longValue(), ((I18NText)task.getNames().get(0)).getText(), ((I18NText)task.getSubjects().get(0)).getText(), ((I18NText)task.getDescriptions().get(0)).getText(), task.getTaskData().getStatus(), task.getPriority(), task.getTaskData().isSkipable(), task.getTaskData().getActualOwner(), task.getTaskData().getCreatedBy(), task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getTaskData().getProcessInstanceId(), task.getTaskData().getDeploymentId(), task.getSubTaskStrategy(), task.getTaskData().getParentId());
        return taskSummary;
    }

    protected static List<Status> convertStringListToStatusList(List<String> statusStrList) {
        ArrayList<Status> statuses = null;
        if (statusStrList != null && !statusStrList.isEmpty()) {
            statuses = new ArrayList<Status>();
            for (String statusStr : statusStrList) {
                try {
                    statuses.add(ResourceBase.getEnum(statusStr));
                }
                catch (IllegalArgumentException iae) {
                    throw KieRemoteRestOperationException.badRequest(statusStr + " is not a valid status type for a task.");
                }
            }
        }
        return statuses;
    }

    protected static int[] getPageNumAndPageSize(Map<String, String[]> params, String oper) {
        int[] pageInfo = new int[2];
        int p = 0;
        Number page = ResourceBase.getNumberParam(PAGE_LONG_PARAM, false, params, oper, false);
        if (page != null) {
            p = page.intValue();
        } else {
            Number pageShort = ResourceBase.getNumberParam(PAGE_SHORT_PARAM, false, params, oper, false);
            if (pageShort != null) {
                p = pageShort.intValue();
            }
        }
        if (p < 0) {
            p = 0;
        }
        int s = 0;
        Number pageSize = ResourceBase.getNumberParam(SIZE_LONG_PARAM, false, params, oper, false);
        if (pageSize != null) {
            s = pageSize.intValue();
        } else {
            Number pageSizeShort = ResourceBase.getNumberParam(SIZE_SHORT_PARAM, false, params, oper, false);
            if (pageSizeShort != null) {
                s = pageSizeShort.intValue();
            }
        }
        if (s < 0) {
            s = 0;
        }
        if (s == 0) {
            p = 0;
        }
        pageInfo[ResourceBase.PAGE_NUM] = p;
        pageInfo[ResourceBase.PAGE_SIZE] = s;
        return pageInfo;
    }

    protected static <T> List<T> paginate(int[] pageInfo, List<T> results) {
        ArrayList<T> pagedResults = new ArrayList<T>();
        assert (pageInfo[0] >= 0);
        if (pageInfo[0] == 0 && pageInfo[1] > 0) {
            pageInfo[0] = 1;
        }
        if (pageInfo[0] == 0 && pageInfo[1] == 0) {
            return results;
        }
        if (pageInfo[0] > 0) {
            for (int i = (pageInfo[0] - 1) * pageInfo[1]; i < pageInfo[0] * pageInfo[1] && i < results.size(); ++i) {
                pagedResults.add(results.get(i));
            }
        }
        return pagedResults;
    }

    public static int getMaxNumResultsNeeded(int[] pageInfo) {
        int numResults = pageInfo[PAGE_NUM] * pageInfo[PAGE_SIZE];
        if (numResults == 0) {
            numResults = 1000;
        }
        return numResults;
    }

    protected static <T, R extends JaxbPaginatedList<T>> R paginateAndCreateResult(Map<String, String[]> params, String oper, List<T> results, R resultList) {
        int[] pageInfo = ResourceBase.getPageNumAndPageSize(params, oper);
        return ResourceBase.paginateAndCreateResult(pageInfo, results, resultList);
    }

    protected static <T, R extends JaxbPaginatedList<T>> R paginateAndCreateResult(int[] pageInfo, List<T> results, R resultList) {
        if (pageInfo[0] == 0 && pageInfo[1] == 0) {
            resultList.addContents(results);
            return resultList;
        }
        results = ResourceBase.paginate(pageInfo, results);
        resultList.addContents(results);
        resultList.setPageNumber(Integer.valueOf(pageInfo[PAGE_NUM]));
        resultList.setPageSize(Integer.valueOf(pageInfo[PAGE_SIZE]));
        return resultList;
    }

    protected String getBaseUri() {
        return this.uriInfo.getBaseUri().toString();
    }

    protected String getRequestUri() {
        return this.httpRequest.getRequestURI();
    }

    protected String getRelativePath() {
        String url = this.httpRequest.getRequestURI();
        url = url.replaceAll(".*/rest", "");
        return url;
    }

    protected static Status getEnum(String value) {
        value = value.substring(0, 1).toUpperCase() + value.substring(1).toLowerCase();
        try {
            return Status.valueOf((String)value);
        }
        catch (IllegalArgumentException iae) {
            if (value.equalsIgnoreCase("inprogress")) {
                return Status.InProgress;
            }
            throw new KieRemoteServicesInternalError("Unable to determine Status for value '" + value + "'", iae);
        }
    }

    protected JaxbProcessDefinition convertProcAssetDescToJaxbProcDef(ProcessDefinition procAssetDesc) {
        JaxbProcessDefinition jaxbProcDef = new JaxbProcessDefinition();
        jaxbProcDef.setDeploymentId(((ProcessAssetDesc)procAssetDesc).getDeploymentId());
        jaxbProcDef.setForms(((ProcessAssetDesc)procAssetDesc).getForms());
        jaxbProcDef.setId(procAssetDesc.getId());
        jaxbProcDef.setName(procAssetDesc.getName());
        jaxbProcDef.setPackageName(procAssetDesc.getPackageName());
        jaxbProcDef.setVersion(procAssetDesc.getVersion());
        return jaxbProcDef;
    }

    public <T> T doRestTaskOperation(TaskCommand<T> cmd) {
        return this.processRequestBean.doRestTaskOperation(null, null, null, null, cmd);
    }

    protected <T> T doRestTaskOperationWithTaskId(Long taskId, TaskCommand<T> cmd) {
        return this.processRequestBean.doRestTaskOperation(taskId, null, null, null, cmd);
    }

    protected <T> T doRestTaskOperationWithDeploymentId(String deploymentId, TaskCommand<T> cmd) {
        return this.processRequestBean.doRestTaskOperation(null, deploymentId, null, null, cmd);
    }

    public static boolean isPrimitiveOrWrapper(Class<?> type) {
        if (type == null) {
            return false;
        }
        return type.isPrimitive() || wrapperPrimitives.containsKey(type) || Map.class.isAssignableFrom(type) || List.class.isAssignableFrom(type) || Set.class.isAssignableFrom(type) || type.isArray();
    }

    static Object wrapObjectIfNeeded(Object processVariableObject) {
        if (processVariableObject != null && ResourceBase.isPrimitiveOrWrapper(processVariableObject.getClass())) {
            return ResourceBase.wrapPrimitive(processVariableObject);
        }
        return processVariableObject;
    }

    private static Object wrapPrimitive(Object value) {
        Class<Object> wrapperTypeClass = value.getClass();
        if (value instanceof Set) {
            wrapperTypeClass = Set.class;
        } else if (value instanceof List) {
            wrapperTypeClass = List.class;
        } else if (value instanceof Map) {
            wrapperTypeClass = Map.class;
        }
        Class<JaxbArray> wrapperClass = wrapperPrimitives.get(wrapperTypeClass);
        if (wrapperTypeClass.isArray()) {
            wrapperClass = JaxbArray.class;
        }
        try {
            Constructor<?>[] cntrs = wrapperClass.getConstructors();
            Constructor<?> argCntr = null;
            for (Constructor<?> cntr : cntrs) {
                if (cntr.getParameterTypes().length != 1) continue;
                argCntr = cntr;
                break;
            }
            if (argCntr == null) {
                throw new RuntimeException("Could not find 1 argument constructor for " + wrapperClass.getSimpleName());
            }
            return argCntr.newInstance(value);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create " + wrapperClass.getSimpleName() + " for type " + value.getClass() + " with value " + value, e);
        }
    }

    protected <T> T safeGet(Instance<T> instance) {
        try {
            Object object = instance.get();
            logger.debug("About to set object {} on task service", object);
            return (T)object;
        }
        catch (AmbiguousResolutionException e) {
            HashSet available = new HashSet();
            for (Object object : instance) {
                available.add(object);
            }
            if (available.size() == 1) {
                return (T)available.iterator().next();
            }
            throw e;
        }
        catch (Throwable e) {
            logger.debug("Cannot get value of of instance {} due to {}", instance, (Object)e.getMessage());
            return null;
        }
    }

    static {
        paginationParams.add(PAGE_LONG_PARAM);
        paginationParams.add(PAGE_SHORT_PARAM);
        paginationParams.add(SIZE_LONG_PARAM);
        paginationParams.add(SIZE_SHORT_PARAM);
        wrapperPrimitives = new HashMap<Class, Class>();
        wrapperPrimitives.put(Boolean.class, JaxbBoolean.class);
        wrapperPrimitives.put(Byte.class, JaxbByte.class);
        wrapperPrimitives.put(Character.class, JaxbCharacter.class);
        wrapperPrimitives.put(Short.class, JaxbShort.class);
        wrapperPrimitives.put(Integer.class, JaxbInteger.class);
        wrapperPrimitives.put(Long.class, JaxbLong.class);
        wrapperPrimitives.put(Double.class, JaxbDouble.class);
        wrapperPrimitives.put(Float.class, JaxbFloat.class);
        if (Boolean.getBoolean("org.kie.remote.wrap.string")) {
            wrapperPrimitives.put(String.class, JaxbString.class);
        }
        wrapperPrimitives.put(List.class, JaxbList.class);
        wrapperPrimitives.put(Set.class, JaxbSet.class);
        wrapperPrimitives.put(Map.class, JaxbMap.class);
        EMPTY_STRING_ARR = new String[0];
        BOOLEAN_REGEX = "^(true|false)";
        LONG_INTEGER_REGEX = "^\\d+[li]?$";
        FLOAT_REGEX = "^\\d[\\d\\.]{1,9}(E-?\\d{1,2})?f?$";
        PAGE_NUM = 0;
        PAGE_SIZE = 1;
    }
}

