/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.jaxb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.drools.core.xml.jaxb.util.JaxbListWrapper;
import org.kie.remote.services.jaxb.JaxbCommandsRequest;
import org.kie.remote.services.jaxb.JaxbCommandsResponse;
import org.kie.remote.services.jaxb.JaxbContentResponse;
import org.kie.remote.services.jaxb.JaxbTaskCommentListResponse;
import org.kie.remote.services.jaxb.JaxbTaskCommentResponse;
import org.kie.remote.services.jaxb.JaxbTaskResponse;
import org.kie.remote.services.jaxb.JaxbTaskSummaryListResponse;
import org.kie.remote.services.ws.command.generated.Execute;
import org.kie.remote.services.ws.command.generated.ExecuteResponse;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.SerializationException;

public class ServerJaxbSerializationProvider
extends JaxbSerializationProvider {
    private static Set<Class<?>> SERVER_SIDE_JAXB_CLASS_SET;
    private static Class<?>[] ALL_BASE_JAXB_CLASSES;
    private JAXBContext jaxbContext = null;
    protected Set<Class<?>> extraJaxbClasses = new HashSet();

    public static Set<Class<?>> getModuleClasses() {
        return SERVER_SIDE_JAXB_CLASS_SET;
    }

    private Class<?>[] getAllJaxbClasses() {
        Class<?>[] allBaseJaxbClassArr = ServerJaxbSerializationProvider.getAllBaseJaxbClasses();
        if (this.extraJaxbClasses.isEmpty()) {
            return allBaseJaxbClassArr;
        }
        Class[] extraJaxbClassArr = this.extraJaxbClasses.toArray(new Class[this.extraJaxbClasses.size()]);
        return ServerJaxbSerializationProvider.addClassArrToClassArr(allBaseJaxbClassArr, extraJaxbClassArr);
    }

    public static Class<?>[] getAllBaseJaxbClasses() {
        Set<Class<?>> sideJaxbClassSet = ServerJaxbSerializationProvider.getModuleClasses();
        Class[] sideJaxbClasses = new Class[sideJaxbClassSet.size()];
        sideJaxbClasses = sideJaxbClassSet.toArray(sideJaxbClasses);
        return ServerJaxbSerializationProvider.addClassArrToClassArr(ALL_BASE_JAXB_CLASSES, sideJaxbClasses);
    }

    private static Class<?>[] addClassArrToClassArr(Class<?>[] baseArr, Class<?>[] addArr) {
        Class[] copy = new Class[baseArr.length + addArr.length];
        System.arraycopy(baseArr, 0, copy, 0, baseArr.length);
        System.arraycopy(addArr, 0, copy, baseArr.length, addArr.length);
        return copy;
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    public static JaxbSerializationProvider newInstance() {
        ServerJaxbSerializationProvider jaxbSerProvider = new ServerJaxbSerializationProvider();
        jaxbSerProvider.initialize();
        return jaxbSerProvider;
    }

    public static JaxbSerializationProvider newInstance(Class<?> ... extraJaxbClasses) {
        ServerJaxbSerializationProvider jaxbSerProvider = new ServerJaxbSerializationProvider(extraJaxbClasses);
        jaxbSerProvider.initialize();
        return jaxbSerProvider;
    }

    public static JaxbSerializationProvider newInstance(JAXBContext jaxbContext) {
        ServerJaxbSerializationProvider jaxbSerProvider = new ServerJaxbSerializationProvider(jaxbContext);
        return jaxbSerProvider;
    }

    private void initialize() {
        this.initialize(this.getAllJaxbClasses());
    }

    private void initialize(Class<?>[] jaxbClasses) {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])jaxbClasses);
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unsupported JAXB Class encountered during initialization: " + jaxbe.getMessage(), (Throwable)jaxbe);
        }
    }

    public void dispose() {
        if (this.extraJaxbClasses != null) {
            this.extraJaxbClasses.clear();
            this.extraJaxbClasses = null;
        }
        if (this.jaxbContext != null) {
            this.jaxbContext = null;
        }
    }

    public void addJaxbClasses(Class ... jaxbClass) {
        for (int i = 0; i < jaxbClass.length; ++i) {
            this.extraJaxbClasses.add(jaxbClass[i]);
        }
    }

    public void addJaxbClassesAndReinitialize(Class ... jaxbClass) {
        this.addJaxbClasses(jaxbClass);
        this.initialize(this.getAllJaxbClasses());
    }

    public Collection<Class<?>> getExtraJaxbClasses() {
        return new HashSet(this.extraJaxbClasses);
    }

    private ServerJaxbSerializationProvider() {
    }

    public ServerJaxbSerializationProvider(Class<?>[] extraJaxbClassArr) {
        this.extraJaxbClasses.addAll(Arrays.asList(extraJaxbClassArr));
    }

    public ServerJaxbSerializationProvider(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    static {
        Class[] serviceSideClasses = new Class[]{JaxbCommandsRequest.class, JaxbCommandsResponse.class, JaxbContentResponse.class, JaxbTaskCommentResponse.class, JaxbTaskResponse.class, JaxbTaskSummaryListResponse.class, JaxbTaskCommentListResponse.class, Execute.class, ExecuteResponse.class, JaxbListWrapper.class};
        ArrayList<Class> serverSideJaxbClassList = new ArrayList<Class>();
        for (Class clazz : serviceSideClasses) {
            serverSideJaxbClassList.add(clazz);
        }
        SERVER_SIDE_JAXB_CLASS_SET = Collections.unmodifiableSet(new HashSet(serverSideJaxbClassList));
        ALL_BASE_JAXB_CLASSES = null;
        int kieJaxbClassSetLength = KIE_JAXB_CLASS_SET.size();
        Class[] types = new Class[kieJaxbClassSetLength + PRIMITIVE_ARRAY_CLASS_SET.size()];
        System.arraycopy(KIE_JAXB_CLASS_SET.toArray(new Class[kieJaxbClassSetLength]), 0, types, 0, kieJaxbClassSetLength);
        int primArrClassSetLength = PRIMITIVE_ARRAY_CLASS_SET.size();
        System.arraycopy(PRIMITIVE_ARRAY_CLASS_SET.toArray(new Class[primArrClassSetLength]), 0, types, kieJaxbClassSetLength, primArrClassSetLength);
        ALL_BASE_JAXB_CLASSES = types;
    }
}

