/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.async;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutionResults;
import org.kie.api.executor.ExecutorService;
import org.kie.api.executor.RequestInfo;
import org.kie.api.runtime.query.QueryContext;
import org.kie.remote.services.exception.KieRemoteServicesInternalError;
import org.kie.remote.services.rest.async.cmd.JobType;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JobResultManager {
    private static final Logger logger = LoggerFactory.getLogger(JobResultManager.class);
    private static AtomicInteger created = new AtomicInteger(0);
    private Map<String, JaxbDeploymentJobResult> jobs = null;
    private int maxCacheSize = 10000;
    @Inject
    private Instance<ExecutorService> jobExecutor;

    @PostConstruct
    public void start() {
        if (!created.compareAndSet(0, 1)) {
            throw new KieRemoteServicesInternalError("Only 1 JobResultManager instance is allowed per container!");
        }
        Cache cache = new Cache(this.maxCacheSize);
        this.jobs = Collections.synchronizedMap(cache);
    }

    public void putJob(String jobId, JaxbDeploymentJobResult job, JobType jobType) {
        logger.debug("Adding job [{}] to cache");
        this.jobs.put(jobId, job);
    }

    public JaxbDeploymentJobResult getJob(String jobId) {
        List jobsFound;
        logger.debug("Getting job [{}]");
        JaxbDeploymentJobResult job = this.jobs.get(jobId);
        if (job != null && !JaxbDeploymentUnit.JaxbDeploymentStatus.ACCEPTED.equals((Object)job.getDeploymentUnit().getStatus())) {
            return job;
        }
        if (!this.jobExecutor.isUnsatisfied() && (jobsFound = ((ExecutorService)this.jobExecutor.get()).getRequestsByBusinessKey(jobId, new QueryContext())) != null && !jobsFound.isEmpty()) {
            RequestInfo executorJob = (RequestInfo)jobsFound.get(0);
            JaxbDeploymentJobResult jobFromRequest = (JaxbDeploymentJobResult)this.getItemFromRequestOutput("JobResult", executorJob);
            if (jobFromRequest == null) {
                jobFromRequest = (JaxbDeploymentJobResult)this.getItemFromRequestInput("jobResult", executorJob);
            }
            if (jobFromRequest != null) {
                job = jobFromRequest;
                this.jobs.put(jobId, job);
            }
        }
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getItemFromRequestInput(String itemName, RequestInfo requestInfo) {
        CommandContext ctx = null;
        byte[] requestData = requestInfo.getRequestData();
        if (requestData != null) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new ByteArrayInputStream(requestData));
                ctx = (CommandContext)in.readObject();
            }
            catch (Exception e) {
                logger.debug("Exception while deserializing context data of job with id {}", (Object)requestInfo.getId(), (Object)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (ctx != null && ctx.getData(itemName) != null) {
            return ctx.getData(itemName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getItemFromRequestOutput(String itemName, RequestInfo requestInfo) {
        ExecutionResults execResults = null;
        byte[] responseData = requestInfo.getResponseData();
        if (responseData != null) {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new ByteArrayInputStream(responseData));
                execResults = (ExecutionResults)in.readObject();
            }
            catch (Exception e) {
                logger.debug("Exception while deserializing context data of job with id {}", (Object)requestInfo.getId(), (Object)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (execResults != null && execResults.getData(itemName) != null) {
            return execResults.getData(itemName);
        }
        return null;
    }

    private static class Cache<T>
    extends LinkedHashMap<String, T> {
        private static final long serialVersionUID = -5369827812060944667L;
        private int maxSize = 1000;

        public Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, T> stringFutureEntry) {
            return this.size() > this.maxSize;
        }
    }
}

