/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.exception;

import javax.enterprise.context.RequestScoped;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBException;
import org.kie.remote.common.rest.RestEasy960Util;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.services.client.serialization.jaxb.impl.JaxbRequestStatus;
import org.kie.services.client.serialization.jaxb.impl.JaxbRestRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@RequestScoped
public class DescriptiveExceptionHandler
implements ExceptionMapper<KieRemoteRestOperationException> {
    protected static Logger logger = LoggerFactory.getLogger(DescriptiveExceptionHandler.class);
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpHeaders headers;

    public Response toResponse(KieRemoteRestOperationException e) {
        JaxbRequestStatus requestStatus;
        Response.ResponseBuilder responseBuilder = null;
        int status = -1;
        status = e.getStatus();
        logger.warn("Exception thrown when processing request [" + DescriptiveExceptionHandler.getRelativePath(this.uriInfo) + "]; responding with status " + status, (Throwable)e);
        responseBuilder = status > 0 ? Response.status((int)status) : Response.serverError();
        boolean addException = true;
        switch (status) {
            case 400: {
                requestStatus = JaxbRequestStatus.BAD_REQUEST;
                addException = false;
                break;
            }
            case 403: {
                requestStatus = JaxbRequestStatus.FORBIDDEN;
                break;
            }
            case 404: {
                requestStatus = JaxbRequestStatus.NOT_FOUND;
                addException = false;
                break;
            }
            case 409: {
                requestStatus = JaxbRequestStatus.PERMISSIONS_CONFLICT;
                break;
            }
            default: {
                requestStatus = JaxbRequestStatus.FAILURE;
            }
        }
        KieRemoteRestOperationException responseException = addException ? e : null;
        JaxbRestRequestException response = new JaxbRestRequestException(this.uriInfo.getRequestUri().toString(), (Exception)responseException, requestStatus);
        try {
            responseBuilder.entity((Object)response.prettyPrint());
        }
        catch (JAXBException jaxbe) {
            responseBuilder.entity((Object)JaxbRestRequestException.convertStackTraceToString((Throwable)jaxbe));
        }
        Variant variant = RestEasy960Util.getVariant((HttpHeaders)this.headers);
        return responseBuilder.variant(variant).build();
    }

    public static String getRelativePath(UriInfo uriInfo) {
        return uriInfo.getRequestUri().toString().replaceAll(".*/rest", "");
    }
}

