/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.jaxb;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import org.jbpm.kie.services.api.DeploymentIdResolver;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.remote.services.exception.KieRemoteServicesInternalError;
import org.kie.remote.services.jaxb.ServerJaxbSerializationProvider;
import org.kie.remote.services.rest.jaxb.DynamicJaxbContextManager;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicJaxbContext
extends JAXBContext {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJaxbContext.class);
    static ConcurrentHashMap<String, JAXBContext> contextsCache = new ConcurrentHashMap();
    private static ThreadLocal<JAXBContext> requestJaxbContext;
    private static final AtomicInteger idGen;
    private final int id = idGen.incrementAndGet();

    private static void setupDefaultJaxbContext() {
        try {
            Class[] types = ServerJaxbSerializationProvider.getAllBaseJaxbClasses();
            JAXBContext defaultJaxbContext = JAXBContext.newInstance((Class[])types);
            contextsCache.put("**DEFAULT", defaultJaxbContext);
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Unable to create new " + JAXBContext.class.getSimpleName() + " instance.", e);
        }
    }

    public static void setDeploymentJaxbContext(String deploymentId) {
        JAXBContext projectJaxbContext;
        if (!DeploymentInfoBean.emptyDeploymentId(deploymentId) && !deploymentId.equals("**DEFAULT")) {
            deploymentId = DeploymentIdResolver.matchAndReturnLatest((String)deploymentId, DynamicJaxbContextManager.deploymentClassesMap.keySet());
        }
        if ((projectJaxbContext = contextsCache.get(deploymentId)) == null) {
            logger.debug("No JAXBContext available for deployment '" + deploymentId + "', using default JAXBContext instance.");
            projectJaxbContext = contextsCache.get("**DEFAULT");
        }
        requestJaxbContext.set(projectJaxbContext);
    }

    public static void clearDeploymentJaxbContext() {
        requestJaxbContext.set(null);
    }

    JAXBContext getRequestContext() {
        return requestJaxbContext.get();
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = requestJaxbContext.get();
        if (context != null) {
            return context.createUnmarshaller();
        }
        throw new KieRemoteServicesInternalError("No Unmarshaller available: JAXBContext instance could be found for this request!");
    }

    public Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = requestJaxbContext.get();
        if (context != null) {
            return JaxbSerializationProvider.configureMarshaller((JAXBContext)context, (boolean)false);
        }
        throw new KieRemoteServicesInternalError("No Marshaller available: JAXBContext instance could be found for this request!");
    }

    public Validator createValidator() throws JAXBException {
        JAXBContext context = requestJaxbContext.get();
        if (context != null) {
            return context.createValidator();
        }
        throw new KieRemoteServicesInternalError("No Validator available: JAXBContext instance could be found for this request!");
    }

    public boolean equals(Object obj) {
        if (obj instanceof DynamicJaxbContext) {
            return this.id == ((DynamicJaxbContext)((Object)obj)).id;
        }
        return false;
    }

    static {
        DynamicJaxbContext.setupDefaultJaxbContext();
        requestJaxbContext = new ThreadLocal();
        idGen = new AtomicInteger(0);
    }
}

