/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.jaxb;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.kie.remote.services.cdi.DeploymentInfoBean;
import org.kie.remote.services.rest.jaxb.DynamicJaxbContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicJaxbContextFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJaxbContextFilter.class);
    public static final String DEFAULT_JAXB_CONTEXT_ID = "**DEFAULT";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String deploymentId = DynamicJaxbContextFilter.getDeploymentId(httpRequest);
        DynamicJaxbContext.setDeploymentJaxbContext(deploymentId);
        logger.debug("JAXBContext retrieved and set for for '{}'", (Object)deploymentId);
        try {
            chain.doFilter(request, response);
        }
        finally {
            DynamicJaxbContext.clearDeploymentJaxbContext();
        }
    }

    public void destroy() {
    }

    static String getDeploymentId(HttpServletRequest request) {
        String deploymentId = null;
        deploymentId = request.getHeader("Kie-Deployment-Id");
        if (!DeploymentInfoBean.emptyDeploymentId(deploymentId)) {
            return deploymentId;
        }
        String requestUri = request.getRequestURI();
        String[] urlParts = requestUri.split("/");
        for (int i = 0; i < urlParts.length; ++i) {
            if (!urlParts[i].equals("deployment") && !urlParts[i].equals("runtime") || i + 1 >= urlParts.length) continue;
            deploymentId = urlParts[i + 1];
            if (DeploymentInfoBean.emptyDeploymentId(deploymentId)) break;
            return deploymentId;
        }
        if (!DeploymentInfoBean.emptyDeploymentId(deploymentId = request.getParameter("deploymentId"))) {
            return deploymentId;
        }
        return DEFAULT_JAXB_CONTEXT_ID;
    }
}

