/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jbpm.process.audit.JPAService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.query.jpa.data.QueryWhere;
import org.jbpm.query.jpa.impl.QueryCriteriaUtil;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.kie.api.task.UserGroupCallback;
import org.kie.api.task.model.TaskSummary;
import org.kie.remote.services.rest.query.RemoteServicesAuditQueryCriteriaUtil;
import org.kie.remote.services.rest.query.RemoteServicesTaskQueryCriteriaUtil;

public class RemoteServicesQueryJPAService
extends JPAService {
    private final RemoteServicesAuditQueryCriteriaUtil auditQueryUtil = new RemoteServicesAuditQueryCriteriaUtil(this);
    private final RemoteServicesTaskQueryCriteriaUtil taskQueryUtil = new RemoteServicesTaskQueryCriteriaUtil(this);

    public RemoteServicesQueryJPAService(EntityManagerFactory emf) {
        super(emf);
    }

    protected EntityManager getEntityManager() {
        return this.persistenceStrategy.getEntityManager();
    }

    protected Object joinTransaction(EntityManager em) {
        return this.persistenceStrategy.joinTransaction(em);
    }

    protected void closeEntityManager(EntityManager em, Object transaction) {
        this.persistenceStrategy.leaveTransaction(em, transaction);
    }

    protected QueryCriteriaUtil getQueryCriteriaUtil(Class queryType) {
        if (queryType.equals(TaskSummaryImpl.class)) {
            return this.taskQueryUtil;
        }
        if (queryType.equals(ProcessInstanceLog.class) || queryType.equals(VariableInstanceLog.class) || queryType.equals(NodeInstanceLog.class)) {
            return this.auditQueryUtil;
        }
        throw new IllegalArgumentException("Unsupported query type: " + queryType.getName());
    }

    public <T> List<T> doQuery(QueryWhere queryWhere, Class<T> queryType) {
        return this.auditQueryUtil.doCriteriaQuery(queryWhere, queryType);
    }

    public List<TaskSummary> doTaskSummaryQuery(String userId, UserGroupCallback userGroupCallback, QueryWhere queryWhere) {
        assert (userGroupCallback != null) : "The " + UserGroupCallback.class.getSimpleName() + " instance is null!";
        return this.taskQueryUtil.doCriteriaQuery(userId, userGroupCallback, queryWhere);
    }
}

