/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.util;

import java.util.Map;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.impl.TaskContentRegistry;
import org.jbpm.services.task.impl.model.xml.JaxbContent;
import org.jbpm.services.task.impl.model.xml.JaxbTask;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.runtime.Environment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.internal.command.Context;
import org.kie.internal.task.api.ContentMarshallerContext;

public class ExecuteAndSerializeCommand<T>
extends TaskCommand<T> {
    private TaskCommand<T> command;
    private String deploymentId;

    public ExecuteAndSerializeCommand() {
    }

    public ExecuteAndSerializeCommand(TaskCommand<T> command, String deploymentId) {
        this.command = command;
        this.deploymentId = deploymentId;
    }

    public T execute(Context context) {
        Object cmdResult = this.command.execute(context);
        if (cmdResult == null) {
            return null;
        }
        if (cmdResult instanceof Task) {
            cmdResult = new JaxbTask((Task)cmdResult);
        } else if (cmdResult instanceof Content) {
            Content content = (Content)cmdResult;
            JaxbContent jaxbContent = new JaxbContent();
            jaxbContent.setId(content.getId());
            jaxbContent.setSerializedContent(content.getContent());
            ContentMarshallerContext contentMarshallerContext = TaskContentRegistry.get().getMarshallerContext(this.deploymentId);
            Object unmarshalledContent = null;
            unmarshalledContent = contentMarshallerContext != null ? ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)contentMarshallerContext.getEnvironment(), (ClassLoader)contentMarshallerContext.getClassloader()) : ContentMarshallerHelper.unmarshall((byte[])content.getContent(), null);
            if (unmarshalledContent != null && unmarshalledContent instanceof Map) {
                jaxbContent.setContentMap((Map)unmarshalledContent);
            }
            cmdResult = jaxbContent;
        } else if (cmdResult instanceof Map) {
            Map output = (Map)cmdResult;
            cmdResult = new JaxbContent();
            ((JaxbContent)cmdResult).setContentMap(output);
            ((JaxbContent)cmdResult).setId(Long.valueOf(-1L));
        }
        return (T)cmdResult;
    }
}

