/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.jms.request;

import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import org.jbpm.services.cdi.RequestScopedBackupIdentityProvider;
import org.kie.remote.services.jms.RequestMessageBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class BackupIdentityProviderProducer {
    private static final Logger logger = LoggerFactory.getLogger(RequestMessageBean.class);
    private RequestScopedBackupIdentityProvider identityProvider = null;

    public RequestScopedBackupIdentityProvider createBackupIdentityProvider(String commandUser, List<String> roles) {
        logger.debug("Creating identity provider for user: {}", (Object)commandUser);
        if (commandUser == null) {
            commandUser = "unknown";
        }
        final String nameValue = commandUser;
        this.identityProvider = new RequestScopedBackupIdentityProvider(){
            private String name;
            {
                this.name = nameValue;
            }

            public String getName() {
                return this.name;
            }
        };
        return this.identityProvider;
    }

    @Produces
    @RequestScoped
    public RequestScopedBackupIdentityProvider getJmsRequestScopeIdentityProvider() {
        if (this.identityProvider != null) {
            logger.debug("Producing backup identity bean for user: {}", (Object)this.identityProvider.getName());
            return this.identityProvider;
        }
        logger.debug("Unknown user during JMS request");
        return new RequestScopedBackupIdentityProvider(){

            public String getName() {
                return "unknown";
            }
        };
    }
}

