/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessIdsCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.GetWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartCorrelatedProcessCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.util.StringUtils;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.jbpm.services.api.DefinitionService;
import org.jbpm.services.api.DeploymentNotFoundException;
import org.jbpm.services.api.ProcessInstanceNotFoundException;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.ProcessDefinition;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationKey;
import org.kie.remote.common.rest.RestEasy960Util;
import org.kie.remote.services.rest.ResourceBase;
import org.kie.remote.services.rest.exception.KieRemoteRestOperationException;
import org.kie.remote.services.util.FormURLGenerator;
import org.kie.services.client.serialization.jaxb.impl.JaxbRequestStatus;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceFormResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItemResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;

@Path(value="/runtime/{deploymentId: [\\w\\.-]+(:[\\w\\.-]+){2,2}(:[\\w\\.-]*){0,2}}")
@RequestScoped
public class RuntimeResourceImpl
extends ResourceBase {
    @Context
    protected HttpHeaders headers;
    @PathParam(value="deploymentId")
    protected String deploymentId;
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    private DefinitionService bpmn2DataService;
    @Inject
    private FormURLGenerator formURLGenerator;
    private static final boolean wrapJsonValues = Boolean.getBoolean("org.kie.remote.wrap.json");

    @GET
    @Path(value="/process/{processDefId: [a-zA-Z0-9-:\\._]+}/")
    @RolesAllowed(value={"rest-all", "rest-process-read-only", "rest-process"})
    public Response getProcessDefinitionInfo(@PathParam(value="processDefId") String processId) {
        ProcessDefinition processAssetDescList = this.runtimeDataService.getProcessesByDeploymentIdProcessId(this.deploymentId, processId);
        JaxbProcessDefinition jaxbProcDef = this.convertProcAssetDescToJaxbProcDef(processAssetDescList);
        Map variables = this.bpmn2DataService.getProcessVariables(this.deploymentId, processId);
        jaxbProcDef.setVariables(variables);
        return RuntimeResourceImpl.createCorrectVariant(jaxbProcDef, this.headers);
    }

    @POST
    @Path(value="/process/{processDefId: [a-zA-Z0-9-:\\._]+}/start")
    @RolesAllowed(value={"rest-all", "rest-process"})
    public Response startProcessInstance(@PathParam(value="processDefId") String processId) {
        Map<String, String[]> requestParams = this.getRequestParams();
        String oper = this.getRelativePath();
        Map<String, Object> params = RuntimeResourceImpl.extractMapFromParams(requestParams, oper);
        List<String> correlationKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        ProcessInstance result = this.startProcessInstance(processId, params, correlationKeyProps);
        JaxbProcessInstanceResponse responseObj = new JaxbProcessInstanceResponse(result, this.getRequestUri());
        return RuntimeResourceImpl.createCorrectVariant(responseObj, this.headers);
    }

    @GET
    @Path(value="/process/{processDefId: [a-zA-Z0-9-:\\._]+}/startform")
    @RolesAllowed(value={"rest-all", "rest-process-read-only", "rest-process"})
    public Response getProcessInstanceStartForm(@PathParam(value="processDefId") String processId) {
        Map<String, String[]> requestParams = this.getRequestParams();
        List<String> correlationKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        List result = (List)this.processRequestBean.doKieSessionOperation(new GetProcessIdsCommand(), this.deploymentId, correlationKeyProps, (Long)null);
        if (result != null && result.contains(processId)) {
            String formUrl;
            String opener = "";
            List openers = this.headers.getRequestHeader("host");
            if (openers.size() == 1) {
                opener = (String)openers.get(0);
            }
            if (!StringUtils.isEmpty((CharSequence)(formUrl = this.formURLGenerator.generateFormProcessURL(this.getBaseUri(), processId, this.deploymentId, opener)))) {
                JaxbProcessInstanceFormResponse response = new JaxbProcessInstanceFormResponse(formUrl, this.getRequestUri());
                return RuntimeResourceImpl.createCorrectVariant(response, this.headers);
            }
        }
        throw KieRemoteRestOperationException.notFound("Process " + processId + " is not available.");
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}")
    @RolesAllowed(value={"rest-all", "rest-process-read-only", "rest-process"})
    public Response getProcessInstance(@PathParam(value="procInstId") Long procInstId) {
        ProcessInstance procInst = this.getProcessInstance(procInstId, true);
        JaxbProcessInstanceResponse response = new JaxbProcessInstanceResponse(procInst);
        if (procInst == null) {
            response.setStatus(JaxbRequestStatus.NOT_FOUND);
        }
        return RuntimeResourceImpl.createCorrectVariant(response, this.headers);
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/abort")
    @RolesAllowed(value={"rest-all", "rest-process"})
    public Response abortProcessInstance(@PathParam(value="procInstId") Long procInstId) {
        Map<String, String[]> requestParams = this.getRequestParams();
        List<String> correlationKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        AbortProcessInstanceCommand cmd = new AbortProcessInstanceCommand();
        cmd.setProcessInstanceId(procInstId);
        try {
            this.processRequestBean.doKieSessionOperation(cmd, this.deploymentId, correlationKeyProps, procInstId);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().startsWith("Could not find process instance")) {
                throw KieRemoteRestOperationException.notFound("Process instance " + procInstId + " is not available.");
            }
            throw KieRemoteRestOperationException.internalServerError("Unable to abort process instance '" + procInstId + "'", iae);
        }
        return RuntimeResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/signal")
    @RolesAllowed(value={"rest-all", "rest-process"})
    public Response signalProcessInstance(@PathParam(value="procInstId") Long procInstId) {
        String oper = this.getRelativePath();
        Map<String, String[]> requestParams = this.getRequestParams();
        String eventType = RuntimeResourceImpl.getStringParam("signal", true, requestParams, oper);
        Object event = RuntimeResourceImpl.getObjectParam("event", false, requestParams, oper);
        List<String> correlationKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        SignalEventCommand cmd = new SignalEventCommand(procInstId.longValue(), eventType, event);
        this.processRequestBean.doKieSessionOperation(cmd, this.deploymentId, correlationKeyProps, procInstId);
        return RuntimeResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}/variable/{varName: [\\w\\.-]+}")
    @RolesAllowed(value={"rest-all", "rest-process-read-only", "rest-process"})
    public Response getProcessInstanceVariableByProcInstIdByVarName(@PathParam(value="procInstId") Long procInstId, @PathParam(value="varName") String varName) {
        Object procVar;
        try {
            procVar = this.processRequestBean.getVariableObjectInstanceFromRuntime(this.deploymentId, procInstId, varName);
        }
        catch (ProcessInstanceNotFoundException pinfe) {
            throw KieRemoteRestOperationException.notFound(pinfe.getMessage(), (Exception)((Object)pinfe));
        }
        catch (DeploymentNotFoundException dnfe) {
            throw new DeploymentNotFoundException(dnfe.getMessage());
        }
        Variant v = RestEasy960Util.getVariant((HttpHeaders)this.headers);
        if (v == null) {
            v = RestEasy960Util.defaultVariant;
        }
        if (wrapJsonValues || v.getMediaType().equals((Object)MediaType.APPLICATION_XML_TYPE)) {
            procVar = RuntimeResourceImpl.wrapObjectIfNeeded(procVar);
        }
        return RuntimeResourceImpl.createCorrectVariant(procVar, this.headers);
    }

    @POST
    @Path(value="/signal")
    @RolesAllowed(value={"rest-all", "rest-process"})
    public Response signalProcessInstances() {
        String oper = this.getRelativePath();
        Map<String, String[]> requestParams = this.getRequestParams();
        String eventType = RuntimeResourceImpl.getStringParam("signal", true, requestParams, oper);
        Object event = RuntimeResourceImpl.getObjectParam("event", false, requestParams, oper);
        List<String> correlationKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        this.processRequestBean.doKieSessionOperation(new SignalEventCommand(eventType, event), this.deploymentId, correlationKeyProps, (Long)RuntimeResourceImpl.getNumberParam("runtimeProcInstId", false, requestParams, oper, true));
        return RuntimeResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    @GET
    @Path(value="/workitem/{workItemId: [0-9-]+}")
    @RolesAllowed(value={"rest-all", "rest-process-read-only", "rest-process"})
    public Response getWorkItem(@PathParam(value="workItemId") Long workItemId) {
        String oper = this.getRelativePath();
        Map<String, String[]> requestParams = this.getRequestParams();
        List<String> correlationKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        WorkItem workItem = (WorkItem)this.processRequestBean.doKieSessionOperation(new GetWorkItemCommand(workItemId.longValue()), this.deploymentId, correlationKeyProps, (Long)RuntimeResourceImpl.getNumberParam("runtimeProcInstId", false, this.getRequestParams(), oper, true));
        if (workItem == null) {
            throw KieRemoteRestOperationException.notFound("WorkItem " + workItemId + " does not exist.");
        }
        return RuntimeResourceImpl.createCorrectVariant(new JaxbWorkItemResponse((org.kie.api.runtime.process.WorkItem)workItem), this.headers);
    }

    @POST
    @Path(value="/workitem/{workItemId: [0-9-]+}/{oper: [a-zA-Z]+}")
    @RolesAllowed(value={"rest-all", "rest-process"})
    public Response doWorkItemOperation(@PathParam(value="workItemId") Long workItemId, @PathParam(value="oper") String operation) {
        String oper = this.getRelativePath();
        Map<String, String[]> requestParams = this.getRequestParams();
        List<String> correlationKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        CompleteWorkItemCommand cmd = null;
        if ("complete".equalsIgnoreCase(operation.trim())) {
            Map<String, Object> results = RuntimeResourceImpl.extractMapFromParams(requestParams, operation);
            cmd = new CompleteWorkItemCommand(workItemId.longValue(), results);
        } else if ("abort".equalsIgnoreCase(operation.toLowerCase())) {
            cmd = new AbortWorkItemCommand(workItemId.longValue());
        } else {
            throw KieRemoteRestOperationException.badRequest("Unsupported operation: " + oper);
        }
        this.processRequestBean.doKieSessionOperation(cmd, this.deploymentId, correlationKeyProps, (Long)RuntimeResourceImpl.getNumberParam("runtimeProcInstId", false, requestParams, oper, true));
        return RuntimeResourceImpl.createCorrectVariant(new JaxbGenericResponse(this.getRequestUri()), this.headers);
    }

    @POST
    @Path(value="/withvars/process/{processDefId: [a-zA-Z0-9-:\\._]+}/start")
    @RolesAllowed(value={"rest-all", "rest-process"})
    public Response withVarsStartProcessInstance(@PathParam(value="processDefId") String processId) {
        Map<String, String[]> requestParams = this.getRequestParams();
        String oper = this.getRelativePath();
        Map<String, Object> params = RuntimeResourceImpl.extractMapFromParams(requestParams, oper);
        List<String> corrKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        ProcessInstance procInst = this.startProcessInstance(processId, params, corrKeyProps);
        Map<String, String> vars = this.getVariables(procInst.getId(), corrKeyProps);
        JaxbProcessInstanceWithVariablesResponse resp = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.getRequestUri());
        return RuntimeResourceImpl.createCorrectVariant(resp, this.headers);
    }

    @GET
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}")
    @RolesAllowed(value={"rest-all", "rest-process-read-only", "rest-process"})
    public Response withVarsGetProcessInstance(@PathParam(value="procInstId") Long procInstId) {
        Map<String, String[]> requestParams = this.getRequestParams();
        List<String> corrKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        ProcessInstance procInst = this.getProcessInstance(procInstId, true);
        Map<String, String> vars = this.getVariables(procInstId, corrKeyProps);
        JaxbProcessInstanceWithVariablesResponse responseObj = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.getRequestUri());
        return RuntimeResourceImpl.createCorrectVariant(responseObj, this.headers);
    }

    @POST
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}/signal")
    @RolesAllowed(value={"rest-all", "rest-process"})
    public Response withVarsSignalProcessInstance(@PathParam(value="procInstId") Long procInstId) {
        String oper = this.getRelativePath();
        Map<String, String[]> requestParams = this.getRequestParams();
        String eventType = RuntimeResourceImpl.getStringParam("signal", true, requestParams, oper);
        Object event = RuntimeResourceImpl.getObjectParam("event", false, requestParams, oper);
        List<String> correlationKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(requestParams);
        this.processRequestBean.doKieSessionOperation(new SignalEventCommand(procInstId.longValue(), eventType, event), this.deploymentId, correlationKeyProps, procInstId);
        ProcessInstance processInstance = this.getProcessInstance(procInstId, false);
        Map<String, String> vars = this.getVariables(procInstId, correlationKeyProps);
        return RuntimeResourceImpl.createCorrectVariant(new JaxbProcessInstanceWithVariablesResponse(processInstance, vars), this.headers);
    }

    private ProcessInstance getProcessInstance(long procInstId, boolean throwEx) {
        Map<String, String[]> params = this.getRequestParams();
        List<String> correlationKeyProps = RuntimeResourceImpl.getCorrelationKeyProperties(params);
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(Long.valueOf(procInstId));
        cmd.setReadOnly(true);
        Object procInstResult = this.processRequestBean.doKieSessionOperation(cmd, this.deploymentId, correlationKeyProps, procInstId);
        if (procInstResult != null) {
            return (ProcessInstance)procInstResult;
        }
        if (throwEx) {
            throw KieRemoteRestOperationException.notFound("Unable to retrieve process instance " + procInstId + " which may have been completed. Please see the history operations.");
        }
        return null;
    }

    private Map<String, String> getVariables(long processInstanceId, List<String> corrKeyProps) {
        List varInstLogList = (List)this.processRequestBean.doKieSessionOperation(new FindVariableInstancesCommand(processInstanceId), this.deploymentId, corrKeyProps, processInstanceId);
        HashMap<String, String> vars = new HashMap<String, String>();
        if (varInstLogList.isEmpty()) {
            return vars;
        }
        HashMap<String, VariableInstanceLog> varLogMap = new HashMap<String, VariableInstanceLog>();
        for (VariableInstanceLog variableInstanceLog : varInstLogList) {
            String varId = variableInstanceLog.getVariableId();
            VariableInstanceLog prevVarLog = varLogMap.put(varId, variableInstanceLog);
            if (prevVarLog == null || !prevVarLog.getDate().after(variableInstanceLog.getDate())) continue;
            varLogMap.put(varId, prevVarLog);
        }
        for (Map.Entry entry : varLogMap.entrySet()) {
            vars.put((String)entry.getKey(), ((VariableInstanceLog)entry.getValue()).getValue());
        }
        return vars;
    }

    private ProcessInstance startProcessInstance(String processId, Map<String, Object> params, List<String> corrKeyProps) {
        ProcessInstance result = null;
        StartProcessCommand cmd = null;
        if (corrKeyProps != null && !corrKeyProps.isEmpty()) {
            CorrelationKey key = KieInternalServices.Factory.get().newCorrelationKeyFactory().newCorrelationKey(corrKeyProps);
            cmd = new StartCorrelatedProcessCommand(processId, key);
        } else {
            cmd = new StartProcessCommand(processId, params);
        }
        try {
            result = (ProcessInstance)this.processRequestBean.doKieSessionOperation(cmd, this.deploymentId, corrKeyProps, (Long)null);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().startsWith("Unknown process ID")) {
                throw KieRemoteRestOperationException.notFound("Process '" + processId + "' is not known to this deployment.");
            }
            throw KieRemoteRestOperationException.internalServerError("Unable to start process instance '" + processId + "'", iae);
        }
        return result;
    }

    protected QName getRootElementName(Object object) {
        boolean xmlRootElemAnnoFound = false;
        Class<?> objClass = object.getClass();
        XmlRootElement xmlRootElemAnno = objClass.getAnnotation(XmlRootElement.class);
        logger.debug("Getting XML root element annotation for " + object.getClass().getName());
        if (xmlRootElemAnno != null) {
            xmlRootElemAnnoFound = true;
            return new QName(xmlRootElemAnno.name());
        }
        for (Annotation anno : objClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            if (!XmlRootElement.class.getName().equals(annoClass.getName())) continue;
            xmlRootElemAnnoFound = true;
            try {
                Method nameMethod = annoClass.getMethod("name", new Class[0]);
                Object nameVal = nameMethod.invoke((Object)anno, new Object[0]);
                if (!(nameVal instanceof String)) continue;
                return new QName((String)nameVal);
            }
            catch (Exception e) {
                throw KieRemoteRestOperationException.internalServerError("Unable to retrieve XmlRootElement info via reflection", e);
            }
        }
        if (!xmlRootElemAnnoFound) {
            String errorMsg = "Unable to serialize " + object.getClass().getName() + " instance because it is missing a " + XmlRootElement.class.getName() + " annotation with a name value.";
            throw KieRemoteRestOperationException.internalServerError(errorMsg);
        }
        return null;
    }
}

