/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api;

import java.lang.reflect.Field;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.kie.api.runtime.manager.Context;
import org.kie.services.client.api.command.RemoteRuntimeException;

public class RemoteConfiguration {
    public static final String CONNECTION_FACTORY_NAME = "jms/RemoteConnectionFactory";
    public static final String SESSION_QUEUE_NAME = "jms/queue/KIE.SESSION";
    public static final String TASK_QUEUE_NAME = "jms/queue/KIE.TASK";
    public static final String RESPONSE_QUEUE_NAME = "jms/queue/KIE.RESPONSE";
    private final Type type;
    private String deploymentId;
    private String username;
    private String password;
    private Context<?> context;
    private String url;
    private AuthenticationType authenticationType;
    private ConnectionFactory connectionFactory;
    private Queue ksessionQueue;
    private Queue taskQueue;
    private Queue responseQueue;
    private int qualityOfServiceThresholdMilliSeconds = 5000;
    private int serializationType = 1;

    public RemoteConfiguration(String deploymentId, String url) {
        this.deploymentId = deploymentId;
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.url = url = url + "rest";
        this.type = Type.REST;
        this.authenticationType = AuthenticationType.NONE;
    }

    public RemoteConfiguration(String deploymentId, String url, AuthenticationType authenticationType, String username, String password) {
        this(deploymentId, url);
        this.authenticationType = authenticationType;
        this.username = username;
        this.password = password;
    }

    public RemoteConfiguration(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue) {
        this.deploymentId = deploymentId;
        this.connectionFactory = connectionFactory;
        this.ksessionQueue = ksessionQueue;
        this.taskQueue = taskQueue;
        this.responseQueue = responseQueue;
        this.type = Type.JMS;
    }

    public RemoteConfiguration(String deploymentId, ConnectionFactory connectionFactory, Queue ksessionQueue, Queue taskQueue, Queue responseQueue, String username, String password) {
        this(deploymentId, connectionFactory, ksessionQueue, taskQueue, responseQueue);
        this.username = username;
        this.password = password;
    }

    public RemoteConfiguration(String deploymentId, InitialContext context) {
        this.deploymentId = deploymentId;
        String prop = CONNECTION_FACTORY_NAME;
        try {
            this.connectionFactory = (ConnectionFactory)context.lookup(prop);
            prop = SESSION_QUEUE_NAME;
            this.ksessionQueue = (Queue)context.lookup(prop);
            prop = TASK_QUEUE_NAME;
            this.taskQueue = (Queue)context.lookup(prop);
            prop = RESPONSE_QUEUE_NAME;
            this.responseQueue = (Queue)context.lookup(prop);
        }
        catch (NamingException ne) {
            throw new RemoteRuntimeException("Unable to retrieve object for " + prop, ne);
        }
        this.type = Type.JMS;
    }

    public RemoteConfiguration(String deploymentId, InitialContext context, String username, String password) {
        this(deploymentId, context);
        this.username = username;
        this.password = password;
    }

    public String getUrl() {
        this.notNullAssert();
        return this.url;
    }

    public String getDeploymentId() {
        this.notNullAssert();
        return this.deploymentId;
    }

    public AuthenticationType getAuthenticationType() {
        this.notNullAssert();
        return this.authenticationType;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Context<?> getContext() {
        return this.context;
    }

    public void setContext(Context<?> context) {
        this.context = context;
    }

    public ConnectionFactory getConnectionFactory() {
        this.notNullAssert();
        return this.connectionFactory;
    }

    public Queue getKsessionQueue() {
        this.notNullAssert();
        return this.ksessionQueue;
    }

    public Queue getTaskQueue() {
        this.notNullAssert();
        return this.taskQueue;
    }

    public Queue getResponseQueue() {
        this.notNullAssert();
        return this.responseQueue;
    }

    public void setQualityOfServiceThresholdMilliSeconds(int qualityOfServiceThresholdMilliSeconds) {
        this.qualityOfServiceThresholdMilliSeconds = qualityOfServiceThresholdMilliSeconds;
    }

    public int getQualityOfServiceThresholdMilliSeconds() {
        return this.qualityOfServiceThresholdMilliSeconds;
    }

    public int getSerializationType() {
        return this.serializationType;
    }

    public void setSerializationType(int serializationType) {
        this.serializationType = serializationType;
    }

    public boolean isJms() {
        return this.type == Type.JMS;
    }

    public boolean isRest() {
        return this.type == Type.REST;
    }

    private void notNullAssert() {
        String fieldName = new Throwable().getStackTrace()[1].getMethodName();
        fieldName = fieldName.replace("get", "");
        fieldName = fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1);
        Object fieldVal = null;
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            fieldVal = field.get(this);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        assert (fieldVal != null) : fieldName + " is null!";
    }

    private static enum Type {
        REST,
        JMS;

    }

    public static enum AuthenticationType {
        NONE,
        BASIC,
        FORM;

    }
}

