/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.api.command.Command;
import org.kie.api.task.model.Task;
import org.kie.services.client.api.RemoteConfiguration;
import org.kie.services.client.api.command.RemoteRuntimeException;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbExceptionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteCommandObject {
    protected static Logger logger = LoggerFactory.getLogger(AbstractRemoteCommandObject.class);
    protected final String url;
    protected final RemoteConfiguration config;

    public AbstractRemoteCommandObject(RemoteConfiguration config) {
        this.url = null;
        this.config = config;
    }

    public AbstractRemoteCommandObject(String url, RemoteConfiguration config) {
        this.url = url;
        this.config = config;
    }

    public <T> T execute(Command<T> command) {
        if (this.config.isRest()) {
            return this.executeRestCommand(command);
        }
        return this.executeJmsCommand(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeJmsCommand(Command<T> command) {
        JaxbCommandsRequest req = new JaxbCommandsRequest(this.config.getDeploymentId(), command);
        ConnectionFactory factory = this.config.getConnectionFactory();
        Queue sendQueue = command instanceof TaskCommand ? this.config.getKsessionQueue() : this.config.getTaskQueue();
        Queue responseQueue = this.config.getResponseQueue();
        Connection connection = null;
        Session session = null;
        JaxbCommandsResponse cmdResponse = null;
        String corrId = UUID.randomUUID().toString();
        String selector = "JMSCorrelationID = '" + corrId + "'";
        try {
            Message response;
            BytesMessage msg;
            MessageConsumer consumer;
            MessageProducer producer;
            try {
                connection = this.config.getPassword() != null ? factory.createConnection(this.config.getUsername(), this.config.getPassword()) : factory.createConnection();
                session = connection.createSession(false, 1);
                producer = session.createProducer((Destination)sendQueue);
                consumer = session.createConsumer((Destination)responseQueue, selector);
                connection.start();
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to setup a JMS connection.", jmse);
            }
            try {
                msg = session.createBytesMessage();
                msg.setJMSCorrelationID(corrId);
                msg.setIntProperty("serialization", this.config.getSerializationType());
                String xmlStr = JaxbSerializationProvider.convertJaxbObjectToString(req);
                msg.writeUTF(xmlStr);
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to create and fill a JMS message.", jmse);
            }
            catch (JAXBException jaxbe) {
                throw new RemoteRuntimeException("Unable to deserialze JMS message.", jaxbe);
            }
            try {
                producer.send((Message)msg);
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to send a JMS message.", jmse);
            }
            try {
                response = consumer.receive((long)this.config.getQualityOfServiceThresholdMilliSeconds());
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to receive or retrieve the JMS response.", jmse);
            }
            assert (response != null) : "Response is empty.";
            try {
                String xmlStr = ((BytesMessage)response).readUTF();
                cmdResponse = (JaxbCommandsResponse)JaxbSerializationProvider.convertStringToJaxbObject(xmlStr);
            }
            catch (JMSException jmse) {
                throw new RemoteRuntimeException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", jmse);
            }
            catch (JAXBException jaxbe) {
                throw new RemoteRuntimeException("Unable to extract " + JaxbCommandsResponse.class.getSimpleName() + " instance from JMS response.", jaxbe);
            }
            assert (cmdResponse != null) : "Jaxb Cmd Response was null!";
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    session.close();
                }
                catch (JMSException jmse) {
                    logger.warn("Unable to close connection or session!", (Throwable)jmse);
                }
            }
        }
        List<JaxbCommandResponse<?>> responses = cmdResponse.getResponses();
        if (responses.size() > 0) {
            JaxbCommandResponse<?> response = responses.get(0);
            if (response instanceof JaxbExceptionResponse) {
                JaxbExceptionResponse exceptionResponse = (JaxbExceptionResponse)response;
                throw new RemoteRuntimeException(exceptionResponse.getMessage());
            }
            return (T)response.getResult();
        }
        assert (responses.size() == 0) : "There shouldn't be more than 1 response [" + responses.size() + "] returned by a command!";
        return null;
    }

    public <T> T executeRestCommand(Command<T> command) {
        String password;
        String username;
        String baseUrl = this.config.getUrl();
        String deploymentId = this.config.getDeploymentId();
        RemoteConfiguration.AuthenticationType authenticationType = this.config.getAuthenticationType();
        ClientRequest restRequest = null;
        DefaultHttpClient client = new DefaultHttpClient();
        if (RemoteConfiguration.AuthenticationType.BASIC == authenticationType) {
            username = this.config.getUsername();
            password = this.config.getPassword();
            client.getCredentialsProvider().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(username, password));
        } else if (RemoteConfiguration.AuthenticationType.FORM == authenticationType) {
            username = this.config.getUsername();
            password = this.config.getPassword();
            HttpPost mainMethod = new HttpPost(baseUrl);
            ArrayList nameValuePairsEmpty = new ArrayList(1);
            try {
                mainMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairsEmpty));
                HttpResponse response = client.execute((HttpUriRequest)mainMethod);
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new RuntimeException("Error invoking REST " + this.url + " " + response.getStatusLine());
                }
                EntityUtils.consume((HttpEntity)response.getEntity());
                HttpPost authMethod = new HttpPost(baseUrl + "/j_security_check");
                ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>(1);
                nameValuePairs.add(new BasicNameValuePair("j_username", username));
                nameValuePairs.add(new BasicNameValuePair("j_password", password));
                authMethod.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs));
                client.setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

                    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) {
                        int responseCode;
                        boolean isRedirect = false;
                        try {
                            isRedirect = super.isRedirected(request, response, context);
                        }
                        catch (ProtocolException e) {
                            e.printStackTrace();
                        }
                        if (!(isRedirect || (responseCode = response.getStatusLine().getStatusCode()) != 301 && responseCode != 302)) {
                            return true;
                        }
                        return isRedirect;
                    }
                });
                HttpResponse authresponse = client.execute((HttpUriRequest)authMethod);
                List<Integer> invalidCodes = Arrays.asList(500, 401, 403);
                if (invalidCodes.contains(response.getStatusLine().getStatusCode())) {
                    throw new RuntimeException("Error invoking REST " + this.url + " " + response.getStatusLine());
                }
                EntityUtils.consume((HttpEntity)authresponse.getEntity());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Could not initialize form-based authentication", e);
            }
            catch (ClientProtocolException e) {
                throw new RuntimeException("Could not initialize form-based authentication", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not initialize form-based authentication", e);
            }
        }
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor((HttpClient)client);
        restRequest = new ClientRequest(this.url, (ClientExecutor)executor);
        restRequest.body("application/xml", (Object)new JaxbCommandsRequest(deploymentId, command));
        ClientResponse response = null;
        try {
            response = restRequest.post(Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to post request: " + e.getMessage(), e);
        }
        if (response.getResponseStatus() == Response.Status.OK) {
            JaxbCommandsResponse commandResponse = (JaxbCommandsResponse)response.getEntity(JaxbCommandsResponse.class);
            List<JaxbCommandResponse<?>> responses = commandResponse.getResponses();
            if (responses.size() == 0) {
                return null;
            }
            if (responses.size() == 1) {
                JaxbCommandResponse<?> responseObject = responses.get(0);
                if (responseObject instanceof JaxbExceptionResponse) {
                    JaxbExceptionResponse exceptionResponse = (JaxbExceptionResponse)responseObject;
                    String causeMessage = exceptionResponse.getCauseMessage();
                    throw new RuntimeException(exceptionResponse.getMessage() + (causeMessage == null ? "" : " Caused by: " + causeMessage));
                }
                return (T)responseObject.getResult();
            }
            throw new RuntimeException("Unexpected number of results: " + responses.size());
        }
        throw new RuntimeException("Error invoking REST " + this.url + " " + response.getResponseStatus() + " " + (String)response.getEntity(String.class));
    }

    public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }

    public void writeExternal(ObjectOutput arg0) throws IOException {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + Task.class.getSimpleName() + " implementation.");
    }
}

