/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.api.command;

import org.drools.core.command.CommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.jbpm.services.task.impl.command.CommandBasedTaskService;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.task.TaskService;
import org.kie.services.client.api.RemoteConfiguration;
import org.kie.services.client.api.command.RemoteSessionCommandService;
import org.kie.services.client.api.command.RemoteTaskCommandExecutor;

public class RemoteRuntimeEngine
implements RuntimeEngine {
    private final RemoteConfiguration config;

    public RemoteRuntimeEngine(RemoteConfiguration configuration) {
        this.config = configuration;
    }

    public KieSession getKieSession() {
        RemoteSessionCommandService commandService;
        if (this.config.isRest()) {
            String url = this.config.getUrl() + "/runtime/" + this.config.getDeploymentId() + "/execute";
            commandService = new RemoteSessionCommandService(url, this.config);
        } else {
            commandService = new RemoteSessionCommandService(this.config);
        }
        return new CommandBasedStatefulKnowledgeSession((CommandService)commandService);
    }

    public TaskService getTaskService() {
        RemoteTaskCommandExecutor executor;
        if (this.config.isRest()) {
            String url = this.config.getUrl() + "/task/execute";
            executor = new RemoteTaskCommandExecutor(url, this.config);
        } else {
            executor = new RemoteTaskCommandExecutor(this.config);
        }
        return new CommandBasedTaskService((CommandExecutor)executor);
    }
}

