/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization;

import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import org.kie.services.client.serialization.SerializationException;
import org.kie.services.client.serialization.SerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbLongListResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbOtherResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbPrimitiveResponse;
import org.kie.services.client.serialization.jaxb.impl.JaxbVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbNodeInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbProcessInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbVariableInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnitList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinition;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessIdList;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceListResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItem;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbContentResponse;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskResponse;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskSummaryListResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbRequestStatus;

public class JaxbSerializationProvider
implements SerializationProvider {
    public static final int JMS_SERIALIZATION_TYPE = 0;
    public static Set<Class<?>> KIE_JAXB_CLASS_SET;
    public static Set<Class<?>> PRIMITIVE_ARRAY_CLASS_SET;
    private Set<Class<?>> jaxbClasses = new HashSet(KIE_JAXB_CLASS_SET);
    private Set<Class<?>> extraJaxbClasses;
    private JAXBContext jaxbContext;
    private boolean prettyPrint;

    public JaxbSerializationProvider() {
        this.jaxbClasses.addAll(PRIMITIVE_ARRAY_CLASS_SET);
        this.extraJaxbClasses = new HashSet();
        this.prettyPrint = false;
        this.initializeJaxbContext();
    }

    public JaxbSerializationProvider(Collection<Class<?>> extraJaxbClassList) {
        this.jaxbClasses.addAll(PRIMITIVE_ARRAY_CLASS_SET);
        this.extraJaxbClasses = new HashSet();
        this.prettyPrint = false;
        extraJaxbClassList.addAll(extraJaxbClassList);
        this.jaxbClasses.addAll(extraJaxbClassList);
        this.initializeJaxbContext();
    }

    private void initializeJaxbContext() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])this.jaxbClasses.toArray(new Class[this.jaxbClasses.size()]));
        }
        catch (JAXBException jaxbe) {
            throw new UnsupportedOperationException("Unsupported JAXB Class during initialization: " + jaxbe.getMessage(), jaxbe);
        }
    }

    public JAXBContext getJaxbContext() {
        return this.jaxbContext;
    }

    @Override
    public String serialize(Object object) {
        Marshaller marshaller = null;
        try {
            marshaller = this.jaxbContext.createMarshaller();
            if (this.prettyPrint) {
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
            }
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unable to create JAXB marshaller", jaxbe);
        }
        try {
            marshaller.setProperty(CharacterEscapeHandler.class.getName(), (Object)new CharacterEscapeHandler(){

                public void escape(char[] ac, int i, int j, boolean flag, Writer writer) throws IOException {
                    writer.write(ac, i, j);
                }
            });
        }
        catch (PropertyException e) {
            throw new SerializationException("Unable to set CharacterEscapeHandler", e);
        }
        StringWriter stringWriter = new StringWriter();
        try {
            marshaller.marshal(object, (Writer)stringWriter);
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unable to marshall " + object.getClass().getSimpleName() + " instance.", jaxbe);
        }
        String output = stringWriter.toString();
        return output;
    }

    @Override
    public Object deserialize(Object xmlStrObject) {
        if (!(xmlStrObject instanceof String)) {
            throw new UnsupportedOperationException(JaxbSerializationProvider.class.getSimpleName() + " can only deserialize Strings");
        }
        String xmlStr = (String)xmlStrObject;
        Unmarshaller unmarshaller = null;
        try {
            unmarshaller = this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unable to create unmarshaller.", jaxbe);
        }
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlStr.getBytes(Charset.forName("UTF-8")));
        Object jaxbObj = null;
        try {
            jaxbObj = unmarshaller.unmarshal((InputStream)xmlStrInputStream);
        }
        catch (JAXBException jaxbe) {
            throw new SerializationException("Unable to unmarshal string.", jaxbe);
        }
        return jaxbObj;
    }

    public void addJaxbClasses(Class<?> ... jaxbClass) {
        for (int i = 0; i < jaxbClass.length; ++i) {
            this.jaxbClasses.add(jaxbClass[i]);
            this.extraJaxbClasses.add(jaxbClass[i]);
        }
        this.initializeJaxbContext();
    }

    public void addJaxbClasses(Collection<Class<?>> jaxbClassList) {
        for (Class<?> jaxbClass : jaxbClassList) {
            this.jaxbClasses.add(jaxbClass);
            this.extraJaxbClasses.add(jaxbClass);
        }
        this.initializeJaxbContext();
    }

    public Collection<Class<?>> getExtraJaxbClasses() {
        return new HashSet(this.extraJaxbClasses);
    }

    public static Set<Class<?>> commaSeperatedStringToClassSet(String extraClassNames) throws SerializationException {
        return JaxbSerializationProvider.commaSeperatedStringToClassSet(JaxbSerializationProvider.class.getClassLoader(), extraClassNames);
    }

    public static Set<Class<?>> commaSeperatedStringToClassSet(ClassLoader classloader, String extraClassNames) throws SerializationException {
        HashSet classList = new HashSet();
        if ((extraClassNames = extraClassNames.trim()).isEmpty()) {
            return classList;
        }
        String[] extraClassNameList = JaxbSerializationProvider.split(extraClassNames);
        if (extraClassNameList.length == 0) {
            return classList;
        }
        for (String extraClassName : extraClassNameList) {
            if (extraClassName.endsWith("[]")) continue;
            try {
                classList.add(classloader.loadClass(extraClassName));
            }
            catch (ClassNotFoundException cnfe) {
                throw new SerializationException("Unable to load JAXB class '" + extraClassName, cnfe);
            }
        }
        return classList;
    }

    public static String classSetToCommaSeperatedString(Collection<Class<?>> extraClassList) throws SerializationException {
        StringBuilder out = new StringBuilder("");
        HashSet extraClassSet = new HashSet();
        extraClassSet.addAll(extraClassList);
        for (Class clazz : extraClassSet) {
            String extraClassName;
            if (out.length() > 0) {
                out.append(",");
            }
            if ((extraClassName = clazz.getCanonicalName()) == null) {
                throw new SerializationException("Only classes with canonical names can be used for serialization");
            }
            out.append(extraClassName);
        }
        return out.toString();
    }

    public static String[] split(String in) {
        String[] splitIn = in.split(",");
        ArrayList<String> outList = new ArrayList<String>();
        for (int i = 0; i < splitIn.length; ++i) {
            splitIn[i] = splitIn[i].trim();
            if (splitIn[i].isEmpty()) continue;
            outList.add(splitIn[i]);
        }
        return outList.toArray(new String[outList.size()]);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    static {
        Class[] kieJaxbClasses = new Class[]{JaxbCommandsRequest.class, JaxbCommandsResponse.class, JaxbContentResponse.class, JaxbTaskResponse.class, JaxbTaskSummaryListResponse.class, JaxbProcessInstanceListResponse.class, JaxbProcessInstanceResponse.class, JaxbProcessInstanceWithVariablesResponse.class, JaxbGenericResponse.class, JaxbLongListResponse.class, JaxbOtherResponse.class, JaxbPrimitiveResponse.class, JaxbVariablesResponse.class, JaxbExceptionResponse.class, JaxbGenericResponse.class, JaxbRequestStatus.class, JaxbDeploymentJobResult.class, JaxbDeploymentUnit.class, JaxbDeploymentUnitList.class, JaxbProcessIdList.class, JaxbProcessDefinition.class, JaxbWorkItem.class, JaxbHistoryLogList.class, JaxbNodeInstanceLog.class, JaxbProcessInstanceLog.class, JaxbVariableInstanceLog.class};
        KIE_JAXB_CLASS_SET = new CopyOnWriteArraySet<Class>(Arrays.asList(kieJaxbClasses));
        Class[] primitiveClasses = new Class[]{new Boolean[0].getClass(), new Byte[0].getClass(), new Character[0].getClass(), new Double[0].getClass(), new Float[0].getClass(), new Integer[0].getClass(), new Long[0].getClass(), new Math[0].getClass(), new Number[0].getClass(), new Short[0].getClass(), new String[0].getClass()};
        PRIMITIVE_ARRAY_CLASS_SET = new CopyOnWriteArraySet<Class>(Arrays.asList(primitiveClasses));
    }
}

