/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization.jaxb.impl.deploy;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.drools.core.util.StringUtils;
import org.kie.internal.deployment.DeploymentUnit;

@XmlRootElement(name="deployment-unit")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"identifier"})
public class JaxbDeploymentUnit
implements DeploymentUnit {
    @XmlElement
    @XmlSchemaType(name="string")
    private String groupId;
    @XmlElement
    @XmlSchemaType(name="string")
    private String artifactId;
    @XmlElement
    @XmlSchemaType(name="string")
    private String version;
    @XmlElement
    @XmlSchemaType(name="string")
    private String kbaseName;
    @XmlElement
    @XmlSchemaType(name="string")
    private String ksessionName;
    @XmlElement(type=DeploymentUnit.RuntimeStrategy.class)
    private DeploymentUnit.RuntimeStrategy strategy;
    @XmlElement
    @XmlSchemaType(name="string")
    private String identifier;
    @XmlElement(type=JaxbDeploymentStatus.class)
    private volatile JaxbDeploymentStatus status;

    public JaxbDeploymentUnit() {
    }

    public JaxbDeploymentUnit(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public JaxbDeploymentUnit(String groupId, String artifactId, String version, String kbaseName, String ksessionName) {
        this(groupId, artifactId, version);
        this.kbaseName = kbaseName;
        this.ksessionName = ksessionName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getKbaseName() {
        return this.kbaseName;
    }

    public void setKbaseName(String kbaseName) {
        this.kbaseName = kbaseName;
    }

    public String getKsessionName() {
        return this.ksessionName;
    }

    public void setKsessionName(String ksessionName) {
        this.ksessionName = ksessionName;
    }

    public DeploymentUnit.RuntimeStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(DeploymentUnit.RuntimeStrategy strategy) {
        this.strategy = strategy;
    }

    public JaxbDeploymentStatus getStatus() {
        return this.status;
    }

    public void setStatus(JaxbDeploymentStatus status) {
        this.status = status;
    }

    public String getIdentifier() {
        boolean ksessionFilled;
        String id = this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
        boolean kbaseFilled = !StringUtils.isEmpty((CharSequence)this.kbaseName);
        boolean bl = ksessionFilled = !StringUtils.isEmpty((CharSequence)this.ksessionName);
        if (kbaseFilled || ksessionFilled) {
            id = id.concat(":");
            if (kbaseFilled) {
                id = id.concat(this.kbaseName);
            }
            if (ksessionFilled) {
                id = id.concat(":" + this.ksessionName);
            }
        }
        return id;
    }

    public void setIdentifier(String newId) {
    }

    @XmlEnum
    public static enum JaxbDeploymentStatus {
        NONEXISTENT,
        ACCEPTED,
        DEPLOYING,
        DEPLOYED,
        DEPLOY_FAILED,
        UNDEPLOYING,
        UNDEPLOY_FAILED,
        UNDEPLOYED;

    }
}

