/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.client.serialization.jaxb.impl.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.kie.api.command.Command;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.AbstractJaxbCommandResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbRequestStatus;

@XmlRootElement(name="process-instance")
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"processName", "process", "result"})
public class JaxbProcessInstanceResponse
extends AbstractJaxbCommandResponse<ProcessInstance>
implements ProcessInstance {
    @XmlElement(name="process-id")
    @XmlSchemaType(name="string")
    private String processId;
    @XmlElement
    @XmlSchemaType(name="long")
    private long id;
    @XmlElement
    @XmlSchemaType(name="int")
    private int state;
    @XmlElement(name="event-types")
    private List<String> eventTypes = new ArrayList<String>();

    public JaxbProcessInstanceResponse() {
    }

    public JaxbProcessInstanceResponse(ProcessInstance processInstance, int i, Command<?> cmd) {
        super(i, cmd);
        this.initialize(processInstance);
    }

    public JaxbProcessInstanceResponse(ProcessInstance processInstance) {
        this.initialize(processInstance);
    }

    public JaxbProcessInstanceResponse(ProcessInstance processInstance, String requestUrl) {
        this.initialize(processInstance);
        this.url = requestUrl;
        this.status = JaxbRequestStatus.SUCCESS;
    }

    protected void initialize(ProcessInstance processInstance) {
        if (processInstance != null) {
            this.eventTypes = Arrays.asList(processInstance.getEventTypes());
            this.id = processInstance.getId();
            this.processId = processInstance.getProcessId();
            this.state = processInstance.getState();
        }
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public void setEventTypes(List<String> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public String getProcessName() {
        String methodName = new Throwable().getStackTrace()[0].getMethodName();
        throw new UnsupportedOperationException(methodName + " is not supported on the JAXB " + ProcessInstance.class.getSimpleName() + " implementation.");
    }

    public Process getProcess() {
        return (Process)JaxbSerializationProvider.unsupported(ProcessInstance.class);
    }

    public String[] getEventTypes() {
        return this.eventTypes.toArray(new String[this.eventTypes.size()]);
    }

    public void signalEvent(String type, Object event) {
        JaxbSerializationProvider.unsupported(ProcessInstance.class);
    }

    @Override
    public ProcessInstance getResult() {
        return this;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ProcessInstance ");
        b.append(this.id);
        b.append(" [processId=");
        b.append(this.processId);
        b.append(",state=");
        b.append(this.state);
        b.append("]");
        return b.toString();
    }

    @Override
    public void setResult(ProcessInstance result) {
        this.initialize(result);
    }
}

