/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.jms;

import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.MessageDrivenContext;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.naming.InitialContext;
import org.kie.services.client.serialization.jaxb.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.JaxbSerializationProvider;
import org.kie.services.remote.UnfinishedError;
import org.kie.services.remote.cdi.ProcessRequestBean;
import org.kie.services.remote.util.CommandsRequestUtil;

public class RequestMessageBean
implements MessageListener {
    @Inject
    private Logger logger;
    @Resource(mappedName="java:/ConnectionFactory")
    private ConnectionFactory connectionFactory;
    @Inject
    private ProcessRequestBean processRequestBean;
    @Resource
    private MessageDrivenContext msgContext;
    private String RESPONSE_QUEUE_NAME = null;

    @PostConstruct
    public void init() {
        this.RESPONSE_QUEUE_NAME = System.getProperty("kie.services.jms.queues.response", "queue/KIE.RESPONSE.ALL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message message) {
        int[] serializationTypeHolder = new int[1];
        JaxbCommandsRequest cmdsRequest = this.deserializeRequest(message, serializationTypeHolder);
        JaxbCommandsResponse jaxbResponse = cmdsRequest != null ? CommandsRequestUtil.processJaxbCommandsRequest(cmdsRequest, this.processRequestBean) : null;
        boolean failure = false;
        Connection connection = null;
        Session session = null;
        try {
            connection = this.connectionFactory.createConnection();
            connection.start();
            session = connection.createSession(false, 1);
        }
        catch (Exception e) {
            failure = true;
        }
        finally {
            if (failure && connection != null) {
                try {
                    connection.close();
                    connection = null;
                    session.close();
                    session = null;
                }
                catch (Exception e) {}
            }
        }
        Message msg = null;
        if (!failure) {
            msg = this.serializeResponse(session, serializationTypeHolder[0], jaxbResponse);
        }
        if (!failure) {
            try {
                InitialContext context = new InitialContext();
                Queue responseQueue = (Queue)context.lookup(this.RESPONSE_QUEUE_NAME);
                MessageProducer producer = session.createProducer((Destination)responseQueue);
                producer.send(msg);
            }
            catch (Exception e) {
                String errorMsg = "Unable to send msg to " + this.RESPONSE_QUEUE_NAME;
                this.logger.severe(errorMsg);
                throw new RuntimeException(errorMsg, e);
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                        connection = null;
                        session.close();
                        session = null;
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private JaxbCommandsRequest deserializeRequest(Message message, int[] serializationTypeHolder) {
        JaxbCommandsRequest cmdMsg = null;
        try {
            serializationTypeHolder[0] = message.getIntProperty("serialization");
            if (serializationTypeHolder[0] != 1) {
                throw new UnfinishedError("Unknown serialization type : " + serializationTypeHolder[0]);
            }
            String msgStrContent = ((BytesMessage)message).readUTF();
            cmdMsg = (JaxbCommandsRequest)JaxbSerializationProvider.convertStringToJaxbObject((String)msgStrContent);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read " + JaxbCommandsRequest.class.getSimpleName() + " from " + BytesMessage.class.getSimpleName());
        }
        return cmdMsg;
    }

    private Message serializeResponse(Session session, int serializationtype, JaxbCommandsResponse jaxbResponse) {
        BytesMessage byteMsg = null;
        try {
            byteMsg = session.createBytesMessage();
            byteMsg.setIntProperty("serialization", serializationtype);
            if (serializationtype != 1) {
                throw new UnfinishedError("Unknown serialization type : " + serializationtype);
            }
            String xmlStr = JaxbSerializationProvider.convertJaxbObjectToString((Object)jaxbResponse);
            byteMsg.writeUTF(xmlStr);
        }
        catch (Exception e) {
            String msg = "Unable to read " + JaxbCommandsRequest.class.getSimpleName() + " from " + BytesMessage.class.getSimpleName();
            this.logger.severe(msg);
            throw new RuntimeException(msg, e);
        }
        return byteMsg;
    }
}

