/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jboss.resteasy.spi.BadRequestException;
import org.jbpm.services.task.impl.model.GroupImpl;
import org.jbpm.services.task.impl.model.TaskImpl;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.query.TaskSummaryImpl;
import org.kie.api.task.model.I18NText;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;

public class ResourceBase {
    protected static String checkThatOperationExists(String operation, String[] possibleOperations) {
        for (String oper : possibleOperations) {
            if (!oper.equals(operation.trim().toLowerCase())) continue;
            return oper;
        }
        throw new BadRequestException("Operation '" + operation + "' is not supported on tasks.");
    }

    protected static Map<String, List<String>> getRequestParams(HttpServletRequest request) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            parameters.put(name, Arrays.asList(request.getParameterValues(name)));
        }
        return parameters;
    }

    protected static String getStringParam(String paramName, boolean required, Map<String, List<String>> params, String operation) {
        List<String> paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        if (!required && paramValues.isEmpty()) {
            return null;
        }
        if (paramValues.size() != 1) {
            throw new BadRequestException("One and only one '" + paramName + "' query parameter required for '" + operation + "' operation (" + paramValues.size() + " passed).");
        }
        return paramValues.get(0);
    }

    protected static List<String> getStringListParam(String paramName, boolean required, Map<String, List<String>> params, String operation) {
        List<String> paramValues = null;
        for (String key : params.keySet()) {
            if (!key.equalsIgnoreCase(paramName)) continue;
            paramValues = params.get(key);
            break;
        }
        if (paramValues == null) {
            if (required) {
                throw new BadRequestException("Query parameter '" + paramName + "' required for '" + operation + "' operation.");
            }
            return new ArrayList<String>();
        }
        return paramValues;
    }

    protected static Object getObjectParam(String paramName, boolean required, Map<String, List<String>> params, String operation) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getObjectFromString(paramName, paramVal);
    }

    protected static List<Long> getLongListParam(String paramName, boolean required, Map<String, List<String>> params, String operation, boolean mustBeLong) {
        List<String> paramValues = ResourceBase.getStringListParam(paramName, required, params, operation);
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (String strVal : paramValues) {
            longValues.add((Long)ResourceBase.getNumberFromString(paramName, strVal, mustBeLong));
        }
        return longValues;
    }

    protected static Number getNumberParam(String paramName, boolean required, Map<String, List<String>> params, String operation, boolean mustBeLong) {
        String paramVal = ResourceBase.getStringParam(paramName, required, params, operation);
        if (!required && paramVal == null) {
            return null;
        }
        return ResourceBase.getNumberFromString(paramName, paramVal, mustBeLong);
    }

    private static Object getObjectFromString(String key, String mapVal) {
        if (!mapVal.matches("^\\d+[li]?$")) {
            return mapVal;
        }
        return ResourceBase.getNumberFromString(key, mapVal, false);
    }

    private static Number getNumberFromString(String paramName, String paramVal, boolean mustBeLong) {
        if (paramVal.matches("^\\d+[li]?$")) {
            if (paramVal.matches(".*i$")) {
                if (mustBeLong) {
                    throw new BadRequestException(paramName + " parameter is numerical but contains the \"Integer\" suffix 'i' and must have no suffix or \"Long\" suffix 'l' (" + paramVal + ")");
                }
                if ((paramVal = paramVal.substring(0, paramVal.length() - 1)).length() > 9) {
                    throw new BadRequestException(paramName + " parameter is numerical but too large to be an integer (" + paramVal + "i)");
                }
                return Integer.parseInt(paramVal);
            }
            if (paramVal.length() > 18) {
                throw new BadRequestException(paramName + " parameter is numerical but too large to be a long (" + paramVal + ")");
            }
            if (paramVal.matches(".*l$")) {
                paramVal = paramVal.substring(0, paramVal.length() - 1);
            }
            return Long.parseLong(paramVal);
        }
        throw new BadRequestException(paramName + " parameter does not have a numerical format (" + paramVal + ")");
    }

    protected static Map<String, Object> extractMapFromParams(Map<String, List<String>> params, String operation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : params.keySet()) {
            if (!key.startsWith("map_")) continue;
            List<String> paramValues = params.get(key);
            if (paramValues.size() != 1) {
                throw new BadRequestException("Only one map_* (" + key + ") query parameter allowed for '" + operation + "' operation (" + paramValues.size() + " passed).");
            }
            String mapKey = key.substring("map_".length());
            String mapVal = paramValues.get(0).trim();
            map.put(mapKey, ResourceBase.getObjectFromString(key, mapVal));
        }
        return map;
    }

    protected static List<OrganizationalEntity> getOrganizationalEntityListFromParams(Map<String, List<String>> params) {
        ArrayList<OrganizationalEntity> orgEntList = new ArrayList<OrganizationalEntity>();
        List<String> users = ResourceBase.getStringListParam("user", true, params, "nominate");
        List<String> groups = ResourceBase.getStringListParam("group", true, params, "nominate");
        for (String user : users) {
            orgEntList.add((OrganizationalEntity)new UserImpl(user));
        }
        for (String group : groups) {
            orgEntList.add((OrganizationalEntity)new GroupImpl(group));
        }
        return orgEntList;
    }

    protected static TaskSummaryImpl convertTaskToTaskSummary(TaskImpl task) {
        TaskSummaryImpl taskSummary = new TaskSummaryImpl(task.getId().longValue(), task.getTaskData().getProcessInstanceId(), ((I18NText)task.getNames().get(0)).getText(), ((I18NText)task.getSubjects().get(0)).getText(), ((I18NText)task.getDescriptions().get(0)).getText(), task.getTaskData().getStatus(), task.getPriority(), task.getTaskData().isSkipable(), task.getTaskData().getActualOwner(), task.getTaskData().getCreatedBy(), task.getTaskData().getCreatedOn(), task.getTaskData().getActivationTime(), task.getTaskData().getExpirationTime(), task.getTaskData().getProcessId(), task.getTaskData().getProcessSessionId(), task.getSubTaskStrategy(), task.getTaskData().getParentId());
        return taskSummary;
    }

    protected static List<Status> convertStringListToStatusList(List<String> statusStrList) {
        ArrayList<Status> statusList = new ArrayList<Status>();
        for (String strStatus : statusStrList) {
            statusList.add((Status)Status.valueOf(Status.class, (String)strStatus));
        }
        return statusList;
    }

    protected static int[] getPageNumAndPageSize(Map<String, List<String>> params) {
        int[] pageInfo = new int[3];
        Number page = ResourceBase.getNumberParam("page", false, params, "query", false);
        Number pageShort = ResourceBase.getNumberParam("p", false, params, "query", false);
        Number pageSize = ResourceBase.getNumberParam("pageSize", false, params, "query", false);
        Number pageSizeShort = ResourceBase.getNumberParam("s", false, params, "query", false);
        int p = 1;
        int s = 10;
        if (page != null) {
            p = page.intValue();
        } else if (pageShort != null) {
            p = pageShort.intValue();
        }
        if (pageSize != null) {
            s = pageSize.intValue();
        } else if (pageSizeShort != null) {
            s = pageSizeShort.intValue();
        }
        pageInfo[0] = p;
        pageInfo[1] = s;
        pageInfo[2] = pageInfo[0] * pageInfo[1];
        return pageInfo;
    }
}

