/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.cdi;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Observes;
import javax.inject.Singleton;
import org.jbpm.kie.services.impl.event.Deploy;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.jbpm.runtime.manager.impl.PerProcessInstanceRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.services.task.commands.TaskCommand;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.services.remote.exception.DeploymentNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DeploymentInfoBean {
    private static final Logger logger = LoggerFactory.getLogger(DeploymentInfoBean.class);
    private Map<String, Collection<Class<?>>> deploymentClassesMap = new ConcurrentHashMap();
    private Map<String, RuntimeManager> domainRuntimeManagers = new ConcurrentHashMap<String, RuntimeManager>();

    public void addOnDeploy(@Observes @Deploy DeploymentEvent event) {
        RuntimeManager runtimeManager = this.domainRuntimeManagers.put(event.getDeploymentId(), event.getDeployedUnit().getRuntimeManager());
        if (runtimeManager != null) {
            logger.warn("RuntimeManager for domain {} has been replaced", (Object)event.getDeploymentId());
        }
        this.deploymentClassesMap.put(event.getDeploymentId(), event.getDeployedUnit().getDeployedClasses());
    }

    public void removeOnUnDeploy(@Observes @Undeploy DeploymentEvent event) {
        RuntimeManager runtimeManager = this.domainRuntimeManagers.remove(event.getDeploymentId());
        if (runtimeManager == null) {
            logger.warn("RuntimeManager for domain {}  does not exist and can not be undeployed.", (Object)event.getDeploymentId());
        }
        this.deploymentClassesMap.remove(event.getDeploymentId());
    }

    public RuntimeManager getRuntimeManager(String domainName) {
        return this.domainRuntimeManagers.get(domainName);
    }

    public RuntimeEngine getRuntimeEngineForTaskCommand(TaskCommand<?> cmd, TaskService taskService, boolean required) {
        Task task;
        Long taskId = cmd.getTaskId();
        RuntimeEngine engine = null;
        if (taskId != null && (task = taskService.getTaskById(taskId.longValue())) != null) {
            engine = this.getRuntimeEngine(task.getTaskData().getDeploymentId(), task.getTaskData().getProcessInstanceId());
        }
        if (required && engine == null) {
            throw new DeploymentNotFoundException("Unable to find deployment for command " + cmd.getClass().getSimpleName() + " called on task " + taskId + ".");
        }
        return engine;
    }

    public void disposeRuntimeEngine(RuntimeEngine runtimeEngine) {
        if (runtimeEngine != null) {
            RuntimeManager manager = ((RuntimeEngineImpl)runtimeEngine).getManager();
            manager.disposeRuntimeEngine(runtimeEngine);
        }
    }

    public RuntimeEngine getRuntimeEngine(String deploymentId, Long processInstanceId) {
        RuntimeManager runtimeManager = this.getRuntimeManager(deploymentId);
        if (runtimeManager == null) {
            throw new DeploymentNotFoundException("No runtime manager could be found for deployment '" + deploymentId + "'.");
        }
        Object runtimeContext = runtimeManager instanceof PerProcessInstanceRuntimeManager ? new ProcessInstanceIdContext(processInstanceId) : EmptyContext.get();
        return runtimeManager.getRuntimeEngine(runtimeContext);
    }

    public Collection<Class<?>> getDeploymentClasses(String deploymentId) {
        if (deploymentId == null) {
            return Collections.emptySet();
        }
        Collection<Class<?>> classes = this.deploymentClassesMap.get(deploymentId);
        if (classes == null) {
            return Collections.emptySet();
        }
        return classes;
    }

    public Collection<String> getDeploymentIds() {
        return this.deploymentClassesMap.keySet();
    }
}

