/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.RequestScoped;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jbpm.process.audit.AuditLogService;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.kie.services.client.serialization.jaxb.impl.audit.JaxbHistoryLogList;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.rest.exception.RestOperationException;

@Path(value="/history")
@RequestScoped
public class HistoryResource
extends ResourceBase {
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private Request restRequest;
    private static final String PERSISTENCE_UNIT_NAME = "org.jbpm.domain";
    @PersistenceUnit(unitName="org.jbpm.domain")
    private EntityManagerFactory emf;
    private AuditLogService auditLogService;

    @PostConstruct
    public void setAuditLogService() {
        this.auditLogService = new JPAAuditLogService(this.emf);
        if (this.emf == null) {
            ((JPAAuditLogService)this.auditLogService).setPersistenceUnitName(PERSISTENCE_UNIT_NAME);
        }
    }

    public AuditLogService getAuditLogService() {
        return this.auditLogService;
    }

    @POST
    @Path(value="/clear")
    public Response clear() {
        this.auditLogService.clear();
        return HistoryResource.createCorrectVariant(new JaxbGenericResponse(this.uriInfo.getRequestUri().toString()), this.headers);
    }

    @GET
    @Path(value="/instances")
    public Response instances() {
        String oper = HistoryResource.getRelativePath(this.uriInfo);
        Map<String, List<String>> params = HistoryResource.getRequestParams(this.uriInfo);
        List results = this.auditLogService.findProcessInstances();
        results = HistoryResource.paginate(HistoryResource.getPageNumAndPageSize(params, oper), results);
        return HistoryResource.createCorrectVariant(new JaxbHistoryLogList(results), this.headers);
    }

    @GET
    @Path(value="/instance/{procInstId: [0-9]+}")
    public Response instance_procInstId(@PathParam(value="procInstId") long procInstId) {
        Map<String, List<String>> params = HistoryResource.getRequestParams(this.uriInfo);
        String oper = HistoryResource.getRelativePath(this.uriInfo);
        ProcessInstanceLog procInstLog = this.auditLogService.findProcessInstance(procInstId);
        List<Object> logList = new ArrayList<ProcessInstanceLog>();
        logList.add(procInstLog);
        logList = HistoryResource.paginate(HistoryResource.getPageNumAndPageSize(params, oper), logList);
        return HistoryResource.createCorrectVariant(new JaxbHistoryLogList(logList), this.headers);
    }

    @GET
    @Path(value="/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}")
    public Response instance_procInstid_oper(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation) {
        Map<String, List<String>> params = HistoryResource.getRequestParams(this.uriInfo);
        String oper = HistoryResource.getRelativePath(this.uriInfo);
        List result = null;
        if ("child".equalsIgnoreCase(operation)) {
            result = this.auditLogService.findSubProcessInstances(procInstId.longValue());
        } else if ("node".equalsIgnoreCase(operation)) {
            result = this.auditLogService.findNodeInstances(procInstId.longValue());
        } else if ("variable".equalsIgnoreCase(operation)) {
            result = this.auditLogService.findVariableInstances(procInstId.longValue());
        } else {
            throw RestOperationException.badRequest("Unsupported operation: " + oper);
        }
        List varInstLogList = result;
        varInstLogList = HistoryResource.paginate(HistoryResource.getPageNumAndPageSize(params, oper), varInstLogList);
        JaxbHistoryLogList resultList = new JaxbHistoryLogList(varInstLogList);
        return HistoryResource.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}/{logId: [a-zA-Z0-9-:\\._]+}")
    public Response instance_procInstId_oper_logId(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation, @PathParam(value="logId") String logId) {
        Map<String, List<String>> params = HistoryResource.getRequestParams(this.uriInfo);
        String oper = HistoryResource.getRelativePath(this.uriInfo);
        List result = null;
        if ("node".equalsIgnoreCase(operation)) {
            result = this.auditLogService.findNodeInstances(procInstId.longValue(), logId);
        } else if ("variable".equalsIgnoreCase(operation)) {
            result = this.auditLogService.findVariableInstances(procInstId.longValue(), logId);
        } else {
            throw RestOperationException.badRequest("Unsupported operation: " + oper);
        }
        List varInstLogList = result;
        varInstLogList = HistoryResource.paginate(HistoryResource.getPageNumAndPageSize(params, oper), varInstLogList);
        JaxbHistoryLogList resultList = new JaxbHistoryLogList(varInstLogList);
        return HistoryResource.createCorrectVariant(resultList, this.headers);
    }

    @GET
    @Path(value="/process/{processDefId: [a-zA-Z0-9-:\\._]+}")
    public Response process_procDefId(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> params = HistoryResource.getRequestParams(this.uriInfo);
        Number statusParam = HistoryResource.getNumberParam("status", false, params, HistoryResource.getRelativePath(this.uriInfo), false);
        String oper = HistoryResource.getRelativePath(this.uriInfo);
        int[] pageInfo = HistoryResource.getPageNumAndPageSize(params, oper);
        List result = statusParam != null ? (statusParam.intValue() == 1 ? this.auditLogService.findActiveProcessInstances(processId) : this.auditLogService.findProcessInstances(processId)) : this.auditLogService.findProcessInstances(processId);
        List procInstLogList = result;
        if (statusParam != null && !statusParam.equals(1)) {
            ArrayList<ProcessInstanceLog> filteredProcLogList = new ArrayList<ProcessInstanceLog>();
            for (int i = 0; i < procInstLogList.size() && filteredProcLogList.size() < HistoryResource.getMaxNumResultsNeeded(pageInfo); ++i) {
                ProcessInstanceLog procLog = (ProcessInstanceLog)procInstLogList.get(i);
                if (!procLog.getStatus().equals(statusParam.intValue())) continue;
                filteredProcLogList.add(procLog);
            }
        }
        procInstLogList = HistoryResource.paginate(pageInfo, procInstLogList);
        return HistoryResource.createCorrectVariant(new JaxbHistoryLogList(procInstLogList), this.headers);
    }

    @GET
    @Path(value="/variable/{varId: [a-zA-Z0-9-:\\._]+}")
    public Response variable_varId(@PathParam(value="varId") String variableId) {
        Map<String, List<String>> params = HistoryResource.getRequestParams(this.uriInfo);
        String oper = HistoryResource.getRelativePath(this.uriInfo);
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, null, params, oper);
        varLogList = HistoryResource.paginate(HistoryResource.getPageNumAndPageSize(params, oper), varLogList);
        return HistoryResource.createCorrectVariant(new JaxbHistoryLogList(varLogList), this.headers);
    }

    @GET
    @Path(value="/variable/{varId: [a-zA-Z0-9-:\\._]+}/value/{value: [a-zA-Z0-9-:\\._]+}")
    public Response variable_varId_value_valueVal(@PathParam(value="varId") String variableId, @PathParam(value="value") String value) {
        Map<String, List<String>> params = HistoryResource.getRequestParams(this.uriInfo);
        String oper = HistoryResource.getRelativePath(this.uriInfo);
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, value, params, oper);
        varLogList = HistoryResource.paginate(HistoryResource.getPageNumAndPageSize(params, oper), varLogList);
        return HistoryResource.createCorrectVariant(new JaxbHistoryLogList(varLogList), this.headers);
    }

    @GET
    @Path(value="/variable/{varId: [a-zA-Z0-9-:\\._]+}/instances")
    public Response variable_varId_instances(@PathParam(value="varId") String variableId) {
        Map<String, List<String>> params = HistoryResource.getRequestParams(this.uriInfo);
        String oper = HistoryResource.getRelativePath(this.uriInfo);
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, null, params, oper);
        int maxNumResults = HistoryResource.getMaxNumResultsNeeded(HistoryResource.getPageNumAndPageSize(params, oper));
        List<ProcessInstanceLog> procInstLogList = this.getProcessInstanceLogsByVariable(varLogList, maxNumResults);
        return HistoryResource.createCorrectVariant(new JaxbHistoryLogList(procInstLogList), this.headers);
    }

    @GET
    @Path(value="/variable/{varId: [a-zA-Z0-9-:\\.]+}/value/{value: [a-zA-Z0-9-:\\._]+}/instances")
    public Response variable_varId_value_valueVal_instances(@PathParam(value="varId") String variableId, @PathParam(value="value") String value) {
        Map<String, List<String>> params = HistoryResource.getRequestParams(this.uriInfo);
        String oper = HistoryResource.getRelativePath(this.uriInfo);
        List<VariableInstanceLog> varLogList = this.internalGetVariableInstancesByVarAndValue(variableId, value, params, oper);
        int maxNumResults = HistoryResource.getMaxNumResultsNeeded(HistoryResource.getPageNumAndPageSize(params, oper));
        List<ProcessInstanceLog> procInstLogList = this.getProcessInstanceLogsByVariable(varLogList, maxNumResults);
        return HistoryResource.createCorrectVariant(new JaxbHistoryLogList(procInstLogList), this.headers);
    }

    private List<VariableInstanceLog> internalGetVariableInstancesByVarAndValue(String varId, String value, Map<String, List<String>> params, String oper) {
        String activeProcsParam = HistoryResource.getStringParam("activeProcesses", false, params, oper);
        boolean onlyActiveProcesses = false;
        if (activeProcsParam != null) {
            onlyActiveProcesses = Boolean.parseBoolean(activeProcsParam);
        }
        List result = value == null ? this.auditLogService.findVariableInstancesByName(varId, onlyActiveProcesses) : this.auditLogService.findVariableInstancesByNameAndValue(varId, value, onlyActiveProcesses);
        return result;
    }

    private List<ProcessInstanceLog> getProcessInstanceLogsByVariable(List<VariableInstanceLog> varLogList, int maxNumResults) {
        int numVarLogs = varLogList.size();
        int numProcInsts = 0;
        ArrayList<ProcessInstanceLog> resultList = new ArrayList<ProcessInstanceLog>();
        for (int i = 0; i < numVarLogs && numProcInsts < maxNumResults; ++i) {
            long procInstId = varLogList.get(i).getProcessInstanceId();
            ProcessInstanceLog procInstlog = this.auditLogService.findProcessInstance(procInstId);
            if (procInstlog == null) continue;
            resultList.add(procInstlog);
            ++numProcInsts;
        }
        return resultList;
    }
}

