/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.kie.api.command.Command;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.services.client.api.command.AcceptedCommands;
import org.kie.services.remote.cdi.DeploymentInfoBean;
import org.kie.services.remote.rest.exception.RestOperationException;
import org.kie.services.remote.util.ExecuteAndSerializeCommand;

@RequestScoped
public class RestProcessRequestBean {
    @Inject
    private DeploymentInfoBean runtimeMgrMgr;
    @Inject
    private TaskService taskService;

    public Object doKieSessionOperation(Command<?> cmd, String deploymentId, Long processInstanceId, String errorMsg) {
        Object result = null;
        RuntimeEngine runtimeEngine = null;
        try {
            runtimeEngine = this.runtimeMgrMgr.getRuntimeEngine(deploymentId, processInstanceId);
            KieSession kieSession = runtimeEngine.getKieSession();
            result = kieSession.execute(cmd);
        }
        catch (RuntimeException re) {
            throw re;
        }
        finally {
            this.runtimeMgrMgr.disposeRuntimeEngine(runtimeEngine);
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object doTaskOperationOnDeployment(TaskCommand<?> cmd, String deploymentId, Long processInstanceId, String errorMsg) {
        Object result = null;
        RuntimeEngine engine = null;
        try {
            if (deploymentId != null) {
                RuntimeEngine runtimeEngine = this.runtimeMgrMgr.getRuntimeEngine(deploymentId, processInstanceId);
                result = ((InternalTaskService)runtimeEngine.getTaskService()).execute(cmd);
            } else {
                engine = this.runtimeMgrMgr.getRuntimeEngineForTaskCommand(cmd, this.taskService, AcceptedCommands.TASK_COMMANDS_THAT_INFLUENCE_KIESESSION.contains(cmd.getClass()));
                result = engine != null ? ((InternalTaskService)engine.getTaskService()).execute(cmd) : ((InternalTaskService)this.taskService).execute(cmd);
            }
        }
        catch (PermissionDeniedException pde) {
            try {
                throw RestOperationException.conflict(pde.getMessage(), (Exception)((Object)pde));
                catch (RuntimeException re) {
                    throw re;
                }
            }
            catch (Throwable throwable) {
                this.runtimeMgrMgr.disposeRuntimeEngine(engine);
                throw throwable;
            }
        }
        this.runtimeMgrMgr.disposeRuntimeEngine(engine);
        return result;
    }

    public Object doTaskOperationOnDeployment(TaskCommand<?> cmd, String errorMsg) {
        return this.doTaskOperationOnDeployment(cmd, null, null, errorMsg);
    }

    public Object doNonDeploymentTaskOperationAndSerializeResult(TaskCommand<?> cmd, String errorMsg) {
        return this.doNonDeploymentTaskOperation(new ExecuteAndSerializeCommand(cmd), errorMsg);
    }

    public Object doNonDeploymentTaskOperation(TaskCommand<?> cmd, String errorMsg) {
        Object result = null;
        try {
            result = ((InternalTaskService)this.taskService).execute(cmd);
        }
        catch (PermissionDeniedException pde) {
            throw RestOperationException.conflict(pde.getMessage(), (Exception)((Object)pde));
        }
        catch (RuntimeException re) {
            throw re;
        }
        return result;
    }

    public Object getVariableObjectInstanceFromRuntime(String deploymentId, long processInstanceId, String varName) {
        String errorMsg = "Unable to retrieve variable '" + varName + "' from process instance " + processInstanceId;
        Object procVar = null;
        RuntimeEngine runtimeEngine = null;
        try {
            runtimeEngine = this.runtimeMgrMgr.getRuntimeEngine(deploymentId, processInstanceId);
            KieSession kieSession = runtimeEngine.getKieSession();
            ProcessInstance procInst = kieSession.getProcessInstance(processInstanceId);
            if (procInst == null) {
                throw RestOperationException.notFound("Process instance " + processInstanceId + " could not be found!");
            }
            procVar = ((WorkflowProcessInstanceImpl)procInst).getVariable(varName);
            if (procVar == null) {
                throw RestOperationException.notFound("Variable " + varName + " does not exist in process instance " + processInstanceId + "!");
            }
        }
        catch (RuntimeException re) {
            try {
                throw RestOperationException.internalServerError(errorMsg, re);
            }
            catch (Throwable throwable) {
                this.runtimeMgrMgr.disposeRuntimeEngine(runtimeEngine);
                throw throwable;
            }
        }
        this.runtimeMgrMgr.disposeRuntimeEngine(runtimeEngine);
        return procVar;
    }
}

