/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jbpm.kie.services.api.IdentityProvider;
import org.jbpm.services.task.audit.DeleteAuditEventsCommand;
import org.jbpm.services.task.commands.ActivateTaskCommand;
import org.jbpm.services.task.commands.ClaimNextAvailableTaskCommand;
import org.jbpm.services.task.commands.ClaimTaskCommand;
import org.jbpm.services.task.commands.CompleteTaskCommand;
import org.jbpm.services.task.commands.DelegateTaskCommand;
import org.jbpm.services.task.commands.ExitTaskCommand;
import org.jbpm.services.task.commands.FailTaskCommand;
import org.jbpm.services.task.commands.ForwardTaskCommand;
import org.jbpm.services.task.commands.GetContentCommand;
import org.jbpm.services.task.commands.GetTaskCommand;
import org.jbpm.services.task.commands.GetTasksByVariousFieldsCommand;
import org.jbpm.services.task.commands.NominateTaskCommand;
import org.jbpm.services.task.commands.ReleaseTaskCommand;
import org.jbpm.services.task.commands.ResumeTaskCommand;
import org.jbpm.services.task.commands.SkipTaskCommand;
import org.jbpm.services.task.commands.StartTaskCommand;
import org.jbpm.services.task.commands.StopTaskCommand;
import org.jbpm.services.task.commands.SuspendTaskCommand;
import org.jbpm.services.task.commands.TaskCommand;
import org.jbpm.services.task.impl.model.command.DeleteBAMTaskSummariesCommand;
import org.jbpm.services.task.impl.model.xml.JaxbContent;
import org.jbpm.services.task.impl.model.xml.JaxbTask;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.task.JaxbTaskSummaryListResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.rest.RestProcessRequestBean;
import org.kie.services.remote.rest.RuntimeResource;
import org.kie.services.remote.rest.exception.RestOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/task")
@RequestScoped
public class TaskResource
extends ResourceBase {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeResource.class);
    @Context
    private HttpHeaders headers;
    @Context
    private UriInfo uriInfo;
    @Context
    private Request restRequest;
    @Inject
    private RestProcessRequestBean processRequestBean;
    @Inject
    private IdentityProvider identityProvider;
    private static String[] allowedOperations = new String[]{"activate", "claim", "claimnextavailable", "complete", "delegate", "exit", "fail", "forward", "release", "resume", "skip", "start", "stop", "suspend", "nominate", "content"};
    private static String[] allowedQueryParams = new String[]{"workItemId", "taskId", "businessAdministrator", "potentialOwner", "status", "taskOwner", "processInstanceId", "language", "union"};

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return TaskResource.restProcessJaxbCommandsRequest(cmdsRequest, this.processRequestBean);
    }

    @GET
    @Path(value="/query")
    public Response query(@Context UriInfo uriInfo) {
        JaxbTaskSummaryListResponse responseObj = null;
        Map<String, List<String>> params = TaskResource.getRequestParams(uriInfo);
        String oper = TaskResource.getRelativePath(uriInfo);
        for (String queryParam : params.keySet()) {
            boolean allowed = false;
            for (String allowedParam : allowedQueryParams) {
                if (!allowedParam.equalsIgnoreCase(queryParam) && !paginationParams.contains(queryParam)) continue;
                allowed = true;
                break;
            }
            if (allowed) continue;
            throw RestOperationException.badRequest(queryParam + " is an unknown and unsupported query param for the task query operation.");
        }
        List<Long> workItemIds = TaskResource.getLongListParam(allowedQueryParams[0], false, params, "query", true);
        List<Long> taskIds = TaskResource.getLongListParam(allowedQueryParams[1], false, params, "query", true);
        List<Long> procInstIds = TaskResource.getLongListParam(allowedQueryParams[6], false, params, "query", true);
        List<String> busAdmins = TaskResource.getStringListParam(allowedQueryParams[2], false, params, "query");
        List<String> potOwners = TaskResource.getStringListParam(allowedQueryParams[3], false, params, "query");
        List<String> taskOwners = TaskResource.getStringListParam(allowedQueryParams[5], false, params, "query");
        List<String> language = TaskResource.getStringListParam(allowedQueryParams[7], false, params, "query");
        String unionStr = TaskResource.getStringParam(allowedQueryParams[8], false, params, "query");
        boolean union = Boolean.parseBoolean(unionStr);
        List<String> statusStrList = TaskResource.getStringListParam(allowedQueryParams[4], false, params, "query");
        List<Status> statuses = TaskResource.convertStringListToStatusList(statusStrList);
        GetTasksByVariousFieldsCommand queryCmd = new GetTasksByVariousFieldsCommand(workItemIds, taskIds, procInstIds, busAdmins, potOwners, taskOwners, statuses, language, union);
        List results = (List)this.processRequestBean.doNonDeploymentTaskOperation((TaskCommand<?>)queryCmd, "Unable to execute " + queryCmd.getClass().getSimpleName());
        results = TaskResource.paginate(TaskResource.getPageNumAndPageSize(params, oper), results);
        responseObj = new JaxbTaskSummaryListResponse(results);
        return TaskResource.createCorrectVariant(responseObj, this.headers);
    }

    @GET
    @Path(value="/{taskId: [0-9-]+}")
    public Response taskId(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        JaxbTask task = (JaxbTask)this.processRequestBean.doNonDeploymentTaskOperationAndSerializeResult((TaskCommand<?>)cmd, "Unable to get task " + taskId);
        if (task == null) {
            throw RestOperationException.notFound("Task " + taskId + " could not be found.");
        }
        return TaskResource.createCorrectVariant(task, this.headers);
    }

    @POST
    @Path(value="/{taskId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public Response taskId_oper(@PathParam(value="taskId") long taskId, @PathParam(value="oper") String operation) {
        Map<String, List<String>> params = TaskResource.getRequestParams(this.uriInfo);
        operation = TaskResource.checkThatOperationExists(operation, allowedOperations);
        String userId = this.identityProvider.getName();
        logger.debug("Executing " + operation + " on task " + taskId + " by user " + userId);
        ActivateTaskCommand cmd = null;
        if ("activate".equalsIgnoreCase(operation)) {
            cmd = new ActivateTaskCommand(taskId, userId);
        } else if ("claim".equalsIgnoreCase(operation)) {
            cmd = new ClaimTaskCommand(taskId, userId);
        } else if ("claimnextavailable".equalsIgnoreCase(operation)) {
            String language = TaskResource.getStringParam("language", false, params, operation);
            if (language == null) {
                language = "en-UK";
            }
            cmd = new ClaimNextAvailableTaskCommand(userId, language);
        } else if ("complete".equalsIgnoreCase(operation)) {
            Map<String, Object> data = TaskResource.extractMapFromParams(params, operation);
            cmd = new CompleteTaskCommand(taskId, userId, data);
        } else if ("delegate".equalsIgnoreCase(operation)) {
            String targetEntityId = TaskResource.getStringParam("targetEntityId", true, params, operation);
            cmd = new DelegateTaskCommand(taskId, userId, targetEntityId);
        } else if ("exit".equalsIgnoreCase(operation)) {
            cmd = new ExitTaskCommand(taskId, userId);
        } else if ("fail".equalsIgnoreCase(operation)) {
            Map<String, Object> data = TaskResource.extractMapFromParams(params, operation);
            cmd = new FailTaskCommand(taskId, userId, data);
        } else if ("forward".equalsIgnoreCase(operation)) {
            String targetEntityId = TaskResource.getStringParam("targetEntityId", true, params, operation);
            cmd = new ForwardTaskCommand(taskId, userId, targetEntityId);
        } else if ("release".equalsIgnoreCase(operation)) {
            cmd = new ReleaseTaskCommand(taskId, userId);
        } else if ("resume".equalsIgnoreCase(operation)) {
            cmd = new ResumeTaskCommand(taskId, userId);
        } else if ("skip".equalsIgnoreCase(operation)) {
            cmd = new SkipTaskCommand(taskId, userId);
        } else if ("start".equalsIgnoreCase(operation)) {
            cmd = new StartTaskCommand(taskId, userId);
        } else if ("stop".equalsIgnoreCase(operation)) {
            cmd = new StopTaskCommand(taskId, userId);
        } else if ("suspend".equalsIgnoreCase(operation)) {
            cmd = new SuspendTaskCommand(taskId, userId);
        } else if ("nominate".equalsIgnoreCase(operation)) {
            List<OrganizationalEntity> potentialOwners = TaskResource.getOrganizationalEntityListFromParams(params, true, "nominate");
            cmd = new NominateTaskCommand(taskId, userId, potentialOwners);
        } else {
            throw RestOperationException.badRequest("Unsupported operation: /task/" + taskId + "/" + operation);
        }
        this.processRequestBean.doTaskOperationOnDeployment((TaskCommand<?>)cmd, "Unable to " + operation + " task " + taskId);
        return TaskResource.createCorrectVariant(new JaxbGenericResponse(this.uriInfo.getRequestUri().toString()), this.headers);
    }

    private static String checkThatOperationExists(String operation, String[] possibleOperations) {
        for (String oper : possibleOperations) {
            if (!oper.equals(operation.trim().toLowerCase())) continue;
            return oper;
        }
        throw RestOperationException.badRequest("Operation '" + operation + "' is not supported on tasks.");
    }

    @GET
    @Path(value="/{taskId: [0-9-]+}/content")
    public Response taskId_content(@PathParam(value="taskId") long taskId) {
        GetTaskCommand cmd = new GetTaskCommand(taskId);
        Object result = this.processRequestBean.doNonDeploymentTaskOperationAndSerializeResult((TaskCommand<?>)cmd, "Unable to get task " + taskId);
        if (result == null) {
            throw RestOperationException.notFound("Task " + taskId + " could not be found.");
        }
        long contentId = ((Task)result).getTaskData().getDocumentContentId();
        JaxbContent content = null;
        if (contentId <= -1L) {
            throw RestOperationException.notFound("Content for task " + taskId + " could not be found.");
        }
        cmd = new GetContentCommand(Long.valueOf(contentId));
        result = this.processRequestBean.doNonDeploymentTaskOperationAndSerializeResult((TaskCommand<?>)cmd, "Unable get content " + contentId + " (from task " + taskId + ")");
        content = (JaxbContent)result;
        return TaskResource.createCorrectVariant(content, this.headers);
    }

    @GET
    @Path(value="/content/{contentId: [0-9-]+}")
    public Response content_contentId(@PathParam(value="contentId") long contentId) {
        GetContentCommand cmd = new GetContentCommand(Long.valueOf(contentId));
        JaxbContent content = (JaxbContent)this.processRequestBean.doNonDeploymentTaskOperationAndSerializeResult((TaskCommand<?>)cmd, "Unable to get task content " + contentId);
        if (content == null) {
            throw RestOperationException.notFound("Content " + contentId + " could not be found.");
        }
        return TaskResource.createCorrectVariant(new JaxbContent((Content)content), this.headers);
    }

    @POST
    @Path(value="/history/bam/clear")
    public Response bam_clear() {
        this.processRequestBean.doNonDeploymentTaskOperation((TaskCommand<?>)new DeleteBAMTaskSummariesCommand(), "Unable to delete BAM task summaries.");
        return TaskResource.createCorrectVariant(new JaxbGenericResponse(this.uriInfo.getRequestUri().toString()), this.headers);
    }

    @POST
    @Path(value="/history/events/clear")
    public Response events_clear() {
        this.processRequestBean.doNonDeploymentTaskOperation((TaskCommand<?>)new DeleteAuditEventsCommand(), "Unable to delete task audit events.");
        return TaskResource.createCorrectVariant(new JaxbGenericResponse(this.uriInfo.getRequestUri().toString()), this.headers);
    }
}

