/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.exception;

import javax.enterprise.context.RequestScoped;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBException;
import org.kie.services.client.serialization.jaxb.rest.JaxbExceptionResponse;
import org.kie.services.client.serialization.jaxb.rest.JaxbRequestStatus;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.rest.exception.RestOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@RequestScoped
public class DescriptiveExceptionHandler
implements ExceptionMapper<Exception> {
    private static final Logger logger = LoggerFactory.getLogger(DescriptiveExceptionHandler.class);
    @Context
    private UriInfo uriInfo;
    @Context
    private HttpHeaders headers;

    public Response toResponse(Exception e) {
        JaxbRequestStatus requestStatus;
        Response.ResponseBuilder responseBuilder = null;
        int status = -1;
        if (e instanceof RestOperationException) {
            status = ((RestOperationException)e).getStatus();
        } else if (e.getClass().getPackage().getName().equals("org.jboss.resteasy.spi")) {
            String simpleClassName = e.getClass().getSimpleName();
            if ("BadRequestException".equals(simpleClassName)) {
                status = 400;
            } else if ("ReaderException".equals(simpleClassName)) {
                status = 400;
            } else if ("UnauthorizedException".equals(simpleClassName)) {
                status = 401;
            } else if ("NotFoundException".equals(simpleClassName)) {
                status = 404;
            } else if ("MethodNotAllowedException".equals(simpleClassName)) {
                status = 405;
            } else if ("NotAcceptableException".equals(simpleClassName)) {
                status = 406;
            } else if ("WriterException".equals(simpleClassName)) {
                status = 500;
            } else if ("InternalServerErrorException".equals(simpleClassName)) {
                status = 500;
            }
        }
        logger.warn("Exception thrown when processing request [" + ResourceBase.getRelativePath(this.uriInfo) + "]; responding with status " + status, (Throwable)e);
        responseBuilder = status > 0 ? Response.status((int)status) : Response.serverError();
        switch (status) {
            case 400: {
                requestStatus = JaxbRequestStatus.BAD_REQUEST;
                break;
            }
            case 403: {
                requestStatus = JaxbRequestStatus.FORBIDDEN;
                break;
            }
            case 404: {
                requestStatus = JaxbRequestStatus.NOT_FOUND;
                break;
            }
            case 409: {
                requestStatus = JaxbRequestStatus.PERMISSIONS_CONFLICT;
                break;
            }
            default: {
                requestStatus = JaxbRequestStatus.FAILURE;
            }
        }
        JaxbExceptionResponse response = new JaxbExceptionResponse(this.uriInfo.getRequestUri().toString(), e, requestStatus);
        try {
            responseBuilder.entity((Object)response.prettyPrint());
        }
        catch (JAXBException jaxbe) {
            responseBuilder.entity((Object)JaxbExceptionResponse.convertStackTraceToString((Throwable)jaxbe));
        }
        return responseBuilder.variant(ResourceBase.getVariant(this.headers)).build();
    }
}

