/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest.jaxb;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.Validator;
import org.jbpm.kie.services.impl.event.DeploymentEvent;
import org.jbpm.kie.services.impl.event.Undeploy;
import org.kie.services.client.serialization.JaxbSerializationProvider;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.remote.cdi.DeploymentInfoBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DynamicJAXBContext
extends JAXBContext {
    private static final Logger logger = LoggerFactory.getLogger(DynamicJAXBContext.class);
    private Set<Class<?>> types = new CopyOnWriteArraySet();
    private ConcurrentHashMap<String, JAXBContext> contexts = new ConcurrentHashMap();
    @Inject
    private DeploymentInfoBean deploymentClassNameBean;
    private UriInfo uriInfo;

    public DynamicJAXBContext() {
        this.types.add(JaxbCommandsRequest.class);
        this.types.add(JaxbCommandsResponse.class);
    }

    public Unmarshaller createUnmarshaller() throws JAXBException {
        JAXBContext context = this.getContext();
        if (context != null) {
            return context.createUnmarshaller();
        }
        return null;
    }

    public Marshaller createMarshaller() throws JAXBException {
        JAXBContext context = this.getContext();
        if (context != null) {
            return context.createMarshaller();
        }
        return null;
    }

    public Validator createValidator() throws JAXBException {
        JAXBContext context = this.getContext();
        if (context != null) {
            return context.createValidator();
        }
        return null;
    }

    public void addType(Class<?> type) {
        this.types.add(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getContext() {
        String deploymentId = this.getDeploymentId();
        if (deploymentId == null) {
            logger.error("Unable to find deployment id which results in returning empty JAXBContext");
            try {
                return JAXBContext.newInstance((Class[])new Class[0]);
            }
            catch (JAXBException e) {
                logger.error("Unable to create new " + JAXBContext.class.getSimpleName() + " instance.", (Throwable)e);
                return null;
            }
        }
        ConcurrentHashMap<String, JAXBContext> concurrentHashMap = this.contexts;
        synchronized (concurrentHashMap) {
            if (this.contexts.containsKey(deploymentId)) {
                return this.contexts.get(deploymentId);
            }
            HashSet classesForSerialization = new HashSet();
            classesForSerialization.addAll(JaxbSerializationProvider.PRIMITIVE_ARRAY_CLASS_SET);
            if (deploymentId != null) {
                Collection<Class<?>> deploymentClassNames = this.deploymentClassNameBean.getDeploymentClasses(deploymentId);
                for (Class<?> clazz : deploymentClassNames) {
                    logger.debug("Adding {} to JAXBContext instance.", (Object)clazz.getName());
                }
                classesForSerialization.addAll(deploymentClassNames);
            }
            classesForSerialization.addAll(this.types);
            Class[] types = classesForSerialization.toArray(new Class[classesForSerialization.size()]);
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])types);
                this.contexts.put(deploymentId, context);
                return context;
            }
            catch (JAXBException jaxbe) {
                logger.error("Unable to create new " + JAXBContext.class.getSimpleName() + " instance.", (Throwable)jaxbe);
            }
        }
        return null;
    }

    public void removeOnUnDeploy(@Observes @Undeploy DeploymentEvent event) {
        this.contexts.remove(event.getDeploymentId());
    }

    protected String getDeploymentId() {
        String deploymentId = null;
        List deploymentIdParams = (List)this.uriInfo.getPathParameters().get((Object)"deploymentId");
        if (deploymentIdParams != null && !deploymentIdParams.isEmpty()) {
            deploymentId = (String)deploymentIdParams.get(0);
        } else {
            deploymentIdParams = (List)this.uriInfo.getQueryParameters().get((Object)"deploymentId");
            if (deploymentIdParams != null && !deploymentIdParams.isEmpty()) {
                deploymentId = (String)deploymentIdParams.get(0);
            }
        }
        return deploymentId;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }
}

