/*
 * Decompiled with CFR 0.152.
 */
package org.kie.services.remote.rest;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.drools.core.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.core.command.runtime.process.AbortWorkItemCommand;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.GetProcessInstanceCommand;
import org.drools.core.command.runtime.process.GetWorkItemCommand;
import org.drools.core.command.runtime.process.SignalEventCommand;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.drools.core.process.instance.WorkItem;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.process.audit.command.FindVariableInstancesCommand;
import org.kie.api.command.Command;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsRequest;
import org.kie.services.client.serialization.jaxb.impl.JaxbCommandsResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessInstanceWithVariablesResponse;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbWorkItem;
import org.kie.services.client.serialization.jaxb.rest.JaxbGenericResponse;
import org.kie.services.remote.rest.HistoryResource;
import org.kie.services.remote.rest.ResourceBase;
import org.kie.services.remote.rest.exception.RestOperationException;

@Path(value="/runtime/{deploymentId: [\\w\\.-]+(:[\\w\\.-]+){2,2}(:[\\w\\.-]*){0,2}}")
@RequestScoped
public class RuntimeResource
extends ResourceBase {
    @Context
    protected HttpHeaders headers;
    @Context
    protected UriInfo uriInfo;
    @Context
    private Request restRequest;
    @PathParam(value="deploymentId")
    protected String deploymentId;
    @Inject
    private HistoryResource historyResource;

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/execute")
    public JaxbCommandsResponse execute(JaxbCommandsRequest cmdsRequest) {
        return this.restProcessJaxbCommandsRequest(cmdsRequest, this.processRequestBean);
    }

    @POST
    @Path(value="/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response process_defId_start(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> requestParams = RuntimeResource.getRequestParams(this.uriInfo);
        String oper = RuntimeResource.getRelativePath(this.uriInfo);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(requestParams, oper);
        ProcessInstance result = this.startProcessInstance(processId, params);
        JaxbProcessInstanceResponse responseObj = new JaxbProcessInstanceResponse(result, this.uriInfo.getRequestUri().toString());
        return RuntimeResource.createCorrectVariant(responseObj, this.headers);
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}")
    public Response process_instance_procInstId(@PathParam(value="procInstId") Long procInstId) {
        ProcessInstance result = this.getProcessInstance(procInstId);
        return RuntimeResource.createCorrectVariant(new JaxbProcessInstanceResponse(result), this.headers);
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/abort")
    public Response process_instance_procInstId_abort(@PathParam(value="procInstId") Long procInstId) {
        AbortProcessInstanceCommand cmd = new AbortProcessInstanceCommand();
        cmd.setProcessInstanceId(procInstId);
        try {
            this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().startsWith("Could not find process instance")) {
                throw RestOperationException.notFound("Process instance " + procInstId + " is not available.");
            }
            throw iae;
        }
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.uriInfo.getRequestUri().toString()), this.headers);
    }

    @POST
    @Path(value="/process/instance/{procInstId: [0-9]+}/signal")
    public Response process_instance_procInstId_signal(@PathParam(value="procInstId") Long procInstId) {
        String oper = RuntimeResource.getRelativePath(this.uriInfo);
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.uriInfo);
        String eventType = RuntimeResource.getStringParam("signal", true, params, oper);
        Object event = RuntimeResource.getObjectParam("event", false, params, oper);
        SignalEventCommand cmd = new SignalEventCommand(procInstId.longValue(), eventType, event);
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId);
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.uriInfo.getRequestUri().toString()), this.headers);
    }

    @GET
    @Path(value="/process/instance/{procInstId: [0-9]+}/variable/{varName: [\\w\\.-]+}")
    public Response process_instance_procInstId_variable_varName(@PathParam(value="procInstId") Long procInstId, @PathParam(value="varName") String varName) {
        Object procVar = this.processRequestBean.getVariableObjectInstanceFromRuntime(this.deploymentId, procInstId, varName);
        QName rootElementName = this.getRootElementName(procVar);
        JAXBElement jaxbElem = new JAXBElement(rootElementName, procVar.getClass(), procVar);
        return RuntimeResource.createCorrectVariant(jaxbElem, this.headers);
    }

    @POST
    @Path(value="/signal")
    public Response signal() {
        String oper = RuntimeResource.getRelativePath(this.uriInfo);
        Map<String, List<String>> requestParams = RuntimeResource.getRequestParams(this.uriInfo);
        String eventType = RuntimeResource.getStringParam("signal", true, requestParams, oper);
        Object event = RuntimeResource.getObjectParam("event", false, requestParams, oper);
        this.processRequestBean.doKieSessionOperation((Command<?>)new SignalEventCommand(eventType, event), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, requestParams, oper, true));
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.uriInfo.getRequestUri().toString()), this.headers);
    }

    @GET
    @Path(value="/workitem/{workItemId: [0-9-]+}")
    public Response workitem_workItemId(@PathParam(value="workItemId") Long workItemId) {
        String oper = RuntimeResource.getRelativePath(this.uriInfo);
        WorkItem workItem = (WorkItem)this.processRequestBean.doKieSessionOperation((Command<?>)new GetWorkItemCommand(workItemId.longValue()), this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, RuntimeResource.getRequestParams(this.uriInfo), oper, true));
        if (workItem == null) {
            throw RestOperationException.notFound("WorkItem " + workItemId + " does not exist.");
        }
        return RuntimeResource.createCorrectVariant(new JaxbWorkItem((org.kie.api.runtime.process.WorkItem)workItem), this.headers);
    }

    @POST
    @Path(value="/workitem/{workItemId: [0-9-]+}/{oper: [a-zA-Z]+}")
    public Response worktiem_workItemId_oper(@PathParam(value="workItemId") Long workItemId, @PathParam(value="oper") String operation) {
        String oper = RuntimeResource.getRelativePath(this.uriInfo);
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.uriInfo);
        CompleteWorkItemCommand cmd = null;
        if ("complete".equalsIgnoreCase(operation.trim())) {
            Map<String, Object> results = RuntimeResource.extractMapFromParams(params, operation);
            cmd = new CompleteWorkItemCommand(workItemId.longValue(), results);
        } else if ("abort".equalsIgnoreCase(operation.toLowerCase())) {
            cmd = new AbortWorkItemCommand(workItemId.longValue());
        } else {
            throw RestOperationException.badRequest("Unsupported operation: " + oper);
        }
        this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, (Long)RuntimeResource.getNumberParam("runtimeProcInstId", false, params, oper, true));
        return RuntimeResource.createCorrectVariant(new JaxbGenericResponse(this.uriInfo.getRequestUri().toString()), this.headers);
    }

    @POST
    @Path(value="/history/clear")
    @Deprecated
    public Response history_clear() {
        return this.historyResource.clear();
    }

    @GET
    @Path(value="/history/instances")
    @Deprecated
    public Response history_instances() {
        return this.historyResource.instances();
    }

    @GET
    @Path(value="/history/instance/{procInstId: [0-9]+}")
    @Deprecated
    public Response history_instance_procInstId(@PathParam(value="procInstId") long procInstId) {
        return this.historyResource.instance_procInstId(procInstId);
    }

    @GET
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}")
    @Deprecated
    public Response history_instance_procInstid_oper(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation) {
        return this.historyResource.instance_procInstid_oper(procInstId, operation);
    }

    @GET
    @Path(value="/history/instance/{procInstId: [0-9]+}/{oper: [a-zA-Z]+}/{logId: [a-zA-Z0-9-:\\._]+}")
    @Deprecated
    public Response history_instance_procInstId_oper_logId(@PathParam(value="procInstId") Long procInstId, @PathParam(value="oper") String operation, @PathParam(value="logId") String logId) {
        return this.historyResource.instance_procInstId_oper_logId(procInstId, operation, logId);
    }

    @GET
    @Path(value="/history/process/{processDefId: [a-zA-Z0-9-:\\._]+}")
    @Deprecated
    public Response history_process_procDefId(@PathParam(value="processDefId") String processId) {
        return this.historyResource.process_procDefId(processId);
    }

    @GET
    @Path(value="/history/variable/{varId: [a-zA-Z0-9-:\\._]+}")
    @Deprecated
    public Response history_variable_varId(@PathParam(value="varId") String variableId) {
        return this.historyResource.variable_varId(variableId);
    }

    @GET
    @Path(value="/history/variable/{varId: [a-zA-Z0-9-:\\._]+}/value/{value: [a-zA-Z0-9-:\\._]+}")
    @Deprecated
    public Response history_variable_varId_value_valueVal(@PathParam(value="varId") String variableId, @PathParam(value="value") String value) {
        return this.historyResource.variable_varId_value_valueVal(variableId, value);
    }

    @GET
    @Path(value="/history/variable/{varId: [a-zA-Z0-9-:\\._]+}/instances")
    @Deprecated
    public Response history_variable_varId_instances(@PathParam(value="varId") String variableId) {
        return this.historyResource.variable_varId_instances(variableId);
    }

    @GET
    @Path(value="/history/variable/{varId: [a-zA-Z0-9-:\\.]+}/value/{value: [a-zA-Z0-9-:\\._]+}/instances")
    @Deprecated
    public Response history_variable_varId_value_valueVal_instances(@PathParam(value="procId") String variableId, @PathParam(value="value") String value) {
        return this.historyResource.variable_varId_value_valueVal_instances(variableId, value);
    }

    @POST
    @Path(value="/withvars/process/{processDefId: [_a-zA-Z0-9-:\\.]+}/start")
    public Response withvars_process_processDefId_start(@PathParam(value="processDefId") String processId) {
        Map<String, List<String>> requestParams = RuntimeResource.getRequestParams(this.uriInfo);
        String oper = RuntimeResource.getRelativePath(this.uriInfo);
        Map<String, Object> params = RuntimeResource.extractMapFromParams(requestParams, oper);
        ProcessInstance procInst = this.startProcessInstance(processId, params);
        Map<String, String> vars = this.getVariables(procInst.getId());
        JaxbProcessInstanceWithVariablesResponse resp = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.uriInfo.getRequestUri().toString());
        return RuntimeResource.createCorrectVariant(resp, this.headers);
    }

    @GET
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}")
    public Response withvars_process_instance_procInstId(@PathParam(value="procInstId") Long procInstId) {
        ProcessInstance procInst = this.getProcessInstance(procInstId);
        Map<String, String> vars = this.getVariables(procInstId);
        JaxbProcessInstanceWithVariablesResponse responseObj = new JaxbProcessInstanceWithVariablesResponse(procInst, vars, this.uriInfo.getRequestUri().toString());
        return RuntimeResource.createCorrectVariant(responseObj, this.headers);
    }

    @POST
    @Path(value="/withvars/process/instance/{procInstId: [0-9]+}/signal")
    public Response withvars_process_instance_procInstid_signal(@PathParam(value="procInstId") Long procInstId) {
        String oper = RuntimeResource.getRelativePath(this.uriInfo);
        Map<String, List<String>> params = RuntimeResource.getRequestParams(this.uriInfo);
        String eventType = RuntimeResource.getStringParam("signal", true, params, oper);
        Object event = RuntimeResource.getObjectParam("event", false, params, oper);
        this.processRequestBean.doKieSessionOperation((Command<?>)new SignalEventCommand(procInstId.longValue(), eventType, event), this.deploymentId, procInstId);
        ProcessInstance processInstance = this.getProcessInstance(procInstId);
        Map<String, String> vars = this.getVariables(processInstance.getId());
        return RuntimeResource.createCorrectVariant(new JaxbProcessInstanceWithVariablesResponse(processInstance, vars), this.headers);
    }

    private ProcessInstance getProcessInstance(long procInstId) {
        GetProcessInstanceCommand cmd = new GetProcessInstanceCommand(Long.valueOf(procInstId));
        cmd.setReadOnly(true);
        Object procInstResult = this.processRequestBean.doKieSessionOperation((Command<?>)cmd, this.deploymentId, procInstId);
        if (procInstResult != null) {
            return (ProcessInstance)procInstResult;
        }
        throw RestOperationException.notFound("Unable to retrieve process instance " + procInstId + " which may have been completed. Please see the history operations.");
    }

    private Map<String, String> getVariables(long processInstanceId) {
        Object result = this.processRequestBean.doKieSessionOperation((Command<?>)new FindVariableInstancesCommand(processInstanceId), this.deploymentId, processInstanceId);
        List varInstLogList = (List)result;
        HashMap<String, String> vars = new HashMap<String, String>();
        if (varInstLogList.isEmpty()) {
            return vars;
        }
        HashMap<String, VariableInstanceLog> varLogMap = new HashMap<String, VariableInstanceLog>();
        for (VariableInstanceLog variableInstanceLog : varInstLogList) {
            String varId = variableInstanceLog.getVariableId();
            VariableInstanceLog prevVarLog = varLogMap.put(varId, variableInstanceLog);
            if (prevVarLog == null || !prevVarLog.getDate().after(variableInstanceLog.getDate())) continue;
            varLogMap.put(varId, prevVarLog);
        }
        for (Map.Entry entry : varLogMap.entrySet()) {
            vars.put((String)entry.getKey(), ((VariableInstanceLog)entry.getValue()).getValue());
        }
        return vars;
    }

    private ProcessInstance startProcessInstance(String processId, Map<String, Object> params) {
        Object result = null;
        try {
            result = this.processRequestBean.doKieSessionOperation((Command<?>)new StartProcessCommand(processId, params), this.deploymentId, null);
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().startsWith("Unknown process ID")) {
                throw RestOperationException.notFound("Process '" + processId + "' is not known to this deployment.");
            }
            throw iae;
        }
        return (ProcessInstance)result;
    }

    protected QName getRootElementName(Object object) {
        boolean xmlRootElemAnnoFound = false;
        Class<?> objClass = object.getClass();
        XmlRootElement xmlRootElemAnno = objClass.getAnnotation(XmlRootElement.class);
        logger.debug("Getting XML root element annotation for " + object.getClass().getName());
        if (xmlRootElemAnno != null) {
            xmlRootElemAnnoFound = true;
            return new QName(xmlRootElemAnno.name());
        }
        for (Annotation anno : objClass.getAnnotations()) {
            Class<? extends Annotation> annoClass = anno.annotationType();
            if (!XmlRootElement.class.getName().equals(annoClass.getName())) continue;
            xmlRootElemAnnoFound = true;
            try {
                Method nameMethod = annoClass.getMethod("name", new Class[0]);
                Object nameVal = nameMethod.invoke((Object)anno, new Object[0]);
                if (!(nameVal instanceof String)) continue;
                return new QName((String)nameVal);
            }
            catch (Exception e) {
                throw RestOperationException.internalServerError("Unable to retrieve XmlRootElement info via reflection", e);
            }
        }
        if (!xmlRootElemAnnoFound) {
            String errorMsg = "Unable to serialize " + object.getClass().getName() + " instance " + "because it is missing a " + XmlRootElement.class.getName() + " annotation with a name value.";
            throw RestOperationException.internalServerError(errorMsg);
        }
        return null;
    }
}

